/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.parser.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Deque;
import java.util.Enumeration;
import java.util.LinkedList;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempBundleDelegatingClassLoader
extends ClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(TempBundleDelegatingClassLoader.class);
    private final Bundle bundle;
    private final ThreadLocal<Deque<Bundle>> currentLoadingBundle = new ThreadLocal<Deque<Bundle>>(){

        @Override
        protected Deque<Bundle> initialValue() {
            return new LinkedList<Bundle>();
        }
    };

    public TempBundleDelegatingClassLoader(Bundle b, ClassLoader parent) {
        super(parent);
        this.bundle = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        String classResName = className.replace('.', '/').concat(".class");
        Bundle currentContext = this.currentLoadingBundle.get().peek();
        InputStream is = currentContext == null ? this.getResourceAsStream(classResName) : this.getResourceInBundleAsStream(classResName, currentContext);
        if (is == null) {
            throw new ClassNotFoundException(className);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buff = new byte[4096];
        try {
            try {
                int read = is.read(buff);
                while (read > 0) {
                    baos.write(buff, 0, read);
                    read = is.read(buff);
                }
            }
            finally {
                is.close();
            }
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(className, ioe);
        }
        buff = baos.toByteArray();
        this.updateContext(currentContext, className);
        try {
            Class<?> clazz = this.defineClass(className, buff, 0, buff.length);
            return clazz;
        }
        finally {
            this.currentLoadingBundle.get().pop();
        }
    }

    private void updateContext(Bundle currentContext, String className) {
        Bundle contextToSet = currentContext == null ? this.bundle : currentContext;
        int idx = className.lastIndexOf(46);
        String packageName = idx == -1 ? "" : className.substring(0, idx);
        BundleWiring wiring = (BundleWiring)contextToSet.adapt(BundleWiring.class);
        for (BundleWire wire : wiring.getRequiredWires("osgi.wiring.package")) {
            if (!wire.getCapability().getAttributes().get("osgi.wiring.package").equals(packageName)) continue;
            contextToSet = wire.getProviderWiring().getBundle();
            break;
        }
        this.currentLoadingBundle.get().push(contextToSet);
    }

    @Override
    protected URL findResource(String resName) {
        return this.findResourceInBundle(resName, this.bundle);
    }

    private URL findResourceInBundle(final String resName, final Bundle inBundle) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return inBundle.getResource(resName);
            }
        });
    }

    private InputStream getResourceInBundleAsStream(String resName, Bundle inBundle) {
        URL url = this.findResourceInBundle(resName, inBundle);
        try {
            return url == null ? null : url.openStream();
        }
        catch (IOException e) {
            LOG.debug("Exception on openStream", (Throwable)e);
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(String resName) throws IOException {
        return this.findResourcesInBundle(resName, this.bundle);
    }

    private Enumeration<URL> findResourcesInBundle(final String resName, final Bundle inBundle) throws IOException {
        Enumeration<URL> resources = null;
        try {
            resources = AccessController.doPrivileged(new PrivilegedExceptionAction<Enumeration<URL>>(){

                @Override
                public Enumeration<URL> run() throws IOException {
                    return inBundle.getResources(resName);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception thrownException = pae.getException();
            if (thrownException instanceof IOException) {
                throw (IOException)thrownException;
            }
            LOG.warn("Exception during findResourcesInBundle", (Throwable)pae);
        }
        return resources;
    }
}

