/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.unit.impl;

import java.sql.SQLFeatureNotSupportedException;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.aries.jpa.container.impl.NLS;
import org.apache.aries.jpa.container.unit.impl.DelayedLookupDataSource;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiDataSource
extends DelayedLookupDataSource {
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.container");
    private AtomicReference<DataSource> ds = new AtomicReference();
    private final String jndiName;
    private final String unitName;
    private final Bundle persistenceBundle;
    private final boolean jta;

    public JndiDataSource(String jndi, String unit, Bundle persistenceBundle, boolean jta) {
        this.jndiName = jndi;
        this.unitName = unit;
        this.persistenceBundle = persistenceBundle;
        this.jta = jta;
    }

    @Override
    protected DataSource getDs() {
        block8: {
            if (this.ds.get() == null) {
                try {
                    Hashtable<String, BundleContext> props = new Hashtable<String, BundleContext>();
                    BundleContext bCtx = this.persistenceBundle.getBundleContext();
                    if (bCtx == null) {
                        throw new IllegalStateException(NLS.MESSAGES.getMessage("persistence.bundle.not.active", new Object[]{this.persistenceBundle.getSymbolicName(), this.persistenceBundle.getVersion()}));
                    }
                    props.put("osgi.service.jndi.bundleContext", bCtx);
                    InitialContext ctx = new InitialContext(props);
                    Object o = ctx.lookup(this.jndiName);
                    if (o instanceof XADataSource) {
                        if (this.jta) {
                            this.ds.compareAndSet(null, this.wrapXADataSource((XADataSource)o));
                            break block8;
                        }
                        if (o instanceof DataSource) {
                            this.ds.compareAndSet(null, (DataSource)o);
                            break block8;
                        }
                        throw new IllegalArgumentException(NLS.MESSAGES.getMessage("xa.datasource.non.tx", new Object[]{this.unitName, this.persistenceBundle.getSymbolicName(), this.persistenceBundle.getVersion(), this.jndiName}));
                    }
                    if (o instanceof DataSource) {
                        this.ds.compareAndSet(null, (DataSource)o);
                        break block8;
                    }
                    throw new IllegalArgumentException(NLS.MESSAGES.getMessage("not.a.datasource", new Object[]{this.unitName, this.persistenceBundle.getSymbolicName(), this.persistenceBundle.getVersion(), this.jndiName}));
                }
                catch (NamingException e) {
                    String message = NLS.MESSAGES.getMessage("no.data.source.found", new Object[]{this.jndiName, this.persistenceBundle.getSymbolicName(), this.persistenceBundle.getVersion()});
                    _logger.error(message, (Throwable)e);
                    throw new RuntimeException(message, e);
                }
            }
        }
        return this.ds.get();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

