/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.parsing.impl;

import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.aries.jpa.container.parsing.impl.EarlyParserReturn;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SchemaLocatingHandler
extends DefaultHandler {
    private static final String PERSISTENCE_NS_URI = "http://java.sun.com/xml/ns/persistence";
    private static final String PERSISTENCE_21_NS_URI = "http://xmlns.jcp.org/xml/ns/persistence";
    private static final ConcurrentMap<String, Schema> schemaCache = new ConcurrentHashMap<String, Schema>();

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        Schema s = null;
        String version = null;
        if ((PERSISTENCE_NS_URI.equals(uri) || PERSISTENCE_21_NS_URI.equals(uri)) && "persistence".equals(localName)) {
            version = attributes.getValue("version");
            s = this.validate(version);
        }
        throw new EarlyParserReturn(s, version);
    }

    private final Schema validate(String type) throws SAXException {
        Schema toReturn;
        Schema schema = toReturn = type == null ? null : (Schema)schemaCache.get(type);
        if (toReturn == null && (toReturn = this.getSchema(type)) != null) {
            schemaCache.putIfAbsent(type, toReturn);
        }
        return toReturn;
    }

    private final Schema getSchema(String type) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaURL = null;
        if ("1.0".equals(type)) {
            schemaURL = this.getClass().getResource("persistence.xsd.rsrc");
        } else if ("2.0".equals(type)) {
            schemaURL = this.getClass().getResource("persistence_2_0.xsd.rsrc");
        } else if ("2.1".equals(type)) {
            schemaURL = this.getClass().getResource("persistence_2_1.xsd.rsrc");
        }
        Schema schema = null;
        if (schemaURL != null) {
            schema = schemaFactory.newSchema(schemaURL);
        }
        return schema;
    }
}

