/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.component.dsl.internal;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.component.dsl.OSGiResult;
import org.apache.aries.component.dsl.Publisher;

public class OnlyLastPublisher<T>
implements Publisher<T> {
    private final Publisher<? super T> _op;
    private AtomicLong _counter = new AtomicLong();
    private Supplier<T> _injectOnLeave;
    private Runnable _terminator;

    public OnlyLastPublisher(Publisher<? super T> op) {
        this(op, null);
    }

    public OnlyLastPublisher(Publisher<? super T> op, Supplier<T> injectOnLeave) {
        this._op = op;
        this._injectOnLeave = injectOnLeave;
        this._terminator = OSGi.NOOP;
    }

    @Override
    public synchronized OSGiResult publish(T t) {
        this._terminator.run();
        this._terminator = this._op.publish(t);
        if (this._injectOnLeave == null) {
            return OSGi.NOOP;
        }
        this._counter.incrementAndGet();
        return () -> {
            this._terminator.run();
            if (this._counter.decrementAndGet() > 0L) {
                this._terminator = this._op.publish(this._injectOnLeave.get());
            }
        };
    }
}

