/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.dto.ServiceReferenceDTO;

public class SRs {
    private SRs() {
    }

    public static <T> ServiceReferenceDTO from(ServiceReference<T> reference) {
        for (ServiceReferenceDTO dto : (ServiceReferenceDTO[])reference.getBundle().adapt(ServiceReferenceDTO[].class)) {
            if (dto.id != SRs.id(reference)) continue;
            return dto;
        }
        return null;
    }

    @SafeVarargs
    public static <T> List<ServiceReferenceDTO> from(ServiceReference<T>[] references, ServiceReference<T> ... more) {
        if (references == null) {
            return Arrays.stream(more).sorted().map(r -> SRs.from(r)).collect(Collectors.toList());
        }
        return Stream.concat(Arrays.stream(references), Arrays.stream(more)).sorted().map(r -> SRs.from(r)).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <T> List<ServiceReferenceDTO> from(Collection<ServiceReference<T>> references, ServiceReference<T> ... more) {
        return Stream.concat(references.stream(), Arrays.stream(more)).sorted().map(r -> SRs.from(r)).collect(Collectors.toList());
    }

    public static <T> long id(ServiceReference<T> reference) {
        return (Long)reference.getProperty("service.id");
    }
}

