/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;

public class Reflection {
    private Reflection() {
    }

    public static Stream<Constructor<?>> allConstructors(Class<?> declaringClass) {
        HashSet allconstructors = new HashSet();
        allconstructors.addAll(Arrays.asList(declaringClass.getConstructors()));
        allconstructors.addAll(Arrays.asList(declaringClass.getDeclaredConstructors()));
        return allconstructors.stream().distinct();
    }

    public static Stream<Field> allFields(Class<?> declaringClass) {
        HashSet<Field> allfields = new HashSet<Field>();
        allfields.addAll(Arrays.asList(declaringClass.getFields()));
        allfields.addAll(Arrays.asList(declaringClass.getDeclaredFields()));
        return allfields.stream().distinct();
    }

    public static Stream<Method> allMethods(Class<?> declaringClass) {
        HashSet<Method> allmethods = new HashSet<Method>();
        allmethods.addAll(Arrays.asList(declaringClass.getMethods()));
        allmethods.addAll(Arrays.asList(declaringClass.getDeclaredMethods()));
        return allmethods.stream().distinct();
    }

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static Set<Type> getTypes(Type type) {
        HashSet<Type> types = new HashSet<Type>();
        types.add(type);
        Class rawType = Reflection.getRawType(type);
        if (rawType != null) {
            for (Type iface : rawType.getGenericInterfaces()) {
                types.addAll(Reflection.getTypes(iface));
            }
            types.addAll(Reflection.getTypes(rawType.getGenericSuperclass()));
        }
        types.remove(Serializable.class);
        return types;
    }

    public static <T> Class<T> getRawType(Type type) {
        GenericArrayType genericArrayType;
        Class<T> rawType;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() instanceof Class) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type;
            Type[] bounds = variable.getBounds();
            return Reflection.getBound(bounds);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type;
            return Reflection.getBound(wildcard.getUpperBounds());
        }
        if (type instanceof GenericArrayType && (rawType = Reflection.getRawType((genericArrayType = (GenericArrayType)type).getGenericComponentType())) != null) {
            return Array.newInstance(rawType, 0).getClass();
        }
        return null;
    }

    static <T> Class<T> getBound(Type[] bounds) {
        if (bounds.length == 0) {
            return Object.class;
        }
        return Reflection.getRawType(bounds[0]);
    }
}

