/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Qualifier;
import org.apache.aries.cdi.container.internal.model.CollectionType;
import org.apache.aries.cdi.container.internal.model.ExtendedReferenceTemplateDTO;
import org.apache.aries.cdi.container.internal.util.Conversions;
import org.apache.aries.cdi.container.internal.util.Filters;
import org.apache.aries.cdi.container.internal.util.Maps;
import org.apache.aries.cdi.container.internal.util.Reflection;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cdi.MaximumCardinality;
import org.osgi.service.cdi.ReferencePolicy;
import org.osgi.service.cdi.ReferencePolicyOption;
import org.osgi.service.cdi.annotations.BeanPropertyType;
import org.osgi.service.cdi.annotations.PrototypeRequired;
import org.osgi.service.cdi.annotations.Reference;
import org.osgi.service.cdi.annotations.Reluctant;
import org.osgi.service.cdi.reference.BeanServiceObjects;
import org.osgi.service.cdi.reference.BindBeanServiceObjects;
import org.osgi.service.cdi.reference.BindService;
import org.osgi.service.cdi.reference.BindServiceReference;
import org.osgi.util.converter.TypeReference;

public class ReferenceModel {
    private static final TypeReference<Map<String, String>> _mapType = new TypeReference<Map<String, String>>(){};
    private static final String _emptyFilter = "";
    private final Annotated _annotated;
    private Class<?> _beanClass;
    private CollectionType _collectionType = CollectionType.SERVICE;
    private final Class<?> _declaringClass;
    private boolean _dynamic = false;
    private boolean _greedy = true;
    private final Type _injectionPointType;
    private MaximumCardinality _multiplicity = MaximumCardinality.ONE;
    private final String _name;
    private boolean _optional = false;
    private final boolean _prototype;
    private final Reference _reference;
    private final Optional<Class<?>> _referenceType;
    private final Optional<String> _referenceTarget;
    private Class<?> _serviceType;
    private String _string;
    private final String _targetFilter;

    private ReferenceModel(Type injectionPointType, Class<?> declaringClass, Annotated annotated) {
        this._annotated = annotated;
        this._injectionPointType = injectionPointType;
        this._declaringClass = declaringClass;
        this._reference = (Reference)this._annotated.getAnnotation(Reference.class);
        this._referenceType = this.getReferenceType();
        this._referenceTarget = this.getReferenceTarget();
        this._prototype = this.getQualifiers().stream().filter(ann -> ann.annotationType().equals(PrototypeRequired.class)).findFirst().isPresent();
        this.calculateServiceType(this._injectionPointType);
        this._referenceType.ifPresent(c -> {
            if (this._serviceType != null && !this._serviceType.isAssignableFrom((Class<?>)c)) {
                throw new IllegalArgumentException("The service type specified in @Reference (" + c + ") is not compatible with the type calculated from the injection point: " + this._serviceType + " on " + this._annotated);
            }
            this._serviceType = c;
        });
        Type rawType = this._injectionPointType;
        if (rawType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)Reflection.cast(this._injectionPointType);
            rawType = pt.getRawType();
        }
        this._beanClass = (Class)Reflection.cast(rawType);
        this._name = this.calculateName(this._serviceType, this._annotated);
        if (this._annotated.isAnnotationPresent(Reluctant.class)) {
            this._greedy = false;
        }
        this._targetFilter = this.buildFilter();
    }

    private Optional<String> getReferenceTarget() {
        if (this._reference != null && this._reference.target().length() > 0) {
            return Optional.of(this._reference.target());
        }
        return Optional.empty();
    }

    private Optional<Class<?>> getReferenceType() {
        if (this._reference != null && this._reference.value() != null && this._reference.value() != Object.class && this._reference.value() != Reference.Any.class) {
            return Optional.of(this._reference.value());
        }
        return Optional.empty();
    }

    public Annotated getAnnotated() {
        return this._annotated;
    }

    public Class<?> getBeanClass() {
        return this._beanClass;
    }

    public CollectionType getCollectionType() {
        return this._collectionType;
    }

    public Type getInjectionPointType() {
        return this._injectionPointType;
    }

    public String getName() {
        return this._name;
    }

    public Set<Annotation> getQualifiers() {
        return this._annotated.getAnnotations().stream().filter(ann -> ann.annotationType().isAnnotationPresent(Qualifier.class)).collect(Collectors.toSet());
    }

    public Class<?> getServiceType() {
        return this._serviceType;
    }

    public String getTarget() {
        return this._targetFilter;
    }

    public boolean dynamic() {
        return this._dynamic;
    }

    public boolean optional() {
        return this._optional;
    }

    public ExtendedReferenceTemplateDTO toDTO() {
        ExtendedReferenceTemplateDTO dto = new ExtendedReferenceTemplateDTO();
        dto.beanClass = this._beanClass;
        dto.collectionType = this._collectionType;
        dto.declaringClass = this._declaringClass;
        dto.injectionPointType = this._injectionPointType;
        dto.maximumCardinality = this._multiplicity;
        dto.minimumCardinality = this._multiplicity == MaximumCardinality.ONE ? (this._optional ? 0 : 1) : 0;
        dto.name = this._name;
        dto.policy = this._dynamic ? ReferencePolicy.DYNAMIC : ReferencePolicy.STATIC;
        dto.policyOption = this._greedy ? ReferencePolicyOption.GREEDY : ReferencePolicyOption.RELUCTANT;
        dto.serviceClass = this._serviceType;
        dto.serviceType = this._serviceType.getName();
        dto.targetFilter = this._targetFilter;
        return dto;
    }

    public String toString() {
        if (this._string == null) {
            this._string = this.toDTO().toString();
        }
        return this._string;
    }

    public boolean unary() {
        return this._multiplicity == MaximumCardinality.ONE;
    }

    private String buildFilter() {
        String targetFilter = this._referenceTarget.orElse(_emptyFilter);
        boolean filterValid = false;
        int targetFilterLength = targetFilter.length();
        if (targetFilterLength > 0 && Filters.isValid(targetFilter)) {
            filterValid = true;
        }
        List<Annotation> beanPropertyTypes = this._annotated.getAnnotations().stream().filter(ann -> ann.annotationType().getAnnotation(BeanPropertyType.class) != null).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        if (this._prototype && filterValid || !beanPropertyTypes.isEmpty()) {
            sb.append("(&");
        }
        beanPropertyTypes.forEach(ann -> {
            Map map = (Map)Conversions.convert(ann).to(_mapType);
            Maps.appendFilter(sb, map);
        });
        if (this._prototype) {
            sb.append("(");
            sb.append("service.scope");
            sb.append("=");
            sb.append("prototype");
            sb.append(")");
        }
        if (filterValid) {
            sb.append(targetFilter);
        }
        if (this._prototype && filterValid || !beanPropertyTypes.isEmpty()) {
            sb.append(")");
        }
        return sb.toString();
    }

    private String calculateName(Class<?> service, Annotated annotated) {
        Named named = (Named)annotated.getAnnotation(Named.class);
        if (named != null) {
            if (named.value() == null | named.value().equals(_emptyFilter)) {
                throw new IllegalArgumentException("It's illegal to specify @Name without specifying a value with @Reference: " + annotated + " on " + this._annotated);
            }
            return named.value();
        }
        String prefix = this._declaringClass.getName() + ".";
        if (annotated instanceof AnnotatedParameter) {
            AnnotatedParameter parameter = (AnnotatedParameter)annotated;
            AnnotatedCallable declaringCallable = parameter.getDeclaringCallable();
            if (declaringCallable instanceof AnnotatedConstructor) {
                return prefix + "new" + parameter.getPosition();
            }
            AnnotatedMethod method = (AnnotatedMethod)declaringCallable;
            return prefix + method.getJavaMember().getName() + parameter.getPosition();
        }
        if (annotated instanceof AnnotatedMethod) {
            AnnotatedMethod method = (AnnotatedMethod)annotated;
            return prefix + method.getJavaMember().getName();
        }
        AnnotatedField annotatedField = (AnnotatedField)annotated;
        return prefix + annotatedField.getJavaMember().getName();
    }

    private void calculateServiceType(Type type) {
        if (!(type instanceof ParameterizedType)) {
            if (!(type instanceof Class)) {
                throw new IllegalArgumentException("The service type must not be generic: " + type + " on " + this._annotated);
            }
            Class clazz = (Class)Reflection.cast(type);
            if (Map.class == clazz) {
                throw new IllegalArgumentException("Map must specify a generic type arguments: " + clazz);
            }
            if (Map.Entry.class == clazz) {
                throw new IllegalArgumentException("Map.Entry must specify a generic type arguments: " + clazz);
            }
            if (BeanServiceObjects.class == clazz && !this._referenceType.isPresent()) {
                throw new IllegalArgumentException("ReferenceServiceObjects must specify a generic type argument: " + clazz);
            }
            if (ServiceReference.class == clazz && !this._referenceType.isPresent()) {
                throw new IllegalArgumentException("ServiceReference must specify a generic type argument: " + type);
            }
            if (!(Collection.class != clazz && List.class != clazz || this._referenceType.isPresent())) {
                throw new IllegalArgumentException(type + " must specify a generic type argument");
            }
            if (BeanServiceObjects.class == clazz) {
                this._collectionType = CollectionType.SERVICEOBJECTS;
                return;
            }
            if (ServiceReference.class == clazz) {
                this._collectionType = CollectionType.REFERENCE;
                return;
            }
            if (Collection.class == clazz || List.class == clazz) {
                this._collectionType = CollectionType.SERVICE;
                this._multiplicity = MaximumCardinality.MANY;
                this._optional = true;
                return;
            }
            this._serviceType = clazz;
            return;
        }
        ParameterizedType parameterizedType = (ParameterizedType)Reflection.cast(type);
        Type rawType = parameterizedType.getRawType();
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        Type argument = actualTypeArguments[0];
        if (Instance.class == Reflection.cast(rawType)) {
            throw new IllegalArgumentException("Instance<T> is not supported with @Reference: " + type);
        }
        if (BindService.class.isAssignableFrom((Class)Reflection.cast(rawType))) {
            this._collectionType = CollectionType.BINDER_SERVICE;
            this._dynamic = true;
            this._multiplicity = MaximumCardinality.MANY;
            this._optional = true;
            if (argument instanceof WildcardType || argument instanceof ParameterizedType) {
                throw new IllegalArgumentException("Type argument <S> of BindObject must not be generic: " + argument);
            }
            this._serviceType = (Class)Reflection.cast(argument);
            return;
        }
        if (BindServiceReference.class.isAssignableFrom((Class)Reflection.cast(rawType))) {
            this._collectionType = CollectionType.BINDER_REFERENCE;
            this._dynamic = true;
            this._multiplicity = MaximumCardinality.MANY;
            this._optional = true;
            if (argument instanceof WildcardType || argument instanceof ParameterizedType) {
                throw new IllegalArgumentException("Type argument <S> of BindServiceReference must not be generic: " + argument);
            }
            this._serviceType = (Class)Reflection.cast(argument);
            return;
        }
        if (BindBeanServiceObjects.class.isAssignableFrom((Class)Reflection.cast(rawType))) {
            this._collectionType = CollectionType.BINDER_BEAN_SERVICE_OBJECTS;
            this._dynamic = true;
            this._multiplicity = MaximumCardinality.MANY;
            this._optional = true;
            if (argument instanceof WildcardType || argument instanceof ParameterizedType) {
                throw new IllegalArgumentException("Type argument <S> of BindServiceObjects must not be generic: " + argument);
            }
            this._serviceType = (Class)Reflection.cast(argument);
            return;
        }
        if (!this._dynamic && Provider.class == Reflection.cast(rawType)) {
            this._dynamic = true;
            this.calculateServiceType(argument);
            return;
        }
        if (!this._optional && Optional.class == Reflection.cast(rawType)) {
            this._optional = true;
            if (argument instanceof WildcardType && this._referenceType.isPresent()) {
                return;
            }
            this.calculateServiceType(argument);
            return;
        }
        if (this._multiplicity == MaximumCardinality.ONE && (Collection.class == Reflection.cast(rawType) || List.class == Reflection.cast(rawType))) {
            this._optional = true;
            this._multiplicity = MaximumCardinality.MANY;
            if (argument instanceof WildcardType && this._referenceType.isPresent()) {
                return;
            }
            this.calculateServiceType(argument);
            return;
        }
        if (Map.class == Reflection.cast(rawType)) {
            if (String.class != Reflection.cast(argument)) {
                throw new IllegalArgumentException("Maps of properties must use the form Map<String, (? | Object)>: " + type);
            }
            argument = actualTypeArguments[1];
            if (Object.class != Reflection.cast(argument) && !(argument instanceof WildcardType)) {
                throw new IllegalArgumentException("Maps of properties must use the form Map<String, (? | Object)>: " + type);
            }
            this._collectionType = CollectionType.PROPERTIES;
            if (!this._referenceType.isPresent()) {
                throw new IllegalArgumentException("Maps of properties must specify service type with @Reference.value(): " + argument + " on " + this._annotated);
            }
            return;
        }
        if (Map.Entry.class == Reflection.cast(rawType)) {
            if (!ReferenceModel.checkKey(argument)) {
                throw new IllegalArgumentException("Tuples must have a key of type Map<String, (? | Object)>: " + argument + " on " + this._annotated);
            }
            this._collectionType = CollectionType.TUPLE;
            Type second = actualTypeArguments[1];
            if (second instanceof WildcardType && this._referenceType.isPresent()) {
                return;
            }
            if (!(second instanceof Class)) {
                throw new IllegalArgumentException("The service type must not be generic: " + second + " on " + this._annotated);
            }
            this._serviceType = (Class)Reflection.cast(second);
            return;
        }
        if (BeanServiceObjects.class == Reflection.cast(rawType)) {
            this._collectionType = CollectionType.SERVICEOBJECTS;
            if (argument instanceof WildcardType && this._referenceType.isPresent()) {
                return;
            }
            this.calculateServiceType(argument);
            return;
        }
        if (ServiceReference.class == Reflection.cast(rawType)) {
            this._collectionType = CollectionType.REFERENCE;
            if (argument instanceof WildcardType && this._referenceType.isPresent()) {
                return;
            }
            this.calculateServiceType(argument);
            return;
        }
        this._serviceType = (Class)Reflection.cast(rawType);
        if (this._serviceType.getTypeParameters().length > 0) {
            throw new IllegalArgumentException("Illegal service type: " + argument + " on " + this._annotated);
        }
    }

    private static boolean checkKey(Type mapEntryType) {
        if (!(mapEntryType instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType parameterizedKeyType = (ParameterizedType)mapEntryType;
        if (!Map.class.isAssignableFrom((Class)Reflection.cast(parameterizedKeyType.getRawType())) || !parameterizedKeyType.getActualTypeArguments()[0].equals(String.class)) {
            return false;
        }
        Type valueType = parameterizedKeyType.getActualTypeArguments()[1];
        return valueType.equals(Object.class) || valueType instanceof WildcardType && ((WildcardType)valueType).getUpperBounds().length == 1 && ((WildcardType)valueType).getUpperBounds()[0].equals(Object.class);
    }

    public static enum Scope {
        BUNDLE,
        PROTOTYPE,
        SINGLETON;

    }

    public static class Builder {
        private Annotated _annotated;
        private Class<?> _declaringClass;
        private Type _type;

        public Builder(Annotated annotated) {
            this._annotated = annotated;
            if (this._annotated instanceof AnnotatedParameter) {
                AnnotatedParameter parameter = (AnnotatedParameter)this._annotated;
                this._declaringClass = parameter.getDeclaringCallable().getDeclaringType().getJavaClass();
            } else if (this._annotated instanceof AnnotatedField || this._annotated instanceof AnnotatedMethod) {
                AnnotatedField field = (AnnotatedField)this._annotated;
                this._declaringClass = field.getDeclaringType().getJavaClass();
            }
        }

        public ReferenceModel build() {
            Objects.requireNonNull(this._annotated);
            Objects.requireNonNull(this._declaringClass);
            Objects.requireNonNull(this._type);
            return new ReferenceModel(this._type, this._declaringClass, this._annotated);
        }

        public Builder type(Type type) {
            this._type = type;
            return this;
        }
    }
}

