/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.container;

import java.lang.annotation.Annotation;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.configurator.BeanConfigurator;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.osgi.service.log.FormatterLogger;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;

public class LoggerExtension
implements Extension {
    private final ContainerState _containerState;

    protected LoggerExtension() {
        this(null);
    }

    public LoggerExtension(ContainerState containerState) {
        this._containerState = containerState;
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd) {
        LoggerFactory lf = this._containerState.containerLogs().getLoggerFactory();
        if (lf == null) {
            return;
        }
        BeanConfigurator formatterLoggerBean = abd.addBean();
        formatterLoggerBean.addType(FormatterLogger.class);
        formatterLoggerBean.produceWith(i -> {
            InjectionPoint ip = (InjectionPoint)i.select(InjectionPoint.class, new Annotation[0]).get();
            return (FormatterLogger)lf.getLogger(ip.getMember().getDeclaringClass().getName(), FormatterLogger.class);
        });
        BeanConfigurator loggerBean = abd.addBean();
        loggerBean.addType(Logger.class);
        loggerBean.produceWith(i -> {
            InjectionPoint ip = (InjectionPoint)i.select(InjectionPoint.class, new Annotation[0]).get();
            return lf.getLogger(ip.getMember().getDeclaringClass().getName(), Logger.class);
        });
    }
}

