/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.container;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.aries.cdi.container.internal.ChangeCount;
import org.apache.aries.cdi.container.internal.container.CheckedCallback;
import org.apache.aries.cdi.container.internal.container.ComponentContext;
import org.apache.aries.cdi.container.internal.container.Discovery;
import org.apache.aries.cdi.container.internal.container.Op;
import org.apache.aries.cdi.container.internal.loader.BundleClassLoader;
import org.apache.aries.cdi.container.internal.model.BeansModel;
import org.apache.aries.cdi.container.internal.model.BeansModelBuilder;
import org.apache.aries.cdi.container.internal.model.ExtendedConfigurationTemplateDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedExtensionTemplateDTO;
import org.apache.aries.cdi.container.internal.util.Filters;
import org.apache.aries.cdi.container.internal.util.Logs;
import org.apache.aries.cdi.container.internal.util.Throw;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.dto.BundleDTO;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.cdi.ComponentType;
import org.osgi.service.cdi.ConfigurationPolicy;
import org.osgi.service.cdi.MaximumCardinality;
import org.osgi.service.cdi.runtime.dto.ContainerDTO;
import org.osgi.service.cdi.runtime.dto.template.ComponentTemplateDTO;
import org.osgi.service.cdi.runtime.dto.template.ContainerTemplateDTO;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.log.Logger;
import org.osgi.util.promise.Deferred;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;
import org.osgi.util.tracker.ServiceTracker;

public class ContainerState {
    private final BundleClassLoader _aggregateClassLoader;
    private volatile Deferred<BeanManager> _beanManagerDeferred;
    private final BeansModel _beansModel;
    private final Bundle _bundle;
    private final BundleContext _bundleContext;
    private final Map<CheckedCallback<?, ?>, Deferred<?>> _callbacks = new ConcurrentHashMap();
    private final ServiceTracker<ConfigurationAdmin, ConfigurationAdmin> _caTracker;
    private final Logger _log;
    private final Logs _ccrLogs;
    private final Map<String, Object> _cdiAttributes;
    private final ChangeCount _changeCount;
    private final AtomicBoolean _closing = new AtomicBoolean(false);
    private final ComponentContext _componentContext = new ComponentContext();
    private final ContainerDTO _containerDTO;
    private final Logs _containerLogs;
    private final ComponentTemplateDTO _containerComponentTemplateDTO;
    private final Bundle _extenderBundle;
    private final PromiseFactory _promiseFactory;

    public ContainerState(Bundle bundle, Bundle extenderBundle, ChangeCount ccrChangeCount, PromiseFactory promiseFactory, ServiceTracker<ConfigurationAdmin, ConfigurationAdmin> caTracker, Logs ccrLogs) {
        this._bundle = bundle;
        this._extenderBundle = extenderBundle;
        this._ccrLogs = ccrLogs;
        this._bundleContext = bundle.getBundleContext();
        this._log = this._ccrLogs.getLogger(this.getClass());
        this._containerLogs = new Logs.Builder(this._bundleContext).build();
        this._changeCount = new ChangeCount();
        this._changeCount.addObserver(ccrChangeCount);
        this._promiseFactory = promiseFactory;
        this._caTracker = caTracker;
        BundleWiring bundleWiring = (BundleWiring)this._bundle.adapt(BundleWiring.class);
        Map cdiAttributes = Collections.emptyMap();
        for (BundleWire wire : bundleWiring.getRequiredWires("osgi.extender")) {
            BundleCapability capability = wire.getCapability();
            Map attributes = capability.getAttributes();
            String extender = (String)attributes.get("osgi.extender");
            if (!extender.equals("osgi.cdi")) continue;
            BundleRequirement requirement = wire.getRequirement();
            cdiAttributes = requirement.getAttributes();
            break;
        }
        this._cdiAttributes = Collections.unmodifiableMap(cdiAttributes);
        HashSet<String> extensionRequirements = new HashSet<String>();
        this.collectExtensionRequirements(bundleWiring, extensionRequirements);
        this._containerDTO = new ContainerDTO();
        this._containerDTO.bundle = (BundleDTO)this._bundle.adapt(BundleDTO.class);
        this._containerDTO.changeCount = this._changeCount.get();
        this._containerDTO.components = new CopyOnWriteArrayList();
        this._containerDTO.errors = new CopyOnWriteArrayList();
        this._containerDTO.extensions = new CopyOnWriteArrayList();
        this._containerDTO.template = new ContainerTemplateDTO();
        this._containerDTO.template.components = new CopyOnWriteArrayList();
        this._containerDTO.template.extensions = new CopyOnWriteArrayList();
        this._containerDTO.template.id = Optional.ofNullable((String)this._cdiAttributes.get("container.id")).orElse(this._bundle.getSymbolicName());
        extensionRequirements.forEach(extensionFilter -> {
            ExtendedExtensionTemplateDTO extensionTemplateDTO = new ExtendedExtensionTemplateDTO();
            try {
                extensionTemplateDTO.filter = Filters.asFilter(extensionFilter, new Object[0]);
                extensionTemplateDTO.serviceFilter = extensionFilter;
                this._containerDTO.template.extensions.add(extensionTemplateDTO);
            }
            catch (Exception e) {
                this._containerDTO.errors.add(Throw.asString(e));
            }
        });
        this._containerComponentTemplateDTO = new ComponentTemplateDTO();
        this._containerComponentTemplateDTO.activations = new CopyOnWriteArrayList();
        this._containerComponentTemplateDTO.beans = new CopyOnWriteArrayList();
        this._containerComponentTemplateDTO.configurations = new CopyOnWriteArrayList();
        this._containerComponentTemplateDTO.name = this._containerDTO.template.id;
        this._containerComponentTemplateDTO.properties = Collections.emptyMap();
        this._containerComponentTemplateDTO.references = new CopyOnWriteArrayList();
        this._containerComponentTemplateDTO.type = ComponentType.CONTAINER;
        ExtendedConfigurationTemplateDTO configurationTemplate = new ExtendedConfigurationTemplateDTO();
        configurationTemplate.maximumCardinality = MaximumCardinality.ONE;
        configurationTemplate.pid = Optional.ofNullable((String)this._cdiAttributes.get("container.id")).map(s -> s.replaceAll("-", ".")).orElse("osgi.cdi." + this._bundle.getSymbolicName().replaceAll("-", "."));
        configurationTemplate.policy = ConfigurationPolicy.OPTIONAL;
        this._containerComponentTemplateDTO.configurations.add(configurationTemplate);
        this._containerDTO.template.components.add(this._containerComponentTemplateDTO);
        this._aggregateClassLoader = new BundleClassLoader(this._bundle, this._extenderBundle);
        this._beansModel = new BeansModelBuilder(this, (ClassLoader)((Object)this._aggregateClassLoader), bundleWiring, this._cdiAttributes).build();
        try {
            new Discovery(this).discover();
        }
        catch (Exception e) {
            this._log.error(l -> l.error("CCR Discovery resulted in errors on {}", (Object)bundle, (Object)e));
            this._containerDTO.errors.add(Throw.asString(e));
        }
        this._beanManagerDeferred = this._promiseFactory.deferred();
    }

    public <T, R> Promise<R> addCallback(CheckedCallback<T, R> checkedCallback) {
        Deferred deferred = this._promiseFactory.deferred();
        this._callbacks.put(checkedCallback, deferred);
        return deferred.getPromise();
    }

    public BeanManager beanManager() {
        try {
            return (BeanManager)this._beanManagerDeferred.getPromise().timeout(5000L).getValue();
        }
        catch (InterruptedException | InvocationTargetException e) {
            return (BeanManager)Throw.exception(e);
        }
    }

    public void beanManager(BeanManager beanManager) {
        if (this._beanManagerDeferred.getPromise().isDone()) {
            this._beanManagerDeferred = this._promiseFactory.deferred();
        }
        this._beanManagerDeferred.resolve((Object)beanManager);
    }

    public BeansModel beansModel() {
        return this._beansModel;
    }

    public Bundle bundle() {
        return this._bundle;
    }

    public BundleContext bundleContext() {
        return this._bundleContext;
    }

    public ServiceTracker<ConfigurationAdmin, ConfigurationAdmin> caTracker() {
        return this._caTracker;
    }

    public Logs ccrLogs() {
        return this._ccrLogs;
    }

    public Map<String, Object> cdiAttributes() {
        return this._cdiAttributes;
    }

    public BundleClassLoader classLoader() {
        return this._aggregateClassLoader;
    }

    public void closing() {
        try {
            this._closing.set((Boolean)this._promiseFactory.submit(() -> Boolean.TRUE).getValue());
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public ComponentContext componentContext() {
        return this._componentContext;
    }

    public ComponentTemplateDTO containerComponentTemplateDTO() {
        return this._containerComponentTemplateDTO;
    }

    public ContainerDTO containerDTO() {
        this._containerDTO.changeCount = this._changeCount.get();
        return this._containerDTO;
    }

    public Logs containerLogs() {
        return this._containerLogs;
    }

    public void error(Throwable t) {
        this.containerDTO().errors.add(Throw.asString(t));
    }

    public Bundle extenderBundle() {
        return this._extenderBundle;
    }

    public Optional<Configuration> findConfig(String pid) {
        return this.findConfigs(pid, false).map(arr -> arr[0]);
    }

    public Optional<Configuration[]> findConfigs(String pid, boolean factory) {
        try {
            ConfigurationAdmin cm;
            String query = "(service.pid=".concat(pid).concat(")");
            if (factory) {
                query = "(service.factoryPid=".concat(pid).concat(")");
            }
            if ((cm = (ConfigurationAdmin)this._caTracker.getService()) == null) {
                this._log.error(l -> l.error("CCR unexpected error fetching configuration admin for {}", (Object)pid));
                return Optional.empty();
            }
            return Optional.ofNullable(cm.listConfigurations(query));
        }
        catch (Exception e) {
            this._log.warn(l -> l.warn("CCR unexpected error fetching configuration for {}", (Object)pid, (Object)e));
            return Optional.empty();
        }
    }

    public String id() {
        return this._containerDTO.template.id;
    }

    public void incrementChangeCount() {
        this._changeCount.incrementAndGet();
    }

    public PromiseFactory promiseFactory() {
        return this._promiseFactory;
    }

    public <T, R> Promise<T> submit(Op op, Callable<T> task) {
        try {
            switch (op.mode) {
                case CLOSE: {
                    this._log.debug(l -> l.debug("CCR submit {}", (Object)op));
                    return this._promiseFactory.resolved(task.call());
                }
                case OPEN: {
                    if (!this._closing.get()) break;
                    return this._promiseFactory.resolved(new Object());
                }
            }
        }
        catch (Exception e) {
            return this._promiseFactory.failed((Throwable)e);
        }
        this._log.debug(l -> l.debug("CCR submit {}", (Object)op));
        Promise promise = this._promiseFactory.submit(task);
        for (Map.Entry<CheckedCallback<?, ?>, Deferred<?>> entry : this._callbacks.entrySet()) {
            CheckedCallback<?, ?> cc = entry.getKey();
            if (!cc.test(op)) continue;
            entry.getValue().resolveWith(promise.then(cc, cc)).then(s -> {
                this._callbacks.remove(cc);
                return s;
            }, f -> this._callbacks.remove(cc));
        }
        return promise;
    }

    public String toString() {
        return this._bundle.toString();
    }

    private void collectExtensionRequirements(BundleWiring bundleWiring, Set<String> extensionRequirements) {
        for (BundleWire wire : bundleWiring.getRequiredWires("osgi.cdi.extension")) {
            String filter = (String)wire.getRequirement().getDirectives().get("filter");
            Bundle extensionProvider = wire.getProvider().getBundle();
            StringBuilder sb = new StringBuilder();
            sb.append("(&");
            sb.append(filter);
            sb.append("(");
            sb.append("service.bundleid");
            sb.append("=");
            sb.append(extensionProvider.getBundleId());
            sb.append("))");
            if (!extensionRequirements.add(sb.toString())) continue;
            this.collectExtensionRequirements((BundleWiring)extensionProvider.adapt(BundleWiring.class), extensionRequirements);
        }
    }
}

