/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.container;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.container.internal.container.Op;
import org.apache.aries.cdi.container.internal.container.Phase;
import org.apache.aries.cdi.container.internal.model.Component;
import org.apache.aries.cdi.container.internal.model.ExtendedComponentInstanceDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedConfigurationDTO;
import org.apache.aries.cdi.container.internal.util.Maps;
import org.apache.aries.cdi.container.internal.util.Predicates;
import org.apache.aries.cdi.container.internal.util.Syncro;
import org.apache.aries.cdi.container.internal.util.Throw;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cdi.ConfigurationPolicy;
import org.osgi.service.cdi.MaximumCardinality;
import org.osgi.service.cdi.runtime.dto.template.ConfigurationTemplateDTO;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.log.Logger;
import org.osgi.util.promise.Promise;

public class ConfigurationListener
extends Phase
implements org.osgi.service.cm.ConfigurationListener {
    private volatile ServiceRegistration<org.osgi.service.cm.ConfigurationListener> _listenerService;
    private final Component _component;
    private final Logger _log;

    protected ConfigurationListener(ContainerState containerState, Component component) {
        super(containerState, component);
        this._component = component;
        this._log = containerState.containerLogs().getLogger(this.getClass());
    }

    @Override
    public boolean close() {
        try (Syncro open = this.syncro.open();){
            if (this._listenerService == null) {
                boolean bl = true;
                return bl;
            }
            this._listenerService.unregister();
            this._listenerService = null;
            boolean bl = this.next.map(next -> {
                this.submit(next.closeOp(), next::close).onFailure(f -> {
                    this._log.error(l -> l.error("CCR Failure in configuration listener close on {}", next, f));
                    this.error((Throwable)f);
                });
                return true;
            }).orElse(true);
            return bl;
        }
    }

    @Override
    public Op closeOp() {
        return Op.of(Op.Mode.CLOSE, Op.Type.CONFIGURATION_LISTENER, this._component.template().name);
    }

    public void configurationEvent(ConfigurationEvent event) {
        this.next.map(next -> (Component)next).ifPresent(next -> next.configurationTemplates().stream().filter(t -> Predicates.isMatchingConfiguration(event).test((ConfigurationTemplateDTO)t)).findFirst().ifPresent(t -> {
            String eventString = Arrays.asList(event.getPid(), event.getFactoryPid(), this.type(event)).toString();
            Promise<Boolean> result = this.containerState.submit(Op.of(Op.Mode.OPEN, Op.Type.CONFIGURATION_EVENT, eventString), () -> {
                this._log.debug(l -> l.debug("CCR Event {} matched {} because of {}", new Object[]{eventString, this._component.template().name, this._component.template().configurations}));
                this.processEvent((Component)next, (ConfigurationTemplateDTO)t, event);
                return true;
            });
            try {
                result.getValue();
            }
            catch (Exception e) {
                Throw.exception(e);
            }
        }));
    }

    @Override
    public boolean open() {
        try (Syncro open = this.syncro.open();){
            if (this._listenerService != null) {
                boolean bl = true;
                return bl;
            }
            if (this.containerState.bundleContext() == null) {
                boolean bl = false;
                return bl;
            }
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("name", this.toString());
            ((Dictionary)properties).put("service.description", "Aries CDI - Configuration Listener for " + this.containerState.bundle());
            ((Dictionary)properties).put("service.vendor", "Apache Software Foundation");
            this._listenerService = this.containerState.bundleContext().registerService(org.osgi.service.cm.ConfigurationListener.class, (Object)this, properties);
            boolean bl = this.next.map(next -> (Component)next).map(component -> {
                this.submit(component.openOp(), component::open).then(s -> {
                    component.configurationTemplates().stream().filter(ct -> Objects.nonNull(ct.pid)).forEach(template -> {
                        if (template.maximumCardinality == MaximumCardinality.ONE) {
                            this.containerState.findConfig(template.pid).ifPresent(c -> this.processEvent((Component)component, (ConfigurationTemplateDTO)template, new ConfigurationEvent(this.containerState.caTracker().getServiceReference(), 1, null, c.getPid())));
                        } else {
                            this.containerState.findConfigs(template.pid, true).ifPresent(arr -> Arrays.stream(arr).forEach(c -> this.processEvent((Component)component, (ConfigurationTemplateDTO)template, new ConfigurationEvent(this.containerState.caTracker().getServiceReference(), 1, c.getFactoryPid(), c.getPid()))));
                        }
                    });
                    return s;
                }, f -> {
                    this._log.error(l -> l.error("CCR Failure during configuration start on {}", (Object)this.next, (Object)f.getFailure()));
                    this.error(f.getFailure());
                });
                return true;
            }).orElse(true);
            return bl;
        }
    }

    @Override
    public Op openOp() {
        return Op.of(Op.Mode.OPEN, Op.Type.CONFIGURATION_LISTENER, this._component.template().name);
    }

    public String toString() {
        return Arrays.asList(this.getClass().getSimpleName(), this._component).toString();
    }

    private void processEvent(Component component, ConfigurationTemplateDTO t, ConfigurationEvent event) {
        boolean required = t.policy == ConfigurationPolicy.REQUIRED;
        boolean single = t.maximumCardinality == MaximumCardinality.ONE;
        switch (event.getType()) {
            case 2: {
                component.instances().stream().map(ExtendedComponentInstanceDTO.class::cast).filter(instance -> !single && event.getPid().equals(instance.pid) || single).forEach(instance -> this.submit(instance.closeOp(), instance::close).then(s -> {
                    if (!required) {
                        instance.configurations.removeIf(c -> c.template == t);
                        this.submit(instance.openOp(), instance::open);
                    } else {
                        component.instances().remove(instance);
                    }
                    return s;
                }));
                return;
            }
            case 3: {
                break;
            }
            case 1: {
                if (!single) {
                    if (!component.instances().stream().map(ExtendedComponentInstanceDTO.class::cast).filter(instance -> event.getPid().equals(instance.pid)).findFirst().isPresent()) {
                        ExtendedComponentInstanceDTO instance2 = new ExtendedComponentInstanceDTO(this.containerState, this._component.activatorBuilder());
                        instance2.activations = new CopyOnWriteArrayList();
                        instance2.configurations = new CopyOnWriteArrayList();
                        instance2.pid = event.getPid();
                        instance2.references = new CopyOnWriteArrayList();
                        instance2.template = component.template();
                        component.instances().add(instance2);
                    }
                }
                this.containerState.findConfig(event.getPid()).ifPresent(configuration -> {
                    ExtendedConfigurationDTO configurationDTO = new ExtendedConfigurationDTO();
                    configurationDTO.configuration = configuration;
                    configurationDTO.pid = configuration.getPid();
                    configurationDTO.properties = Maps.of(configuration.getProcessedProperties(event.getReference()));
                    configurationDTO.template = t;
                    component.instances().stream().map(ExtendedComponentInstanceDTO.class::cast).filter(instance -> !single && event.getPid().equals(instance.pid) || single).forEach(instance -> this.submit(instance.closeOp(), instance::close).then(s -> {
                        instance.configurations.removeIf(c -> c.template == t);
                        instance.configurations.add(configurationDTO);
                        this.submit(instance.openOp(), instance::open);
                        return s;
                    }));
                });
            }
        }
    }

    private String type(ConfigurationEvent event) {
        if (event.getType() == 2) {
            return "DELETED";
        }
        if (event.getType() == 3) {
            return "LOCATION_CHANGED";
        }
        if (event.getType() == 1) {
            return "UPDATED";
        }
        throw new IllegalArgumentException("CM Event type " + event.getType());
    }

    public static class Builder {
        private Component _component;
        private final ContainerState _containerState;

        public Builder(ContainerState containerState) {
            this._containerState = containerState;
        }

        public Builder component(Component component) {
            this._component = component;
            return this;
        }

        public ConfigurationListener build() {
            Objects.requireNonNull(this._component);
            return new ConfigurationListener(this._containerState, this._component);
        }
    }
}

