/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.container;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cdi.reference.BeanServiceObjects;

public class BeanServiceObjectsImpl<T>
implements BeanServiceObjects<T> {
    private final Set<T> _objects = ConcurrentHashMap.newKeySet();
    private final ServiceObjects<T> _so;

    public BeanServiceObjectsImpl(ServiceObjects<T> so) {
        this._so = so;
    }

    public void close() {
        this._objects.removeIf(o -> {
            this._so.ungetService(o);
            return true;
        });
    }

    public T getService() {
        Object service = this._so.getService();
        this._objects.add(service);
        return (T)service;
    }

    public ServiceReference<T> getServiceReference() {
        return this._so.getServiceReference();
    }

    public void ungetService(T service) {
        this._objects.remove(service);
        this._so.ungetService(service);
    }
}

