/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.container;

import org.apache.aries.cdi.container.internal.CCR;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.container.internal.container.Op;
import org.apache.aries.cdi.container.internal.container.Phase;
import org.apache.aries.cdi.container.internal.util.Syncro;
import org.apache.felix.utils.extender.Extension;
import org.osgi.service.log.Logger;

public class CDIBundle
extends Phase
implements Extension {
    private final CCR _ccr;
    private final Logger _log;
    private volatile boolean running = false;

    public CDIBundle(CCR ccr, ContainerState containerState, Phase next) {
        super(containerState, next);
        this._ccr = ccr;
        this._log = containerState.containerLogs().getLogger(this.getClass());
    }

    @Override
    public boolean close() {
        try (Syncro open = this.syncro.open();){
            if (!this.running) {
                boolean bl = false;
                return bl;
            }
            this.containerState.closing();
            boolean bl = this.next.map(next -> {
                this.submit(next.closeOp(), next::close).onFailure(f -> {
                    this._log.error(l -> l.error("CCR Error in cdibundle CLOSE on {}", (Object)this.bundle(), f));
                    this.error((Throwable)f);
                });
                this._ccr.remove(this.bundle());
                return true;
            }).orElse(true);
            return bl;
        }
    }

    @Override
    public Op closeOp() {
        return Op.of(Op.Mode.CLOSE, Op.Type.INIT, this.bundle().toString());
    }

    @Override
    public void destroy() throws Exception {
        this.close();
    }

    @Override
    public boolean open() {
        try (Syncro open = this.syncro.open();){
            boolean bl = this.running = this.next.map(next -> {
                this._ccr.add(this.containerState.bundle(), this.containerState);
                this.submit(next.openOp(), next::open).onFailure(f -> {
                    this._log.error(l -> l.error("CCR Error in cdibundle OPEN on {}", (Object)this.bundle(), f));
                    this.error((Throwable)f);
                });
                return true;
            }).orElse(true).booleanValue();
            return bl;
        }
    }

    @Override
    public Op openOp() {
        return Op.of(Op.Mode.OPEN, Op.Type.INIT, this.bundle().toString());
    }

    @Override
    public void start() throws Exception {
        this.open();
    }
}

