/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.annotated;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.Annotated;
import org.apache.aries.cdi.container.internal.util.Reflection;

public class AnnotatedImpl<X>
implements Annotated {
    private final Type _baseType;
    private final AnnotatedElement _annotatedElement;
    private final Set<Type> _typeClosure;

    public AnnotatedImpl(Type baseType, AnnotatedElement annotatedElement) {
        this._baseType = baseType;
        this._annotatedElement = annotatedElement;
        this._typeClosure = Reflection.getTypes(this._baseType);
    }

    public Type getBaseType() {
        return this._baseType;
    }

    public Set<Type> getTypeClosure() {
        return this._typeClosure;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return this._annotatedElement.getAnnotation(annotationType);
    }

    public <T extends Annotation> Set<T> getAnnotations(Class<T> annotationType) {
        return Arrays.stream(this._annotatedElement.getAnnotationsByType(annotationType)).collect(Collectors.toSet());
    }

    public Set<Annotation> getAnnotations() {
        return Arrays.stream(this._annotatedElement.getAnnotations()).collect(Collectors.toSet());
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this._annotatedElement.isAnnotationPresent(annotationType);
    }

    public String toString() {
        return this._baseType.getTypeName();
    }
}

