/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.container.internal.util.DTOs;
import org.apache.aries.cdi.container.internal.util.Logs;
import org.apache.aries.cdi.container.internal.util.Throw;
import org.osgi.framework.Bundle;
import org.osgi.service.cdi.runtime.CDIComponentRuntime;
import org.osgi.service.cdi.runtime.dto.ContainerDTO;
import org.osgi.service.cdi.runtime.dto.template.ContainerTemplateDTO;
import org.osgi.util.promise.PromiseFactory;

public class CCR
implements CDIComponentRuntime {
    private final PromiseFactory _promiseFactory;
    private final Map<Bundle, ContainerState> _states = new ConcurrentHashMap<Bundle, ContainerState>();

    public CCR(PromiseFactory promiseFactory, Logs logs) {
        this._promiseFactory = promiseFactory;
    }

    public void add(Bundle bundle, ContainerState containerState) {
        this._states.put(bundle, containerState);
    }

    public Collection<ContainerDTO> getContainerDTOs(Bundle ... bundles) {
        if (bundles != null && bundles.length > 0) {
            return this.call(() -> Stream.of(bundles).filter(b -> Objects.nonNull(this._states.get(b))).map(b -> this._states.get(b)).map(cs -> DTOs.copy(cs.containerDTO(), true)).collect(Collectors.toList()));
        }
        return this.call(() -> this._states.values().stream().map(cs -> DTOs.copy(cs.containerDTO(), true)).collect(Collectors.toList()));
    }

    public ContainerTemplateDTO getContainerTemplateDTO(Bundle bundle) {
        return this.call(() -> Optional.ofNullable(this._states.get(bundle)).map(cs -> DTOs.copy(cs.containerDTO().template, true)).orElse(null));
    }

    public ContainerState getContainerState(Bundle bundle) {
        return this._states.get(bundle);
    }

    public void remove(Bundle bundle) {
        this._states.remove(bundle);
    }

    public <R> R call(Callable<R> callable) {
        try {
            return (R)this._promiseFactory.submit(callable).getValue();
        }
        catch (Exception e) {
            return (R)Throw.exception(e);
        }
    }
}

