/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.util;

import org.apache.aries.cdi.container.internal.util.Perms;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerConsumer;
import org.osgi.service.log.LoggerFactory;
import org.osgi.util.tracker.ServiceTracker;

public class Logs {
    private final LoggerFactory _loggerFactory;

    private Logs(BundleContext bundleContext) {
        LoggerFactory loggerFactory = null;
        if (bundleContext != null && Perms.hasLoggerFactoryServicePermission(bundleContext)) {
            ServiceTracker tracker = new ServiceTracker(bundleContext, LoggerFactory.class, null);
            tracker.open();
            loggerFactory = (LoggerFactory)tracker.getService();
        }
        this._loggerFactory = loggerFactory;
    }

    public Logger getLogger(Class<?> clazz) {
        return this.getLogger(clazz.getName());
    }

    public Logger getLogger(String name) {
        if (this._loggerFactory != null) {
            return this._loggerFactory.getLogger(name);
        }
        return new SysoutLogger(name);
    }

    public LoggerFactory getLoggerFactory() {
        return this._loggerFactory;
    }

    public static class SysoutLogger
    extends BaseLogger {
        private final String name;

        public SysoutLogger(String name) {
            this.name = name;
        }

        public void debug(String message) {
        }

        public void debug(String format, Object arg) {
        }

        public void debug(String format, Object arg1, Object arg2) {
        }

        public void debug(String format, Object ... arguments) {
        }

        public void error(String message) {
        }

        public void error(String format, Object arg) {
        }

        public void error(String format, Object arg1, Object arg2) {
        }

        public void error(String format, Object ... arguments) {
        }

        public String getName() {
            return this.name;
        }

        public void info(String message) {
        }

        public void info(String format, Object arg) {
        }

        public void info(String format, Object arg1, Object arg2) {
        }

        public void info(String format, Object ... arguments) {
        }

        public boolean isDebugEnabled() {
            return true;
        }

        public boolean isErrorEnabled() {
            return true;
        }

        public boolean isInfoEnabled() {
            return true;
        }

        public boolean isTraceEnabled() {
            return true;
        }

        public boolean isWarnEnabled() {
            return true;
        }

        public void trace(String message) {
        }

        public void trace(String format, Object arg) {
        }

        public void trace(String format, Object arg1, Object arg2) {
        }

        public void trace(String format, Object ... arguments) {
        }

        public void warn(String message) {
        }

        public void warn(String format, Object arg) {
        }

        public void warn(String format, Object arg1, Object arg2) {
        }

        public void warn(String format, Object ... arguments) {
        }
    }

    private static abstract class BaseLogger
    implements Logger {
        private BaseLogger() {
        }

        public <E extends Exception> void debug(LoggerConsumer<E> consumer) throws E {
            if (this.isDebugEnabled()) {
                consumer.accept((Logger)this);
            }
        }

        public <E extends Exception> void error(LoggerConsumer<E> consumer) throws E {
            if (this.isErrorEnabled()) {
                consumer.accept((Logger)this);
            }
        }

        public <E extends Exception> void info(LoggerConsumer<E> consumer) throws E {
            if (this.isInfoEnabled()) {
                consumer.accept((Logger)this);
            }
        }

        public <E extends Exception> void trace(LoggerConsumer<E> consumer) throws E {
            if (this.isTraceEnabled()) {
                consumer.accept((Logger)this);
            }
        }

        public <E extends Exception> void warn(LoggerConsumer<E> consumer) throws E {
            if (this.isWarnEnabled()) {
                consumer.accept((Logger)this);
            }
        }

        public void audit(String message) {
        }

        public void audit(String format, Object arg) {
        }

        public void audit(String format, Object arg1, Object arg2) {
        }

        public void audit(String format, Object ... arguments) {
        }
    }

    public static class Builder {
        private final BundleContext _bundleContext;

        public Builder(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        public Logs build() {
            return new Logs(this._bundleContext);
        }
    }
}

