/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.provider;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.util.TypeLiteral;
import org.apache.aries.cdi.container.internal.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

public class CDIProvider
implements javax.enterprise.inject.spi.CDIProvider {
    private static final CDI<Object> _cdi = new CdiExtenderCDI();

    public CDI<Object> getCDI() {
        return _cdi;
    }

    private static class CdiExtenderCDI
    extends CDI<Object> {
        private CdiExtenderCDI() {
        }

        public void destroy(Object instance) {
        }

        public Object get() {
            return this;
        }

        public BeanManager getBeanManager() {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader instanceof BundleReference) {
                BundleReference br = (BundleReference)contextClassLoader;
                Bundle bundle = br.getBundle();
                return Optional.ofNullable(Activator.ccr.getContainerState(bundle)).map(cs -> cs.beanManager()).orElse(null);
            }
            throw new IllegalStateException("This method can only be used when the Thread context class loader has been set to a Bundle's classloader.");
        }

        public boolean isAmbiguous() {
            return false;
        }

        public boolean isUnsatisfied() {
            return false;
        }

        public Iterator<Object> iterator() {
            return Collections.singleton(this).iterator();
        }

        public Instance<Object> select(Annotation ... qualifiers) {
            return this.getBeanManager().createInstance().select(qualifiers);
        }

        public <U> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
            return this.getBeanManager().createInstance().select(subtype, qualifiers);
        }

        public <U> Instance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
            return this.getBeanManager().createInstance().select(subtype, qualifiers);
        }
    }
}

