/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.container;

import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.enterprise.inject.spi.Extension;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.container.internal.container.Op;
import org.apache.aries.cdi.container.internal.container.Phase;
import org.apache.aries.cdi.container.internal.model.ExtendedExtensionDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedExtensionTemplateDTO;
import org.apache.aries.cdi.container.internal.util.Conversions;
import org.apache.aries.cdi.container.internal.util.Filters;
import org.apache.aries.cdi.container.internal.util.SRs;
import org.apache.aries.cdi.container.internal.util.Syncro;
import org.apache.aries.cdi.container.internal.util.Throw;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cdi.runtime.dto.ExtensionDTO;
import org.osgi.service.cdi.runtime.dto.template.ExtensionTemplateDTO;
import org.osgi.service.log.Logger;
import org.osgi.util.promise.Promise;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ExtensionPhase
extends Phase {
    private ServiceTracker<Extension, ExtendedExtensionDTO> _extensionTracker;
    private final Logger _log;
    private final SortedSet<ExtendedExtensionDTO> _references = new ConcurrentSkipListSet<ExtendedExtensionDTO>((e1, e2) -> e1.serviceReference.compareTo(e2.serviceReference));

    public ExtensionPhase(ContainerState containerState, Phase next) {
        super(containerState, next);
        this._log = containerState.containerLogs().getLogger(this.getClass());
    }

    @Override
    public boolean close() {
        try (Syncro open = this.syncro.open();){
            if (!this.extensionTemplates().isEmpty()) {
                if (this._extensionTracker != null) {
                    this._extensionTracker.close();
                    this._extensionTracker = null;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = this.next.map(next -> {
                this.submit(next.closeOp(), next::close).onFailure(f -> {
                    this._log.error(l -> l.error("CCR Error in extension CLOSE on {}", (Object)this.bundle(), f));
                    this.error((Throwable)f);
                });
                return true;
            }).orElse(true);
            return bl;
        }
    }

    @Override
    public Op closeOp() {
        return Op.of(Op.Mode.CLOSE, Op.Type.EXTENSION, this.containerState.id());
    }

    @Override
    public boolean open() {
        try (Syncro open = this.syncro.open();){
            if (this.containerState.bundleContext() == null) {
                boolean bl = false;
                return bl;
            }
            if (!this.extensionTemplates().isEmpty()) {
                this._extensionTracker = new ServiceTracker(this.containerState.bundleContext(), this.createExtensionFilter(), (ServiceTrackerCustomizer)new ExtensionPhaseCustomizer());
                this._extensionTracker.open();
                boolean bl = true;
                return bl;
            }
            boolean bl = this.next.map(next -> {
                this.submit(next.openOp(), next::open).onFailure(f -> {
                    this._log.error(l -> l.error("CCR Error in extension OPEN on {}", (Object)this.bundle(), f));
                    this.error((Throwable)f);
                });
                return true;
            }).orElse(true);
            return bl;
        }
    }

    @Override
    public Op openOp() {
        return Op.of(Op.Mode.OPEN, Op.Type.EXTENSION, this.containerState.id());
    }

    Filter createExtensionFilter() {
        List<ExtensionTemplateDTO> templates = this.extensionTemplates();
        StringBuilder sb = new StringBuilder("(&(objectClass=" + Extension.class.getName() + ")");
        if (templates.size() > 1) {
            sb.append("(|");
        }
        for (ExtensionTemplateDTO tmpl : templates) {
            sb.append(tmpl.serviceFilter);
        }
        if (templates.size() > 1) {
            sb.append(")");
        }
        sb.append(")");
        return Filters.asFilter(sb.toString(), new Object[0]);
    }

    List<ExtensionTemplateDTO> extensionTemplates() {
        return this.containerState.containerDTO().template.extensions;
    }

    List<ExtensionDTO> snapshots() {
        return this.containerState.containerDTO().extensions;
    }

    private class ExtensionPhaseCustomizer
    implements ServiceTrackerCustomizer<Extension, ExtendedExtensionDTO> {
        private ExtensionPhaseCustomizer() {
        }

        public ExtendedExtensionDTO addingService(ServiceReference<Extension> reference) {
            ExtendedExtensionTemplateDTO template = ExtensionPhase.this.extensionTemplates().stream().map(t -> (ExtendedExtensionTemplateDTO)((Object)t)).filter(t -> t.filter.match(reference)).findFirst().get();
            ExtendedExtensionDTO snapshot = ExtensionPhase.this.snapshots().stream().map(s -> (ExtendedExtensionDTO)((Object)s)).filter(s -> s.template == template).findFirst().orElse(null);
            if (snapshot != null) {
                if (reference.compareTo(snapshot.serviceReference) <= 0) {
                    return null;
                }
                if (ExtensionPhase.this.snapshots().remove((Object)snapshot)) {
                    ExtensionPhase.this._references.add(snapshot);
                    snapshot.extension = null;
                    ExtensionPhase.this.containerState.bundleContext().ungetService(snapshot.serviceReference);
                }
            }
            ExtendedExtensionDTO extensionDTO = new ExtendedExtensionDTO();
            BundleContext bc = ExtensionPhase.this.containerState.bundleContext();
            extensionDTO.extension = bc.getServiceObjects(reference);
            extensionDTO.service = SRs.from(reference);
            extensionDTO.serviceReference = reference;
            extensionDTO.template = template;
            ExtensionPhase.this.snapshots().add(extensionDTO);
            ExtensionPhase.this.containerState.incrementChangeCount();
            ExtensionPhase.this.next.ifPresent(next -> ExtensionPhase.this.submit(next.closeOp(), next::close).then(s -> {
                if (ExtensionPhase.this.snapshots().size() == ExtensionPhase.this.extensionTemplates().size()) {
                    return ExtensionPhase.this.submit(next.openOp(), next::open).onFailure(f -> {
                        ExtensionPhase.this._log.error(l -> l.error("CCR Error in extension open TRACKING {} on {}", new Object[]{reference, ExtensionPhase.this.bundle(), f}));
                        ExtensionPhase.this.error((Throwable)f);
                    });
                }
                return s;
            }, f -> {
                ExtensionPhase.this._log.error(l -> l.error("CCR Error extension close TRACKING {} on {}", new Object[]{reference, ExtensionPhase.this.bundle(), f.getFailure()}));
                ExtensionPhase.this.error(f.getFailure());
            }));
            return extensionDTO;
        }

        public void modifiedService(ServiceReference<Extension> reference, ExtendedExtensionDTO extentionDTO) {
            this.removedService(reference, extentionDTO);
            this.addingService(reference);
        }

        public void removedService(ServiceReference<Extension> reference, ExtendedExtensionDTO extensionDTO) {
            ExtensionPhase.this._log.debug(l -> l.debug("CCR Departing extension {} on {}", (Object)Conversions.convert((Object)extensionDTO).to(ExtensionDTO.class), (Object)ExtensionPhase.this.bundle()));
            ExtensionPhase.this.containerState.bundleContext().ungetService(reference);
            if (!ExtensionPhase.this.snapshots().removeIf(snap -> ((ExtendedExtensionDTO)snap).serviceReference.equals((Object)reference))) {
                return;
            }
            Iterator itr = ExtensionPhase.this._references.iterator();
            while (itr.hasNext()) {
                ExtendedExtensionDTO entry = (ExtendedExtensionDTO)((Object)itr.next());
                if (!((ExtendedExtensionTemplateDTO)extensionDTO.template).filter.match(entry.serviceReference)) continue;
                entry.extension = ExtensionPhase.this.containerState.bundleContext().getServiceObjects(entry.serviceReference);
                itr.remove();
                ExtensionPhase.this.snapshots().add(entry);
                break;
            }
            ExtensionPhase.this.containerState.incrementChangeCount();
            ExtensionPhase.this.next.ifPresent(next -> {
                Promise result = ExtensionPhase.this.submit(next.closeOp(), next::close).then(s -> {
                    if (ExtensionPhase.this.snapshots().size() == ExtensionPhase.this.extensionTemplates().size()) {
                        return ExtensionPhase.this.submit(next.openOp(), next::open).onFailure(f -> {
                            ExtensionPhase.this._log.error(l -> l.error("CCR Error in extension open {} on {}", new Object[]{reference, ExtensionPhase.this.bundle(), f}));
                            ExtensionPhase.this.error((Throwable)f);
                        });
                    }
                    return s;
                }, f -> {
                    ExtensionPhase.this._log.error(l -> l.error("CCR Error in extension close {} on {}", new Object[]{reference, ExtensionPhase.this.bundle(), f.getFailure()}));
                    ExtensionPhase.this.error(f.getFailure());
                });
                try {
                    result.getValue();
                }
                catch (Exception e) {
                    Throw.exception(e);
                }
            });
        }
    }
}

