/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rest.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.archiva.redback.common.ldap.MappingException;
import org.apache.archiva.redback.common.ldap.connection.LdapConnection;
import org.apache.archiva.redback.common.ldap.connection.LdapConnectionFactory;
import org.apache.archiva.redback.common.ldap.connection.LdapException;
import org.apache.archiva.redback.common.ldap.role.LdapRoleMapper;
import org.apache.archiva.redback.common.ldap.role.LdapRoleMapperConfiguration;
import org.apache.archiva.redback.rest.api.model.LdapGroupMapping;
import org.apache.archiva.redback.rest.api.model.LdapGroupMappingUpdateRequest;
import org.apache.archiva.redback.rest.api.model.StringList;
import org.apache.archiva.redback.rest.api.services.LdapGroupMappingService;
import org.apache.archiva.redback.rest.api.services.RedbackServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ldapGroupMappingService#rest")
public class DefaultLdapGroupMappingService
implements LdapGroupMappingService {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    @Named(value="ldapRoleMapper#default")
    private LdapRoleMapper ldapRoleMapper;
    @Inject
    @Named(value="ldapRoleMapperConfiguration#default")
    private LdapRoleMapperConfiguration ldapRoleMapperConfiguration;
    @Inject
    @Named(value="ldapConnectionFactory#configurable")
    private LdapConnectionFactory ldapConnectionFactory;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StringList getLdapGroups() throws RedbackServiceException {
        LdapConnection ldapConnection = null;
        DirContext context = null;
        try {
            ldapConnection = this.ldapConnectionFactory.getConnection();
            context = ldapConnection.getDirContext();
            StringList stringList = new StringList(this.ldapRoleMapper.getAllGroups(context));
            this.closeContext(context);
            this.closeLdapConnection(ldapConnection);
            return stringList;
        }
        catch (LdapException e) {
            try {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new RedbackServiceException(e.getMessage());
                catch (MappingException e2) {
                    this.log.error(e2.getMessage(), (Throwable)e2);
                    throw new RedbackServiceException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeContext(context);
                this.closeLdapConnection(ldapConnection);
                throw throwable;
            }
        }
    }

    public List<LdapGroupMapping> getLdapGroupMappings() throws RedbackServiceException {
        try {
            Map map = this.ldapRoleMapperConfiguration.getLdapGroupMappings();
            ArrayList<LdapGroupMapping> ldapGroupMappings = new ArrayList<LdapGroupMapping>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                LdapGroupMapping ldapGroupMapping = new LdapGroupMapping((String)entry.getKey(), (Collection)entry.getValue());
                ldapGroupMappings.add(ldapGroupMapping);
            }
            return ldapGroupMappings;
        }
        catch (MappingException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RedbackServiceException(e.getMessage());
        }
    }

    public Boolean addLdapGroupMapping(LdapGroupMapping ldapGroupMapping) throws RedbackServiceException {
        try {
            this.ldapRoleMapperConfiguration.addLdapMapping(ldapGroupMapping.getGroup(), new ArrayList(ldapGroupMapping.getRoleNames()));
        }
        catch (MappingException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RedbackServiceException(e.getMessage());
        }
        return Boolean.TRUE;
    }

    public Boolean removeLdapGroupMapping(String group) throws RedbackServiceException {
        try {
            this.ldapRoleMapperConfiguration.removeLdapMapping(group);
        }
        catch (MappingException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RedbackServiceException(e.getMessage());
        }
        return Boolean.TRUE;
    }

    public Boolean updateLdapGroupMapping(LdapGroupMappingUpdateRequest ldapGroupMappingUpdateRequest) throws RedbackServiceException {
        try {
            for (LdapGroupMapping ldapGroupMapping : ldapGroupMappingUpdateRequest.getLdapGroupMapping()) {
                this.ldapRoleMapperConfiguration.updateLdapMapping(ldapGroupMapping.getGroup(), new ArrayList(ldapGroupMapping.getRoleNames()));
            }
        }
        catch (MappingException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RedbackServiceException(e.getMessage());
        }
        return Boolean.TRUE;
    }

    protected void closeLdapConnection(LdapConnection ldapConnection) {
        if (ldapConnection != null) {
            ldapConnection.close();
        }
    }

    protected void closeContext(DirContext context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (NamingException e) {
                this.log.warn("skip issue closing context: {}", (Object)e.getMessage());
            }
        }
    }
}

