/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rest.services.interceptors;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.archiva.redback.authentication.AuthenticationException;
import org.apache.archiva.redback.authentication.AuthenticationResult;
import org.apache.archiva.redback.authentication.InvalidTokenException;
import org.apache.archiva.redback.authentication.TokenData;
import org.apache.archiva.redback.authentication.TokenManager;
import org.apache.archiva.redback.authorization.RedbackAuthorization;
import org.apache.archiva.redback.configuration.UserConfiguration;
import org.apache.archiva.redback.integration.filter.authentication.basic.HttpBasicAuthentication;
import org.apache.archiva.redback.policy.AccountLockedException;
import org.apache.archiva.redback.policy.MustChangePasswordException;
import org.apache.archiva.redback.rest.services.interceptors.AbstractInterceptor;
import org.apache.archiva.redback.users.User;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Provider
@Service(value="requestValidationInterceptor#rest")
public class RequestValidationInterceptor
extends AbstractInterceptor
implements ContainerRequestFilter {
    private static final String X_FORWARDED_PROTO = "X-Forwarded-Proto";
    private static final String X_FORWARDED_HOST = "X-Forwarded-Host";
    private static final String X_XSRF_TOKEN = "X-XSRF-TOKEN";
    private static final String ORIGIN = "Origin";
    private static final String REFERER = "Referer";
    private static final int DEFAULT_HTTP = 80;
    private static final int DEFAULT_HTTPS = 443;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean enabled = true;
    private boolean checkToken = true;
    private boolean useStaticUrl = false;
    private boolean denyAbsentHeaders = true;
    private List<URL> baseUrl = new ArrayList<URL>();
    private HttpServletRequest httpRequest = null;
    @Inject
    @Named(value="httpAuthenticator#basic")
    private HttpBasicAuthentication httpAuthenticator;
    @Inject
    @Named(value="tokenManager#default")
    TokenManager tokenManager;
    private UserConfiguration config;

    @Inject
    public RequestValidationInterceptor(@Named(value="userConfiguration#default") UserConfiguration config) {
        this.config = config;
    }

    @PostConstruct
    public void init() {
        List baseUrlList = this.config.getList("rest.baseUrl");
        if (baseUrlList != null) {
            for (String baseUrlStr : baseUrlList) {
                if ("".equals(baseUrlStr.trim())) continue;
                try {
                    this.baseUrl.add(new URL(baseUrlStr));
                    this.useStaticUrl = true;
                }
                catch (MalformedURLException ex) {
                    this.log.error("Configured baseUrl (rest.baseUrl={}) is invalid. Message: {}", (Object)baseUrlStr, (Object)ex.getMessage());
                }
            }
        }
        this.denyAbsentHeaders = this.config.getBoolean("rest.csrffilter.absentorigin.deny", true);
        this.enabled = this.config.getBoolean("rest.csrffilter.enabled", true);
        if (!this.enabled) {
            this.log.info("CSRF Filter is disabled by configuration");
        } else {
            this.log.info("CSRF Filter is enable");
        }
        boolean bl = this.checkToken = !this.config.getBoolean("rest.csrffilter.disableTokenValidation", false);
        if (!this.checkToken) {
            this.log.info("CSRF Token validation is disabled by configuration");
        } else {
            this.log.info("CSRF Token validation is enable");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        block10: {
            if (!this.enabled) break block10;
            request = this.getRequest();
            targetUrls = this.getTargetUrl(request);
            if (targetUrls == null) {
                this.log.error("Could not verify target URL.");
                containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
                return;
            }
            validationInfos = new ArrayList<HeaderValidationInfo>();
            targetMatch = false;
            noHeader = true;
            for (URL targetUrl : targetUrls) {
                this.log.trace("Checking against target URL: {}", (Object)targetUrl);
                info = this.checkSourceRequestHeader(new HeaderValidationInfo(targetUrl), request);
                if (!noHeader) ** GOTO lbl-1000
                if (info.getStatus() == -1) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                noHeader = v0;
                if (info.getStatus() == 0) {
                    targetMatch = true;
                    break;
                }
                validationInfos.add(info);
            }
            if (noHeader && this.denyAbsentHeaders) {
                this.log.warn("Request denied. No Origin or Referer header found and {}=true", (Object)"rest.csrffilter.absentorigin.deny");
                containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
                return;
            }
            if (!targetMatch) {
                this.log.warn("HTTP Header check failed. Assuming CSRF attack.");
                for (HeaderValidationInfo info : validationInfos) {
                    if (info.hasOriginError()) {
                        v1 = new Object[5];
                        v1[0] = info.originUrl;
                        v1[1] = info.targetUrl;
                        v1[2] = (info.getStatus() & 8) == 0;
                        v1[3] = (info.getStatus() & 16) == 0;
                        v1[4] = (info.getStatus() & 32) == 0;
                        this.log.warn("Origin Header does not match: originUrl={}, targetUrl={}. Matches: Host={}, Port={}, Protocol={}", v1);
                    }
                    if (!info.hasRefererError()) continue;
                    v2 = new Object[4];
                    v2[0] = info.refererUrl;
                    v2[1] = info.targetUrl;
                    v2[2] = (info.getStatus() & 1) == 0;
                    v2[3] = (info.getStatus() & 2) == 0;
                    this.log.warn("Referer Header does not match: refererUrl={}, targetUrl={}. Matches: Host={}, Port={}", v2);
                }
                containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
                return;
            }
            if (this.checkToken) {
                this.checkValidationToken(containerRequestContext, request);
            }
        }
    }

    private void checkValidationToken(ContainerRequestContext containerRequestContext, HttpServletRequest request) {
        Message message = JAXRSUtils.getCurrentMessage();
        RedbackAuthorization redbackAuthorization = this.getRedbackAuthorization(message);
        if (!redbackAuthorization.noRestriction()) {
            String tokenString = request.getHeader(X_XSRF_TOKEN);
            if (tokenString == null || tokenString.length() == 0) {
                this.log.warn("No validation token header found: {}", (Object)X_XSRF_TOKEN);
                containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
                return;
            }
            try {
                TokenData td = this.tokenManager.decryptToken(tokenString);
                AuthenticationResult auth = this.getAuthenticationResult(message, request);
                if (auth == null) {
                    this.log.error("Not authentication data found");
                    containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
                    return;
                }
                User loggedIn = auth.getUser();
                if (loggedIn == null) {
                    this.log.error("User not logged in");
                    containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
                    return;
                }
                String username = loggedIn.getUsername();
                if (!td.isValid() || !td.getUser().equals(username)) {
                    this.log.error("Invalid data in validation token header {} for user {}: isValid={}, username={}", new Object[]{X_XSRF_TOKEN, username, td.isValid(), td.getUser()});
                    containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
                }
            }
            catch (InvalidTokenException e) {
                this.log.error("Token validation failed {}", (Object)e.getMessage());
                containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
            }
        }
        this.log.debug("Token validated");
    }

    private HttpServletRequest getRequest() {
        if (this.httpRequest != null) {
            return this.httpRequest;
        }
        Message message = JAXRSUtils.getCurrentMessage();
        return this.getHttpServletRequest(message);
    }

    private List<URL> getTargetUrl(HttpServletRequest request) {
        URL requestUrl;
        if (this.useStaticUrl) {
            return this.baseUrl;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            requestUrl = new URL(request.getRequestURL().toString());
            urls.add(requestUrl);
        }
        catch (MalformedURLException ex) {
            this.log.error("Bad Request URL {}, Message: {}", (Object)request.getRequestURL(), (Object)ex.getMessage());
            return null;
        }
        String xforwarded = request.getHeader(X_FORWARDED_HOST);
        String xforwardedProto = request.getHeader(X_FORWARDED_PROTO);
        if (xforwardedProto == null) {
            xforwardedProto = requestUrl.getProtocol();
        }
        if (xforwarded != null && !StringUtils.isEmpty((String)xforwarded)) {
            String[] forwardedList;
            for (String hostname : forwardedList = xforwarded.split("\\s*,\\s*")) {
                try {
                    urls.add(new URL(xforwardedProto + "://" + hostname));
                }
                catch (MalformedURLException ex) {
                    this.log.warn("X-Forwarded-Host Header is malformed: {}", (Object)ex.getMessage());
                }
            }
        }
        return urls;
    }

    private int getPort(URL url) {
        return url.getPort() > 0 ? url.getPort() : ("https".equals(url.getProtocol()) ? 443 : 80);
    }

    private String getHost(URL url) {
        return url.getHost().trim().toLowerCase();
    }

    private HeaderValidationInfo checkSourceRequestHeader(HeaderValidationInfo info, HttpServletRequest request) {
        String referer;
        String origin = request.getHeader(ORIGIN);
        if (origin != null) {
            try {
                info.setOriginUrl(new URL(origin));
            }
            catch (MalformedURLException e) {
                this.log.warn("Bad origin header found: {}", (Object)origin);
            }
        }
        if (info.getStatus() != 0 && (referer = request.getHeader(REFERER)) != null) {
            try {
                info.setRefererUrl(new URL(referer));
            }
            catch (MalformedURLException ex) {
                this.log.warn("Bad URL in Referer HTTP-Header: {}, Message: {}", (Object)referer, (Object)ex.getMessage());
            }
        }
        return info;
    }

    public void setHttpRequest(HttpServletRequest request) {
        this.httpRequest = request;
    }

    private AuthenticationResult getAuthenticationResult(Message message, HttpServletRequest request) {
        AuthenticationResult authenticationResult = (AuthenticationResult)message.get(AuthenticationResult.class);
        this.log.debug("authenticationResult from message: {}", (Object)authenticationResult);
        if (authenticationResult == null) {
            try {
                authenticationResult = this.httpAuthenticator.getAuthenticationResult(request, this.getHttpServletResponse(message));
                this.log.debug("authenticationResult from request: {}", (Object)authenticationResult);
            }
            catch (AuthenticationException e) {
                this.log.debug("failed to authenticate for path {}", message.get((Object)"org.apache.cxf.request.uri"));
            }
            catch (AccountLockedException e) {
                this.log.debug("account locked for path {}", message.get((Object)"org.apache.cxf.request.uri"));
            }
            catch (MustChangePasswordException e) {
                this.log.debug("must change password for path {}", message.get((Object)"org.apache.cxf.request.uri"));
            }
        }
        return authenticationResult;
    }

    private class HeaderValidationInfo {
        static final int UNKNOWN = -1;
        static final int OK = 0;
        static final int F_REFERER_HOST = 1;
        static final int F_REFERER_PORT = 2;
        static final int F_ORIGIN_HOST = 8;
        static final int F_ORIGIN_PORT = 16;
        static final int F_ORIGIN_PROTOCOL = 32;
        boolean headerFound = false;
        URL targetUrl;
        URL originUrl;
        URL refererUrl;
        String targetHost;
        String originHost;
        String refererHost;
        int targetPort;
        int originPort;
        int refererPort;
        int status = -1;

        public HeaderValidationInfo(URL targetUrl) {
            this.setTargetUrl(targetUrl);
        }

        public URL getTargetUrl() {
            return this.targetUrl;
        }

        public void setTargetUrl(URL targetUrl) {
            this.targetUrl = targetUrl;
            this.targetHost = RequestValidationInterceptor.this.getHost(targetUrl);
            this.targetPort = RequestValidationInterceptor.this.getPort(targetUrl);
        }

        public URL getOriginUrl() {
            return this.originUrl;
        }

        public void setOriginUrl(URL originUrl) {
            this.originUrl = originUrl;
            this.originHost = RequestValidationInterceptor.this.getHost(originUrl);
            this.originPort = RequestValidationInterceptor.this.getPort(originUrl);
            this.checkOrigin();
            this.headerFound = true;
        }

        public URL getRefererUrl() {
            return this.refererUrl;
        }

        public void setRefererUrl(URL refererUrl) {
            this.refererUrl = refererUrl;
            this.refererHost = RequestValidationInterceptor.this.getHost(refererUrl);
            this.refererPort = RequestValidationInterceptor.this.getPort(refererUrl);
            this.checkReferer();
            this.headerFound = true;
        }

        public String getTargetHost() {
            return this.targetHost;
        }

        public void setTargetHost(String targetHost) {
            this.targetHost = targetHost;
        }

        public String getOriginHost() {
            return this.originHost;
        }

        public void setOriginHost(String originHost) {
            this.originHost = originHost;
        }

        public String getRefererHost() {
            return this.refererHost;
        }

        public void setRefererHost(String refererHost) {
            this.refererHost = refererHost;
        }

        public int getTargetPort() {
            return this.targetPort;
        }

        public void setTargetPort(int targetPort) {
            this.targetPort = targetPort;
        }

        public int getOriginPort() {
            return this.originPort;
        }

        public void setOriginPort(int originPort) {
            this.originPort = originPort;
        }

        public int getRefererPort() {
            return this.refererPort;
        }

        public void setRefererPort(int refererPort) {
            this.refererPort = refererPort;
        }

        public void setStatus(int status) {
            this.status |= status;
        }

        public int getStatus() {
            return this.status;
        }

        public void checkOrigin() {
            if (this.getStatus() == -1) {
                this.status = 0;
            }
            if (!this.targetUrl.getProtocol().equals(this.originUrl.getProtocol())) {
                this.setStatus(32);
            }
            if (!this.targetHost.equals(this.originHost)) {
                this.setStatus(8);
            }
            if (this.targetPort != this.originPort) {
                this.setStatus(16);
            }
        }

        public void checkReferer() {
            if (this.getStatus() == -1) {
                this.status = 0;
            }
            if (!this.targetHost.equals(this.refererHost)) {
                this.setStatus(1);
            }
            if (this.targetPort != this.refererPort) {
                this.setStatus(2);
            }
        }

        public boolean hasOriginError() {
            return (this.status & 0x38) > 0;
        }

        public boolean hasRefererError() {
            return (this.status & 3) > 0;
        }

        public String toString() {
            return "Stat=" + this.status + ", target=" + this.targetUrl + ", origin=" + this.originUrl + ", referer=" + this.refererUrl;
        }
    }
}

