/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rest.services.interceptors;

import java.util.ArrayList;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.archiva.redback.policy.PasswordRuleViolationException;
import org.apache.archiva.redback.policy.PasswordRuleViolations;
import org.apache.archiva.redback.rest.api.model.ErrorMessage;
import org.apache.archiva.redback.rest.api.model.RedbackRestError;
import org.springframework.stereotype.Service;

@Provider
@Service(value="passwordRuleViolationExceptionMapper")
public class PasswordRuleViolationExceptionMapper
implements ExceptionMapper<PasswordRuleViolationException> {
    public Response toResponse(PasswordRuleViolationException e) {
        RedbackRestError restError = new RedbackRestError();
        ArrayList<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>(e.getViolations().getViolations().size());
        for (PasswordRuleViolations.MessageReference messageReference : e.getViolations().getViolations()) {
            errorMessages.add(new ErrorMessage(messageReference.getKey(), messageReference.getArgs()));
        }
        restError.setErrorMessages(errorMessages);
        Response.ResponseBuilder responseBuilder = Response.status((int)500).entity((Object)restError);
        return responseBuilder.build();
    }
}

