/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.apache.archiva.metadata.model.facets.RepositoryProblemFacet;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataRepositoryException;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.metadata.repository.stats.RepositoryStatistics;
import org.apache.archiva.metadata.repository.stats.RepositoryStatisticsManager;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.ReportRepositoriesService;
import org.apache.archiva.rest.services.AbstractRestService;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="reportRepositoriesService#rest")
public class DefaultReportRepositoriesService
extends AbstractRestService
implements ReportRepositoriesService {
    private static final String ALL_REPOSITORIES = "all";
    @Inject
    private RepositoryStatisticsManager repositoryStatisticsManager;

    public List<RepositoryStatistics> getStatisticsReport(List<String> repositoriesId, int rowCount, Date startDate, Date endDate) throws ArchivaRestServiceException {
        switch (repositoriesId.size()) {
            case 0: {
                throw new ArchivaRestServiceException("report.statistics.report.missing-repositories", null);
            }
            case 1: {
                return this.getUniqueRepositoryReport(repositoriesId.get(0), rowCount, startDate, endDate);
            }
        }
        return this.getMultipleRepositoriesReport(repositoriesId, rowCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RepositoryStatistics> getMultipleRepositoriesReport(List<String> repositoriesId, int rowCount) {
        try (RepositorySession repositorySession = this.repositorySessionFactory.createSession();){
            MetadataRepository metadataRepository = repositorySession.getRepository();
            ArrayList<RepositoryStatistics> stats = new ArrayList<RepositoryStatistics>();
            for (String repo : repositoriesId) {
                try {
                    stats.add(this.repositoryStatisticsManager.getLastStatistics(metadataRepository, repo));
                }
                catch (MetadataRepositoryException e) {
                    this.log.warn("Unable to retrieve stats, assuming is empty: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            List list = stats.subList(0, stats.size() > rowCount ? rowCount : stats.size());
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RepositoryStatistics> getUniqueRepositoryReport(String repositoryId, int rowCount, Date startDate, Date endDate) {
        try (RepositorySession repositorySession = this.repositorySessionFactory.createSession();){
            MetadataRepository metadataRepository = repositorySession.getRepository();
            List stats = null;
            try {
                stats = this.repositoryStatisticsManager.getStatisticsInRange(metadataRepository, repositoryId, startDate, endDate);
            }
            catch (MetadataRepositoryException e) {
                this.log.warn("Unable to retrieve stats, assuming is empty: {}", (Object)e.getMessage(), (Object)e);
            }
            if (stats == null || stats.isEmpty()) {
                List<RepositoryStatistics> list = Collections.emptyList();
                return list;
            }
            List<RepositoryStatistics> list = stats.subList(0, stats.size() > rowCount ? rowCount : stats.size());
            return list;
        }
    }

    public List<RepositoryProblemFacet> getHealthReport(String repository, String groupId, int rowCount) throws ArchivaRestServiceException {
        try (RepositorySession repositorySession = this.repositorySessionFactory.createSession();){
            List<String> observableRepositories = this.getObservableRepos();
            if (!ALL_REPOSITORIES.equals(repository) && !observableRepositories.contains(repository)) {
                throw new ArchivaRestServiceException("${$.i18n.prop('report.repository.illegal-access', " + repository + ")}", "repositoryId", (Throwable)new IllegalAccessException());
            }
            if (!ALL_REPOSITORIES.equals(repository)) {
                observableRepositories = Collections.singletonList(repository);
            }
            ArrayList<RepositoryProblemFacet> problemArtifacts = new ArrayList<RepositoryProblemFacet>();
            MetadataRepository metadataRepository = repositorySession.getRepository();
            for (String repoId : observableRepositories) {
                for (String name : metadataRepository.getMetadataFacets(repoId, "org.apache.archiva.reports")) {
                    RepositoryProblemFacet metadataFacet = (RepositoryProblemFacet)metadataRepository.getMetadataFacet(repoId, "org.apache.archiva.reports", name);
                    if (!StringUtils.isEmpty((String)groupId) && !groupId.equals(metadataFacet.getNamespace())) continue;
                    problemArtifacts.add(metadataFacet);
                }
            }
            ArrayList<RepositoryProblemFacet> arrayList = problemArtifacts;
            return arrayList;
        }
    }
}

