/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.repository;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.admin.model.beans.RemoteRepository;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.admin.model.remote.RemoteRepositoryAdmin;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.ConfigurationNames;
import org.apache.archiva.redback.components.registry.Registry;
import org.apache.archiva.redback.components.registry.RegistryListener;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.archiva.repository.RemoteRepositoryContent;
import org.apache.archiva.repository.RepositoryException;
import org.apache.archiva.repository.RepositoryNotFoundException;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="repositoryContentFactory#default")
public class RepositoryContentFactory
implements RegistryListener {
    @Inject
    private ArchivaConfiguration archivaConfiguration;
    @Inject
    private ManagedRepositoryAdmin managedRepositoryAdmin;
    @Inject
    private RemoteRepositoryAdmin remoteRepositoryAdmin;
    @Inject
    private ApplicationContext applicationContext;
    private final Map<String, ManagedRepositoryContent> managedContentMap = new ConcurrentHashMap<String, ManagedRepositoryContent>();
    private final Map<String, RemoteRepositoryContent> remoteContentMap = new ConcurrentHashMap<String, RemoteRepositoryContent>();

    public ManagedRepositoryContent getManagedRepositoryContent(String repoId) throws RepositoryNotFoundException, RepositoryException {
        try {
            ManagedRepositoryContent repo = this.managedContentMap.get(repoId);
            if (repo != null) {
                return repo;
            }
            ManagedRepository repoConfig = this.managedRepositoryAdmin.getManagedRepository(repoId);
            if (repoConfig == null) {
                throw new RepositoryNotFoundException("Unable to find managed repository configuration for id:" + repoId);
            }
            repo = (ManagedRepositoryContent)this.applicationContext.getBean("managedRepositoryContent#" + repoConfig.getLayout(), ManagedRepositoryContent.class);
            repo.setRepository(repoConfig);
            this.managedContentMap.put(repoId, repo);
            return repo;
        }
        catch (RepositoryAdminException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
    }

    public RemoteRepositoryContent getRemoteRepositoryContent(String repoId) throws RepositoryNotFoundException, RepositoryException {
        try {
            RemoteRepositoryContent repo = this.remoteContentMap.get(repoId);
            if (repo != null) {
                return repo;
            }
            RemoteRepository repoConfig = this.remoteRepositoryAdmin.getRemoteRepository(repoId);
            if (repoConfig == null) {
                throw new RepositoryNotFoundException("Unable to find remote repository configuration for id:" + repoId);
            }
            repo = (RemoteRepositoryContent)this.applicationContext.getBean("remoteRepositoryContent#" + repoConfig.getLayout(), RemoteRepositoryContent.class);
            repo.setRepository(repoConfig);
            this.remoteContentMap.put(repoId, repo);
            return repo;
        }
        catch (RepositoryAdminException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
    }

    public void afterConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
        if (ConfigurationNames.isManagedRepositories((String)propertyName) || ConfigurationNames.isRemoteRepositories((String)propertyName)) {
            this.initMaps();
        }
    }

    public void beforeConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
    }

    @PostConstruct
    public void initialize() {
        this.archivaConfiguration.addChangeListener((RegistryListener)this);
    }

    private void initMaps() {
        this.managedContentMap.clear();
        this.remoteContentMap.clear();
    }

    public ArchivaConfiguration getArchivaConfiguration() {
        return this.archivaConfiguration;
    }

    public void setArchivaConfiguration(ArchivaConfiguration archivaConfiguration) {
        this.archivaConfiguration = archivaConfiguration;
    }
}

