/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.cli;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.any23.cli.Rover;
import org.apache.any23.cli.ToolTestBase;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YAMLRoverTest
extends ToolTestBase {
    private static final String file1 = "/org/apache/any23/extractor/yaml/simple-load.yml";
    private static final String baseUri = "urn:test";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public YAMLRoverTest() {
        super(Rover.class);
    }

    @Test
    public void simpleTest() throws Exception {
        File outputFile = File.createTempFile("rover-test", ".ttl", this.tempDirectory);
        File logfile = File.createTempFile("test-log", ".txt", this.tempDirectory);
        int exitCode = this.runTool(String.format("-l %s -o %s -f turtle -e yaml,csv -d %s %s", logfile.getAbsolutePath(), outputFile.getAbsolutePath(), baseUri, this.copyResourceToTempFile(file1).getAbsolutePath()));
        Assert.assertTrue((boolean)logfile.exists());
        this.log.debug("Log file location: {}", (Object)logfile.getAbsolutePath());
        this.log.debug("Log file content: \n{}\n", (Object)FileUtils.readFileToString((File)logfile, (Charset)StandardCharsets.UTF_8));
        Assert.assertEquals((String)"Unexpected exit code.", (long)0L, (long)exitCode);
        this.assertFileContainsString(outputFile, baseUri);
    }

    public void assertFileContainsString(File f, String s) throws IOException {
        String fileContent = FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8);
        this.log.trace("File content: \n{}\n", (Object)fileContent);
        Assert.assertTrue((boolean)fileContent.contains(s));
    }
}

