/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.cli;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.any23.cli.ExtractorDocumentation;
import org.apache.any23.cli.MicrodataParser;
import org.apache.any23.cli.MimeDetector;
import org.apache.any23.cli.PluginVerifier;
import org.apache.any23.cli.Rover;
import org.apache.any23.cli.Tool;
import org.apache.any23.cli.ToolRunner;
import org.apache.any23.cli.VocabPrinter;
import org.junit.Assert;
import org.junit.Test;

public class ToolRunnerTest {
    private final Set<Class<? extends Tool>> coreTools = new HashSet<Class<? extends Tool>>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(ExtractorDocumentation.class);
            this.add(MicrodataParser.class);
            this.add(MimeDetector.class);
            this.add(PluginVerifier.class);
            this.add(Rover.class);
            this.add(VocabPrinter.class);
        }
    };

    @Test
    public void testGetToolsInClasspath() throws IOException {
        Iterator tools = new ToolRunner().getToolsInClasspath();
        Assert.assertTrue((String)"No core tools have been detected", (boolean)tools.hasNext());
        while (tools.hasNext()) {
            Assert.assertTrue((String)"Discrepancy between expected and detected tools on classpath. Expected ExtractorDocumentation.class,MicrodataParser.class, MimeDetector.class, PluginVerifier.classRover.class and VocabPrinter.class.", (boolean)this.coreTools.contains(((Tool)tools.next()).getClass()));
        }
    }

    @Test
    public void testGetVersion() throws Exception {
        Assert.assertEquals((long)0L, (long)new ToolRunner().execute(new String[]{"-v"}));
    }

    @Test
    public void testGetHelp() throws Exception {
        Assert.assertEquals((long)0L, (long)new ToolRunner().execute(new String[]{"-h"}));
    }
}

