/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.interpreter.service.handler;

import java.util.ArrayList;
import java.util.List;
import org.apache.airavata.client.api.AmazonWebServicesSettings;
import org.apache.airavata.client.api.CredentialStoreSecuritySettings;
import org.apache.airavata.client.api.HostSchedulingSettings;
import org.apache.airavata.client.api.OutputDataSettings;
import org.apache.airavata.client.api.SecuritySettings;
import org.apache.airavata.client.api.WorkflowOutputDataSettings;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.client.impl.ApplicationOutputDataSettingsImpl;
import org.apache.airavata.client.impl.HPCSettingsImpl;
import org.apache.airavata.client.impl.HostSchedulingSettingsImpl;
import org.apache.airavata.client.impl.NodeSettingsImpl;
import org.apache.airavata.client.impl.WorkflowOutputDataSettingsImpl;
import org.apache.airavata.experiment.execution.ExperimentAdvanceOptions;
import org.apache.airavata.experiment.execution.HPCSettings;
import org.apache.airavata.experiment.execution.NameValuePairType;
import org.apache.airavata.experiment.execution.NodeSettings;

public class MappingUtils {
    public static org.apache.airavata.client.api.ExperimentAdvanceOptions getExperimentOptionsObject(ExperimentAdvanceOptions advanceOptions) {
        try {
            org.apache.airavata.experiment.execution.WorkflowOutputDataSettings workflowOutputDataSettings;
            org.apache.airavata.client.api.ExperimentAdvanceOptions experimentAdvanceOptions = new org.apache.airavata.client.api.ExperimentAdvanceOptions();
            experimentAdvanceOptions.setCustomExperimentId(advanceOptions.getCustomExperimentId());
            experimentAdvanceOptions.setExperimentExecutionUser(advanceOptions.getExecutionUser());
            experimentAdvanceOptions.setExperimentCustomMetadata(advanceOptions.getMetadata());
            experimentAdvanceOptions.setExperimentName(advanceOptions.getExperimentName());
            if (advanceOptions.getWorkflowSchedulingSettings() != null) {
                List nodeSettingsList = advanceOptions.getWorkflowSchedulingSettings().getNodeSettingsList();
                for (NodeSettings nodeSettings : nodeSettingsList) {
                    NodeSettingsImpl n = MappingUtils.getNodeSettingObject(nodeSettings);
                    HPCSettings hpcSettings = nodeSettings.getHpcSettings();
                    org.apache.airavata.client.api.HPCSettings hpcSettingsObject = MappingUtils.getHPCSettingsObject(hpcSettings);
                    n.setHPCSettings(hpcSettingsObject);
                    org.apache.airavata.experiment.execution.HostSchedulingSettings hostSchedulingSettings = nodeSettings.getHostSchedulingSettings();
                    HostSchedulingSettings hostSchedulingSettingsObj = MappingUtils.getHostSchedulingSettingsObj(hostSchedulingSettings);
                    n.setHostSettings(hostSchedulingSettingsObj);
                    experimentAdvanceOptions.getCustomWorkflowSchedulingSettings().addNewNodeSettings(new org.apache.airavata.client.api.NodeSettings[]{n});
                }
            }
            if ((workflowOutputDataSettings = advanceOptions.getWorkflowOutputDataSettings()) != null) {
                WorkflowOutputDataSettings dataSettings = MappingUtils.getWorkflowOutputDataSettingsObject(workflowOutputDataSettings);
                experimentAdvanceOptions.getCustomWorkflowOutputDataSettings().addNewOutputDataSettings(dataSettings.getOutputDataSettingsList());
            }
            SecuritySettings securitySettings = experimentAdvanceOptions.getCustomSecuritySettings();
            org.apache.airavata.experiment.execution.SecuritySettings securitySettings1 = advanceOptions.getSecuritySettings();
            if (securitySettings != null && securitySettings1 != null) {
                CredentialStoreSecuritySettings storeSecuritySettings;
                AmazonWebServicesSettings amazonWSSettings = securitySettings.getAmazonWSSettings();
                if (amazonWSSettings != null) {
                    amazonWSSettings.setAccessKeyId(securitySettings1.getAmazonWSSettings().getAccessKey());
                    amazonWSSettings.setAMIId(securitySettings1.getAmazonWSSettings().getAmiID());
                    amazonWSSettings.setInstanceId(securitySettings1.getAmazonWSSettings().getInstanceID());
                    amazonWSSettings.setInstanceType(securitySettings1.getAmazonWSSettings().getInstanceType());
                    amazonWSSettings.setSecretAccessKey(securitySettings1.getAmazonWSSettings().getSecretAccessKey());
                    amazonWSSettings.setUsername(securitySettings1.getAmazonWSSettings().getUsername());
                }
                if ((storeSecuritySettings = securitySettings.getCredentialStoreSecuritySettings()) != null) {
                    storeSecuritySettings.setGatewayId(securitySettings1.getCredentialStoreSettings().getGatewayID());
                    storeSecuritySettings.setPortalUser(securitySettings1.getCredentialStoreSettings().getPortalUser());
                    storeSecuritySettings.setTokenId(securitySettings1.getCredentialStoreSettings().getTokenId());
                }
            }
            return experimentAdvanceOptions;
        }
        catch (AiravataAPIInvocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static NodeSettingsImpl getNodeSettingObject(NodeSettings nodeSettings) {
        NodeSettingsImpl n = new NodeSettingsImpl(nodeSettings.getNodeId());
        n.setServiceId(nodeSettings.getServiceId());
        ArrayList<org.apache.airavata.client.tools.NameValuePairType> nameValuePairTypes = new ArrayList<org.apache.airavata.client.tools.NameValuePairType>();
        List nameValuePairList = nodeSettings.getNameValuePairList();
        for (NameValuePairType np : nameValuePairList) {
            org.apache.airavata.client.tools.NameValuePairType nameValuePairObject = MappingUtils.getNameValuePairObject(np);
            nameValuePairTypes.add(nameValuePairObject);
        }
        n.setNameValuePair(nameValuePairTypes);
        return n;
    }

    public static org.apache.airavata.client.tools.NameValuePairType getNameValuePairObject(NameValuePairType nameValuePairType) {
        org.apache.airavata.client.tools.NameValuePairType nameValuePair = new org.apache.airavata.client.tools.NameValuePairType();
        nameValuePair.setName(nameValuePairType.getName());
        nameValuePair.setValue(nameValuePairType.getValue());
        nameValuePair.setDescription(nameValuePairType.getDescription());
        return nameValuePair;
    }

    public static org.apache.airavata.client.api.HPCSettings getHPCSettingsObject(HPCSettings hsettings) {
        HPCSettingsImpl hpcSettings = new HPCSettingsImpl();
        hpcSettings.setCPUCount(Integer.valueOf(hsettings.getCpuCount()));
        hpcSettings.setJobManager(hsettings.getJobManager());
        hpcSettings.setMaxWallTime(Integer.valueOf(hsettings.getMaxWalltime()));
        hpcSettings.setNodeCount(Integer.valueOf(hsettings.getNodeCount()));
        hpcSettings.setQueueName(hsettings.getQueueName());
        return hpcSettings;
    }

    public static HostSchedulingSettings getHostSchedulingSettingsObj(org.apache.airavata.experiment.execution.HostSchedulingSettings schedulingSettings) {
        HostSchedulingSettingsImpl hostSchedulingSettings = new HostSchedulingSettingsImpl();
        hostSchedulingSettings.setHostId(schedulingSettings.getHostID());
        hostSchedulingSettings.setGatekeeperEPR(schedulingSettings.getGatekeeperEPR());
        hostSchedulingSettings.setWSGramPreffered(Boolean.valueOf(schedulingSettings.isIsWSGramPreferred()));
        return hostSchedulingSettings;
    }

    public static WorkflowOutputDataSettings getWorkflowOutputDataSettingsObject(org.apache.airavata.experiment.execution.WorkflowOutputDataSettings wfods) {
        WorkflowOutputDataSettingsImpl wfOutDataSettings = new WorkflowOutputDataSettingsImpl();
        List dataSettingsList = wfods.getOutputDataSettingsList();
        for (org.apache.airavata.experiment.execution.OutputDataSettings outPutDSettng : dataSettingsList) {
            ApplicationOutputDataSettingsImpl outputDataSettings = new ApplicationOutputDataSettingsImpl(outPutDSettng.getNodeID());
            outputDataSettings.setDataPersistent(Boolean.valueOf(outPutDSettng.isIsdataPersisted()));
            outputDataSettings.setDataRegistryUrl(outPutDSettng.getDataRegURL());
            outputDataSettings.setOutputDataDirectory(outPutDSettng.getOutputdataDir());
            wfOutDataSettings.addNewOutputDataSettings(new OutputDataSettings[]{outputDataSettings});
        }
        return wfOutDataSettings;
    }
}

