/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool.spi;

import jakarta.jms.ConnectionFactory;
import java.util.Properties;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.tool.spi.SPIConnectionFactory;

public class ActiveMQPojoSPI
implements SPIConnectionFactory {
    public static final String KEY_BROKER_URL = "brokerUrl";
    public static final String KEY_USERNAME = "username";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_CLIENT_ID = "clientID";
    public static final String KEY_ASYNC_SEND = "asyncSend";
    public static final String KEY_ASYNC_DISPATCH = "asyncDispatch";
    public static final String KEY_ASYNC_SESSION = "asyncSession";
    public static final String KEY_CLOSE_TIMEOUT = "closeTimeout";
    public static final String KEY_COPY_MSG_ON_SEND = "copyMsgOnSend";
    public static final String KEY_DISABLE_TIMESTAMP = "disableTimestamp";
    public static final String KEY_DEFER_OBJ_SERIAL = "deferObjSerial";
    public static final String KEY_OPTIM_ACK = "optimAck";
    public static final String KEY_OPTIM_DISPATCH = "optimDispatch";
    public static final String KEY_PREFETCH_QUEUE = "prefetchQueue";
    public static final String KEY_PREFETCH_TOPIC = "prefetchTopic";
    public static final String KEY_USE_COMPRESSION = "useCompression";
    public static final String KEY_USE_RETROACTIVE = "useRetroactive";

    @Override
    public ConnectionFactory createConnectionFactory(Properties settings) throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        this.configureConnectionFactory((ConnectionFactory)factory, settings);
        return factory;
    }

    @Override
    public void configureConnectionFactory(ConnectionFactory jmsFactory, Properties settings) throws Exception {
        ActiveMQConnectionFactory factory = (ActiveMQConnectionFactory)jmsFactory;
        String setting = settings.getProperty(KEY_BROKER_URL);
        if (setting != null && setting.length() > 0) {
            factory.setBrokerURL(setting);
        }
        if ((setting = settings.getProperty(KEY_USERNAME)) != null && setting.length() > 0) {
            factory.setUserName(setting);
        }
        if ((setting = settings.getProperty(KEY_PASSWORD)) != null && setting.length() > 0) {
            factory.setPassword(setting);
        }
        if ((setting = settings.getProperty(KEY_CLIENT_ID)) != null && setting.length() > 0) {
            factory.setClientID(setting);
        }
        if ((setting = settings.getProperty(KEY_ASYNC_SEND)) != null && setting.length() > 0) {
            factory.setUseAsyncSend(Boolean.getBoolean(setting));
        }
        if ((setting = settings.getProperty(KEY_ASYNC_DISPATCH)) != null && setting.length() > 0) {
            factory.setDispatchAsync(Boolean.getBoolean(setting));
        }
        if ((setting = settings.getProperty(KEY_ASYNC_SESSION)) != null && setting.length() > 0) {
            factory.setAlwaysSessionAsync(Boolean.getBoolean(setting));
        }
        if ((setting = settings.getProperty(KEY_CLOSE_TIMEOUT)) != null && setting.length() > 0) {
            factory.setCloseTimeout(Integer.parseInt(setting));
        }
        if ((setting = settings.getProperty(KEY_COPY_MSG_ON_SEND)) != null && setting.length() > 0) {
            factory.setCopyMessageOnSend(Boolean.getBoolean(setting));
        }
        if ((setting = settings.getProperty(KEY_DISABLE_TIMESTAMP)) != null && setting.length() > 0) {
            factory.setDisableTimeStampsByDefault(Boolean.getBoolean(setting));
        }
        if ((setting = settings.getProperty(KEY_DEFER_OBJ_SERIAL)) != null && setting.length() > 0) {
            factory.setObjectMessageSerializationDefered(Boolean.getBoolean(setting));
        }
        if ((setting = settings.getProperty(KEY_OPTIM_ACK)) != null && setting.length() > 0) {
            factory.setOptimizeAcknowledge(Boolean.getBoolean(setting));
        }
        if ((setting = settings.getProperty(KEY_OPTIM_DISPATCH)) != null && setting.length() > 0) {
            factory.setOptimizedMessageDispatch(Boolean.getBoolean(setting));
        }
        if ((setting = settings.getProperty(KEY_PREFETCH_QUEUE)) != null && setting.length() > 0) {
            factory.getPrefetchPolicy().setQueuePrefetch(Integer.parseInt(setting));
        }
        if ((setting = settings.getProperty(KEY_PREFETCH_TOPIC)) != null && setting.length() > 0) {
            factory.getPrefetchPolicy().setTopicPrefetch(Integer.parseInt(setting));
        }
        if ((setting = settings.getProperty(KEY_USE_COMPRESSION)) != null && setting.length() > 0) {
            factory.setUseCompression(Boolean.getBoolean(setting));
        }
        if ((setting = settings.getProperty(KEY_USE_RETROACTIVE)) != null && setting.length() > 0) {
            factory.setUseRetroactiveConsumer(Boolean.getBoolean(setting));
        }
    }
}

