/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class XBeanFileResolver {
    private static final String XBEAN_FILE = "xbean:file:";

    public boolean isXBeanFile(String configUri) {
        return configUri.startsWith(XBEAN_FILE);
    }

    public String toUrlCompliantAbsolutePath(String configUri) {
        if (!this.isXBeanFile(configUri)) {
            return configUri;
        }
        String filePath = this.extractFilePath(configUri);
        return XBEAN_FILE + this.toAbsolutePath(filePath);
    }

    private String extractFilePath(String configUri) {
        return configUri.substring(this.getIndexFilePath(configUri), configUri.length());
    }

    private int getIndexFilePath(String configUri) {
        return configUri.indexOf(XBEAN_FILE) + XBEAN_FILE.length();
    }

    private String toAbsolutePath(String path) {
        try {
            URL url = new File(path).toURI().toURL();
            return this.toFilePath(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to resolve relative path for: " + path, e);
        }
    }

    private String toFilePath(URL url) {
        String filePath = url.getFile();
        return this.underWindows() ? this.removePrependingSlash(filePath) : filePath;
    }

    private String removePrependingSlash(String filePath) {
        return filePath.substring(1, filePath.length());
    }

    private boolean underWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }
}

