/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.message;

import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.Assert;
import org.objectweb.jtests.jms.framework.PTPTestCase;
import org.objectweb.jtests.jms.framework.TestConfig;

public class MessageTypeTest
extends PTPTestCase {
    public void testStreamMessage_2() {
        try {
            StreamMessage message = this.senderSession.createStreamMessage();
            message.writeString("pi");
            message.writeDouble(3.14159);
            this.sender.send((Message)message);
            Message m = this.receiver.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((String)"The message should be an instance of StreamMessage.\n", (boolean)(m instanceof StreamMessage));
            StreamMessage msg = (StreamMessage)m;
            Assert.assertEquals((Object)"pi", (Object)msg.readString());
            Assert.assertEquals((double)3.14159, (double)msg.readDouble(), (double)0.0);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testStreamMessage_1() {
        try {
            StreamMessage message = this.senderSession.createStreamMessage();
            this.sender.send((Message)message);
            Message msg = this.receiver.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((String)"The message should be an instance of StreamMessage.\n", (boolean)(msg instanceof StreamMessage));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testMapMessageConversion() {
        try {
            MapMessage message = this.senderSession.createMapMessage();
            message.setDouble("pi", 3.14159);
            this.sender.send((Message)message);
            Message m = this.receiver.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((String)"The message should be an instance of MapMessage.\n", (boolean)(m instanceof MapMessage));
            MapMessage msg = (MapMessage)m;
            Assert.assertTrue((boolean)(msg.getObject("pi") instanceof Double));
            Assert.assertEquals((double)3.14159, (double)((Double)msg.getObject("pi")), (double)0.0);
            Assert.assertEquals((double)3.14159, (double)msg.getDouble("pi"), (double)0.0);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testNullInSetMethodsForMapMessage() {
        try {
            MapMessage message = this.senderSession.createMapMessage();
            message.setBoolean(null, true);
            Assert.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException message) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw an IllegalArgumentException, not a" + String.valueOf((Object)e)));
        }
    }

    public void testEmptyStringInSetMethodsForMapMessage() {
        try {
            MapMessage message = this.senderSession.createMapMessage();
            message.setBoolean("", true);
            Assert.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException message) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw an IllegalArgumentException, not a" + String.valueOf((Object)e)));
        }
    }

    public void testgetMapNames() {
        try {
            MapMessage message = this.senderSession.createMapMessage();
            Enumeration e = message.getMapNames();
            Assert.assertTrue((String)"No map yet defined.\n", (!e.hasMoreElements() ? 1 : 0) != 0);
            message.setDouble("pi", 3.14159);
            e = message.getMapNames();
            Assert.assertEquals((Object)"pi", (Object)((String)e.nextElement()));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testMapMessage_2() {
        try {
            MapMessage message = this.senderSession.createMapMessage();
            message.setString("name", "pi");
            message.setDouble("value", 3.14159);
            this.sender.send((Message)message);
            Message m = this.receiver.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((String)"The message should be an instance of MapMessage.\n", (boolean)(m instanceof MapMessage));
            MapMessage msg = (MapMessage)m;
            Assert.assertEquals((Object)"pi", (Object)msg.getString("name"));
            Assert.assertEquals((double)3.14159, (double)msg.getDouble("value"), (double)0.0);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testMapMessage_1() {
        try {
            MapMessage message = this.senderSession.createMapMessage();
            this.sender.send((Message)message);
            Message msg = this.receiver.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((String)"The message should be an instance of MapMessage.\n", (boolean)(msg instanceof MapMessage));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testObjectMessage_2() {
        try {
            Vector<Object> vector = new Vector<Object>();
            vector.add("pi");
            vector.add(new Double(3.14159));
            ObjectMessage message = this.senderSession.createObjectMessage();
            message.setObject(vector);
            this.sender.send((Message)message);
            Message m = this.receiver.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((String)"The message should be an instance of ObjectMessage.\n", (boolean)(m instanceof ObjectMessage));
            ObjectMessage msg = (ObjectMessage)m;
            Assert.assertEquals(vector, (Object)msg.getObject());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testObjectMessage_1() {
        try {
            ObjectMessage message = this.senderSession.createObjectMessage();
            this.sender.send((Message)message);
            Message msg = this.receiver.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((String)"The message should be an instance of ObjectMessage.\n", (boolean)(msg instanceof ObjectMessage));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBytesMessage_2() {
        try {
            byte[] bytes = new String("pi").getBytes();
            BytesMessage message = this.senderSession.createBytesMessage();
            message.writeBytes(bytes);
            message.writeDouble(3.14159);
            this.sender.send((Message)message);
            Message m = this.receiver.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((String)"The message should be an instance of BytesMessage.\n", (boolean)(m instanceof BytesMessage));
            BytesMessage msg = (BytesMessage)m;
            byte[] receivedBytes = new byte[bytes.length];
            msg.readBytes(receivedBytes);
            Assert.assertEquals((Object)new String(bytes), (Object)new String(receivedBytes));
            Assert.assertEquals((double)3.14159, (double)msg.readDouble(), (double)0.0);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBytesMessage_1() {
        try {
            BytesMessage message = this.senderSession.createBytesMessage();
            this.sender.send((Message)message);
            Message msg = this.receiver.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((String)"The message should be an instance of BytesMessage.\n", (boolean)(msg instanceof BytesMessage));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testTextMessage_2() {
        try {
            TextMessage message = this.senderSession.createTextMessage();
            message.setText("testTextMessage_2");
            this.sender.send((Message)message);
            Message m = this.receiver.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((String)"The message should be an instance of TextMessage.\n", (boolean)(m instanceof TextMessage));
            TextMessage msg = (TextMessage)m;
            Assert.assertEquals((Object)"testTextMessage_2", (Object)msg.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testTextMessage_1() {
        try {
            TextMessage message = this.senderSession.createTextMessage();
            this.sender.send((Message)message);
            Message msg = this.receiver.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((String)"The message should be an instance of TextMessage.\n", (boolean)(msg instanceof TextMessage));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public static Test suite() {
        return new TestSuite(MessageTypeTest.class);
    }

    public MessageTypeTest(String name) {
        super(name);
    }
}

