/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.policy;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.SlowConsumerStrategy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.management.CountStatisticImpl;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.usage.MemoryUsage;
import org.apache.activemq.usage.Usage;
import org.apache.activemq.usage.UsageCapacity;
import org.apache.activemq.usage.UsageListener;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class DestinationProxy
implements Destination {
    private final String name;
    private final Queue view;
    private final ActiveMQServer server;

    public DestinationProxy(Queue view, String name, ActiveMQServer server) {
        this.view = view;
        this.name = name;
        this.server = server;
    }

    public void addSubscription(ConnectionContext context, Subscription sub) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void removeSubscription(ConnectionContext context, Subscription sub, long lastDeliveredSequenceId) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void send(ProducerBrokerExchange producerExchange, Message messageSend) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void acknowledge(ConnectionContext context, Subscription sub, MessageAck ack, MessageReference node) throws IOException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public long getInactiveTimeoutBeforeGC() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void markForGC(long timeStamp) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean canGC() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void gc() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public ActiveMQDestination getActiveMQDestination() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public MemoryUsage getMemoryUsage() {
        return new MemoryUsage(){

            public void waitForSpace() throws InterruptedException {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public boolean waitForSpace(long timeout) throws InterruptedException {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public boolean isFull() {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public void enqueueUsage(long value) throws InterruptedException {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public void increaseUsage(long value) {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public void decreaseUsage(long value) {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            protected long retrieveUsage() {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public long getUsage() {
                try {
                    return DestinationProxy.this.server.getPagingManager().getPageStore(DestinationProxy.this.view.getAddress()).getAddressSize();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void setUsage(long usage) {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public void setPercentOfJvmHeap(int percentOfJvmHeap) {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public boolean waitForSpace(long timeout, int highWaterMark) throws InterruptedException {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public boolean isFull(int highWaterMark) {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public void addUsageListener(UsageListener listener) {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public void removeUsageListener(UsageListener listener) {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public int getNumUsageListeners() {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public long getLimit() {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public void setLimit(long limit) {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            protected void onLimitChange() {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public float getUsagePortion() {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public void setUsagePortion(float usagePortion) {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public int getPercentUsage() {
                long total = 0L;
                try {
                    total = DestinationProxy.this.server.getPagingManager().getPageStore(DestinationProxy.this.view.getAddress()).getMaxSize();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return (int)((double)((float)this.getUsage() / (float)total) * 100.0);
            }

            protected void setPercentUsage(int value) {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public int getPercentUsageMinDelta() {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public void setPercentUsageMinDelta(int percentUsageMinDelta) {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            protected int caclPercentUsage() {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public String getName() {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public void setName(String name) {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public String toString() {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public void start() {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public void stop() {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            protected void addChild(MemoryUsage child) {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            protected void removeChild(MemoryUsage child) {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public boolean notifyCallbackWhenNotFull(Runnable callback) {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public UsageCapacity getLimiter() {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public void setLimiter(UsageCapacity limiter) {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public int getPollingTime() {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public void setPollingTime(int pollingTime) {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public MemoryUsage getParent() {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public void setParent(MemoryUsage parent) {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public ThreadPoolExecutor getExecutor() {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public void setExecutor(ThreadPoolExecutor executor) {
                throw new UnsupportedOperationException("Not implemented yet");
            }

            public boolean isStarted() {
                throw new UnsupportedOperationException("Not implemented yet");
            }
        };
    }

    public void setMemoryUsage(MemoryUsage memoryUsage) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void dispose(ConnectionContext context) throws IOException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean isDisposed() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DestinationStatistics getDestinationStatistics() {
        return new DestinationStatistics(){

            private CountStatisticImpl newFakeCountStatistic(Answer<?> getCountFunction) {
                CountStatisticImpl mock = (CountStatisticImpl)Mockito.mock(CountStatisticImpl.class);
                ((CountStatisticImpl)Mockito.doAnswer(getCountFunction).when((Object)mock)).getCount();
                return mock;
            }

            public CountStatisticImpl getEnqueues() {
                return this.newFakeCountStatistic(invocation -> DestinationProxy.this.view.getMessagesAdded());
            }

            public CountStatisticImpl getDequeues() {
                return this.newFakeCountStatistic(invocation -> DestinationProxy.this.view.getMessagesAcknowledged());
            }

            public CountStatisticImpl getDispatched() {
                return this.newFakeCountStatistic(invocation -> this.getDequeues().getCount() + this.getInflight().getCount());
            }

            public CountStatisticImpl getExpired() {
                return this.newFakeCountStatistic(invocation -> DestinationProxy.this.view.getMessagesExpired());
            }

            public CountStatisticImpl getMessages() {
                return this.newFakeCountStatistic(invocation -> DestinationProxy.this.view.getMessageCount());
            }

            public CountStatisticImpl getInflight() {
                return this.newFakeCountStatistic(invocation -> (long)DestinationProxy.this.view.getDeliveringCount());
            }
        };
    }

    public DeadLetterStrategy getDeadLetterStrategy() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Message[] browse() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public String getName() {
        return this.name;
    }

    public MessageStore getMessageStore() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean isProducerFlowControl() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setProducerFlowControl(boolean value) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean isAlwaysRetroactive() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setAlwaysRetroactive(boolean value) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public long getBlockedProducerWarningInterval() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setBlockedProducerWarningInterval(long blockedProducerWarningInterval) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public int getMaxProducersToAudit() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setMaxProducersToAudit(int maxProducersToAudit) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public int getMaxAuditDepth() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setMaxAuditDepth(int maxAuditDepth) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean isEnableAudit() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setEnableAudit(boolean enableAudit) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean isActive() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public int getMaxPageSize() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setMaxPageSize(int maxPageSize) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public int getMaxBrowsePageSize() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setMaxBrowsePageSize(int maxPageSize) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean isUseCache() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setUseCache(boolean useCache) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public int getMinimumMessageSize() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setMinimumMessageSize(int minimumMessageSize) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public int getCursorMemoryHighWaterMark() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setCursorMemoryHighWaterMark(int cursorMemoryHighWaterMark) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void wakeup() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean isLazyDispatch() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setLazyDispatch(boolean value) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void messageExpired(ConnectionContext context, Subscription subs, MessageReference node) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void messageConsumed(ConnectionContext context, MessageReference messageReference) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void messageDelivered(ConnectionContext context, MessageReference messageReference) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void messageDiscarded(ConnectionContext context, Subscription sub, MessageReference messageReference) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void slowConsumer(ConnectionContext context, Subscription subs) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void fastProducer(ConnectionContext context, ProducerInfo producerInfo) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void isFull(ConnectionContext context, Usage<?> usage) {
    }

    public List<Subscription> getConsumers() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void processDispatchNotification(MessageDispatchNotification messageDispatchNotification) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean isPrioritizedMessages() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public SlowConsumerStrategy getSlowConsumerStrategy() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean isDoOptimzeMessageStorage() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setDoOptimzeMessageStorage(boolean doOptimzeMessageStorage) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void clearPendingMessages() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void duplicateFromStore(Message message, Subscription subscription) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void start() throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void stop() throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean iterate() {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

