/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.rest.queue.push;

import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;
import org.apache.activemq.artemis.rest.ActiveMQRestLogger;
import org.apache.activemq.artemis.rest.queue.push.ActiveMQPushStrategy;
import org.apache.activemq.artemis.rest.queue.push.PushConsumerMessageHandler;
import org.apache.activemq.artemis.rest.queue.push.PushStore;
import org.apache.activemq.artemis.rest.queue.push.PushStrategy;
import org.apache.activemq.artemis.rest.queue.push.UriStrategy;
import org.apache.activemq.artemis.rest.queue.push.UriTemplateStrategy;
import org.apache.activemq.artemis.rest.queue.push.xml.PushRegistration;
import org.apache.activemq.artemis.utils.SelectorTranslator;

public class PushConsumer {
    protected PushRegistration registration;
    protected ClientSessionFactory factory;
    protected List<ClientSession> sessions;
    protected List<ClientConsumer> consumers;
    protected String destination;
    protected String id;
    protected PushStrategy strategy;
    protected PushStore store;
    private ConnectionFactoryOptions jmsOptions;

    public PushConsumer(ClientSessionFactory factory, String destination, String id, PushRegistration registration, PushStore store, ConnectionFactoryOptions jmsOptions) {
        this.factory = factory;
        this.destination = destination;
        this.id = id;
        this.registration = registration;
        this.store = store;
        this.jmsOptions = jmsOptions;
    }

    public PushStrategy getStrategy() {
        return this.strategy;
    }

    public PushRegistration getRegistration() {
        return this.registration;
    }

    public String getDestination() {
        return this.destination;
    }

    public void start() throws Exception {
        if (this.registration.getTarget().getClassName() != null) {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.registration.getTarget().getClassName());
            this.strategy = (PushStrategy)clazz.newInstance();
        } else if (this.registration.getTarget().getRelationship() != null) {
            if (this.registration.getTarget().getRelationship().equals("destination")) {
                this.strategy = new ActiveMQPushStrategy();
            } else if (this.registration.getTarget().getRelationship().equals("template")) {
                this.strategy = new UriTemplateStrategy();
            }
        }
        if (this.strategy == null) {
            this.strategy = new UriStrategy();
        }
        this.strategy.setRegistration(this.registration);
        this.strategy.setJmsOptions(this.jmsOptions);
        this.strategy.start();
        this.sessions = new ArrayList<ClientSession>();
        this.consumers = new ArrayList<ClientConsumer>();
        for (int i = 0; i < this.registration.getSessionCount(); ++i) {
            ClientSession session = this.factory.createSession(false, false, 0);
            ClientConsumer consumer = this.registration.getSelector() != null ? session.createConsumer(this.destination, SelectorTranslator.convertToActiveMQFilterString((String)this.registration.getSelector())) : session.createConsumer(this.destination);
            consumer.setMessageHandler((MessageHandler)new PushConsumerMessageHandler(this, session));
            session.start();
            ActiveMQRestLogger.LOGGER.startingPushConsumer(this.registration.getTarget());
            this.consumers.add(consumer);
            this.sessions.add(session);
        }
    }

    public void stop() {
        for (ClientSession session : this.sessions) {
            try {
                if (session == null) continue;
                session.close();
            }
            catch (ActiveMQException activeMQException) {}
        }
        try {
            if (this.strategy != null) {
                this.strategy.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void disableFromFailure() {
        this.registration.setEnabled(false);
        try {
            if (this.registration.isDurable()) {
                this.store.update(this.registration);
            }
        }
        catch (Exception e) {
            ActiveMQRestLogger.LOGGER.errorUpdatingStore(e);
        }
        this.stop();
    }
}

