/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.component;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.ActiveMQWebLogger;
import org.apache.activemq.artemis.components.ExternalComponent;
import org.apache.activemq.artemis.dto.AppDTO;
import org.apache.activemq.artemis.dto.ComponentDTO;
import org.apache.activemq.artemis.dto.WebServerDTO;
import org.apache.activemq.artemis.utils.TimeUtils;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebServerComponent
implements ExternalComponent {
    private Server server;
    private HandlerList handlers;
    private WebServerDTO webServerConfig;
    private URI uri;
    private String jolokiaUrl;
    private List<WebAppContext> webContexts;

    public void configure(ComponentDTO config, String artemisInstance, String artemisHome) throws Exception {
        this.webServerConfig = (WebServerDTO)config;
        this.uri = new URI(this.webServerConfig.bind);
        this.server = new Server();
        String scheme = this.uri.getScheme();
        ServerConnector connector = null;
        if ("https".equals(scheme)) {
            SslContextFactory sslFactory = new SslContextFactory();
            sslFactory.setKeyStorePath(this.webServerConfig.keyStorePath == null ? artemisInstance + "/etc/keystore.jks" : this.webServerConfig.keyStorePath);
            sslFactory.setKeyStorePassword(this.webServerConfig.keyStorePassword == null ? "password" : this.webServerConfig.keyStorePassword);
            if (this.webServerConfig.clientAuth != null) {
                sslFactory.setNeedClientAuth(this.webServerConfig.clientAuth.booleanValue());
                if (this.webServerConfig.clientAuth.booleanValue()) {
                    sslFactory.setTrustStorePath(this.webServerConfig.trustStorePath);
                    sslFactory.setTrustStorePassword(this.webServerConfig.trustStorePassword);
                }
            }
            SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslFactory, "HTTP/1.1");
            HttpConfiguration https = new HttpConfiguration();
            https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            HttpConnectionFactory httpFactory = new HttpConnectionFactory(https);
            connector = new ServerConnector(this.server, new ConnectionFactory[]{sslConnectionFactory, httpFactory});
        } else {
            connector = new ServerConnector(this.server);
        }
        connector.setPort(this.uri.getPort());
        connector.setHost(this.uri.getHost());
        this.server.setConnectors(new Connector[]{connector});
        this.handlers = new HandlerList();
        Path warDir = Paths.get(artemisHome != null ? artemisHome : ".", new String[0]).resolve(this.webServerConfig.path).toAbsolutePath();
        if (this.webServerConfig.apps != null && this.webServerConfig.apps.size() > 0) {
            this.webContexts = new ArrayList<WebAppContext>();
            for (AppDTO app : this.webServerConfig.apps) {
                WebAppContext webContext = this.deployWar(app.url, app.war, warDir);
                this.webContexts.add(webContext);
                if (!app.war.startsWith("jolokia")) continue;
                this.jolokiaUrl = this.webServerConfig.bind + "/" + app.url;
            }
        }
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setResourceBase(warDir.toString());
        resourceHandler.setDirectoriesListed(true);
        resourceHandler.setWelcomeFiles(new String[]{"index.html"});
        DefaultHandler defaultHandler = new DefaultHandler();
        defaultHandler.setServeIcon(false);
        this.handlers.addHandler((Handler)resourceHandler);
        this.handlers.addHandler((Handler)defaultHandler);
        this.server.setHandler((Handler)this.handlers);
    }

    public void start() throws Exception {
        this.server.start();
        ActiveMQWebLogger.LOGGER.webserverStarted(this.webServerConfig.bind);
        if (this.jolokiaUrl != null) {
            ActiveMQWebLogger.LOGGER.jolokiaAvailable(this.jolokiaUrl);
        }
    }

    public void stop() throws Exception {
        this.server.stop();
        if (this.webContexts != null) {
            File tmpdir = null;
            for (WebAppContext context : this.webContexts) {
                tmpdir = context.getTempDirectory();
                if (tmpdir == null || context.isPersistTempDirectory()) continue;
                boolean fileDeleted = TimeUtils.waitOnBoolean((boolean)false, (long)10000L, tmpdir::exists);
                if (fileDeleted) continue;
                ActiveMQWebLogger.LOGGER.tmpFileNotDeleted(tmpdir);
            }
            this.webContexts.clear();
        }
    }

    public boolean isStarted() {
        return this.server != null && this.server.isStarted();
    }

    private WebAppContext deployWar(String url, String warFile, Path warDirectory) throws IOException {
        WebAppContext webapp = new WebAppContext();
        if (url.startsWith("/")) {
            webapp.setContextPath(url);
        } else {
            webapp.setContextPath("/" + url);
        }
        webapp.setWar(warDirectory.resolve(warFile).toString());
        this.handlers.addHandler((Handler)webapp);
        return webapp;
    }
}

