/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.extensions;

import java.lang.ref.Reference;
import org.apache.activemq.artemis.tests.extensions.ThreadLeakCheckDelegate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ThreadLeakCheckExtension
implements BeforeAllCallback,
AfterAllCallback,
Extension {
    private ThreadLeakCheckDelegate delegate = new ThreadLeakCheckDelegate();

    public void beforeAll(ExtensionContext context) throws Exception {
        this.delegate.beforeTest();
    }

    public void disable() {
        this.delegate.disable();
    }

    public void afterAll(ExtensionContext context) throws Exception {
        Throwable executionException = context.getExecutionException().orElse(null);
        this.delegate.afterTest(executionException, context.getDisplayName(), failMsg -> Assertions.fail((String)failMsg));
    }

    public static void forceGC() {
        ThreadLeakCheckDelegate.forceGC();
    }

    public static void forceGC(Reference<?> ref, long timeout) {
        ThreadLeakCheckDelegate.forceGC(ref, timeout);
    }

    public static void removeKownThread(String name) {
        ThreadLeakCheckDelegate.removeKownThread(name);
    }

    public static void addKownThread(String name) {
        ThreadLeakCheckDelegate.addKownThread(name);
    }
}

