/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.extensions;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.nativo.jlibaio.LibaioContext;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibaioContextCheckExtension
implements Extension,
BeforeAllCallback,
AfterAllCallback {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int INTERVAL = 100;
    private static final int WAIT = 20000;
    private static String previouslyFailedTotalMaxIoMessage;

    public void beforeAll(ExtensionContext context) throws Exception {
        LibaioContextCheckExtension.checkLibaioBefore(context.getRequiredTestClass().getName());
    }

    public void afterAll(ExtensionContext context) throws Exception {
        LibaioContextCheckExtension.checkLibaioAfter(context.getRequiredTestClass().getName());
    }

    public static void checkLibaioBefore(String testClassName) {
        long totalMaxIO;
        if (previouslyFailedTotalMaxIoMessage != null) {
            Assertions.fail((String)previouslyFailedTotalMaxIoMessage);
        }
        if ((totalMaxIO = LibaioContext.getTotalMaxIO()) != 0L) {
            LibaioContextCheckExtension.failDueToLibaioContextCheck("LibaioContext TotalMaxIO > 0 leak detected BEFORE class %s, TotalMaxIO=%s. Check prior test classes for issue (not possible to be sure of which here).", testClassName, totalMaxIO);
        }
    }

    public static void checkLibaioAfter(String testClassName) {
        if (previouslyFailedTotalMaxIoMessage != null) {
            return;
        }
        try {
            if (!LibaioContextCheckExtension.waitForLibaioContextTotalMaxIo(testClassName)) {
                long totalMaxIO = LibaioContext.getTotalMaxIO();
                LibaioContextCheckExtension.failDueToLibaioContextCheck("LibaioContext TotalMaxIO > 0 leak detected AFTER class %s, TotalMaxIO=%s.", testClassName, totalMaxIO);
            }
        }
        catch (Exception e) {
            Assertions.fail((String)("Exception while checking Libaio after tests in class: " + testClassName));
        }
    }

    private static boolean waitForLibaioContextTotalMaxIo(String testClassName) {
        AtomicBoolean firstCheck = new AtomicBoolean();
        return Wait.waitFor(() -> {
            boolean totalIsZero;
            boolean bl = totalIsZero = LibaioContext.getTotalMaxIO() == 0L;
            if (!totalIsZero && firstCheck.compareAndSet(false, true)) {
                logger.info("Waiting for LibaioContext TotalMaxIO to become 0 after class {}", (Object)testClassName);
            }
            return totalIsZero;
        }, 20000L, 100L);
    }

    private static void failDueToLibaioContextCheck(String currentFailureMessageFormat, String testClassName, long totalMaxIO) {
        previouslyFailedTotalMaxIoMessage = String.format("Aborting, LibaioContext TotalMaxIO > 0 issue previously detected by test class %s, see its output.", testClassName);
        String message = String.format(currentFailureMessageFormat, testClassName, totalMaxIO);
        logger.error(message);
        Assertions.fail((String)message);
    }
}

