/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.service.extensions.xa.recovery;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;

public class XARecoveryConfig {
    public static final String JNDI_NAME_PROPERTY_KEY = "JNDI_NAME";
    private final boolean ha;
    private final TransportConfiguration[] transportConfiguration;
    private final DiscoveryGroupConfiguration discoveryConfiguration;
    private final String username;
    private final String password;
    private final Map<String, String> properties;

    public static XARecoveryConfig newConfig(ActiveMQConnectionFactory factory, String userName, String password, Map<String, String> properties) {
        if (factory.getServerLocator().getDiscoveryGroupConfiguration() != null) {
            return new XARecoveryConfig(factory.getServerLocator().isHA(), factory.getServerLocator().getDiscoveryGroupConfiguration(), userName, password, properties);
        }
        return new XARecoveryConfig(factory.getServerLocator().isHA(), factory.getServerLocator().getStaticTransportConfigurations(), userName, password, properties);
    }

    public XARecoveryConfig(boolean ha, TransportConfiguration[] transportConfiguration, String username, String password, Map<String, String> properties) {
        this.transportConfiguration = transportConfiguration;
        this.discoveryConfiguration = null;
        this.username = username;
        this.password = password;
        this.ha = ha;
        this.properties = properties == null ? Collections.unmodifiableMap(new HashMap()) : Collections.unmodifiableMap(properties);
    }

    public XARecoveryConfig(boolean ha, DiscoveryGroupConfiguration discoveryConfiguration, String username, String password, Map<String, String> properties) {
        this.discoveryConfiguration = discoveryConfiguration;
        this.transportConfiguration = null;
        this.username = username;
        this.password = password;
        this.ha = ha;
        this.properties = properties == null ? Collections.unmodifiableMap(new HashMap()) : Collections.unmodifiableMap(properties);
    }

    public boolean isHA() {
        return this.ha;
    }

    public DiscoveryGroupConfiguration getDiscoveryConfiguration() {
        return this.discoveryConfiguration;
    }

    public TransportConfiguration[] getTransportConfig() {
        return this.transportConfiguration;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public ServerLocator createServerLocator() {
        if (this.getDiscoveryConfiguration() != null) {
            return ActiveMQClient.createServerLocator((boolean)this.isHA(), (DiscoveryGroupConfiguration)this.getDiscoveryConfiguration());
        }
        return ActiveMQClient.createServerLocator((boolean)this.isHA(), (TransportConfiguration[])this.getTransportConfig());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.discoveryConfiguration == null ? 0 : this.discoveryConfiguration.hashCode());
        result = 31 * result + Arrays.hashCode(this.transportConfiguration);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XARecoveryConfig other = (XARecoveryConfig)obj;
        if (this.discoveryConfiguration == null ? other.discoveryConfiguration != null : !this.discoveryConfiguration.equals((Object)other.discoveryConfiguration)) {
            return false;
        }
        return Arrays.equals(this.transportConfiguration, other.transportConfiguration);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("XARecoveryConfig [transportConfiguration=" + Arrays.toString(this.transportConfiguration));
        builder.append(", discoveryConfiguration=" + this.discoveryConfiguration);
        builder.append(", username=" + this.username);
        builder.append(", password=****");
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            builder.append(", " + entry.getKey() + "=" + entry.getValue());
        }
        builder.append("]");
        return builder.toString();
    }
}

