/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.service.extensions.xa.recovery;

import java.util.Arrays;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.service.extensions.xa.recovery.ActiveMQXARecoveryLogger;
import org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig;

public class ActiveMQXAResourceWrapper
implements XAResource,
SessionFailureListener {
    private static final Object lock = new Object();
    private ServerLocator serverLocator;
    private ClientSessionFactory csf;
    private ClientSession delegate;
    private XARecoveryConfig[] xaRecoveryConfigs;

    public ActiveMQXAResourceWrapper(XARecoveryConfig ... xaRecoveryConfigs) {
        this.xaRecoveryConfigs = xaRecoveryConfigs;
        if (ActiveMQXARecoveryLogger.LOGGER.isDebugEnabled()) {
            ActiveMQXARecoveryLogger.LOGGER.debug("Recovery configured with " + Arrays.toString(xaRecoveryConfigs) + ", instance=" + System.identityHashCode(this));
        }
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        XAResource xaResource = this.getDelegate(false);
        if (ActiveMQXARecoveryLogger.LOGGER.isDebugEnabled()) {
            ActiveMQXARecoveryLogger.LOGGER.debug("looking for recover at " + xaResource + " configuration " + Arrays.toString(this.xaRecoveryConfigs));
        }
        try {
            Object[] xids = xaResource.recover(flag);
            if (ActiveMQXARecoveryLogger.LOGGER.isDebugEnabled() && xids != null && xids.length > 0) {
                ActiveMQXARecoveryLogger.LOGGER.debug("Recovering these following IDs " + Arrays.toString(xids) + " at " + this);
            }
            return xids;
        }
        catch (XAException e) {
            ActiveMQXARecoveryLogger.LOGGER.xaRecoverError(e);
            throw this.check(e);
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        XAResource xaResource = this.getDelegate(true);
        if (ActiveMQXARecoveryLogger.LOGGER.isDebugEnabled()) {
            ActiveMQXARecoveryLogger.LOGGER.debug("Commit " + xaResource + " xid " + " onePhase=" + onePhase);
        }
        try {
            xaResource.commit(xid, onePhase);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        XAResource xaResource = this.getDelegate(true);
        if (ActiveMQXARecoveryLogger.LOGGER.isDebugEnabled()) {
            ActiveMQXARecoveryLogger.LOGGER.debug("Rollback " + xaResource + " xid ");
        }
        try {
            xaResource.rollback(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        XAResource xaResource = this.getDelegate(false);
        if (ActiveMQXARecoveryLogger.LOGGER.isDebugEnabled()) {
            ActiveMQXARecoveryLogger.LOGGER.debug("Forget " + xaResource + " xid ");
        }
        try {
            xaResource.forget(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public boolean isSameRM(XAResource xaRes) throws XAException {
        if (xaRes instanceof ActiveMQXAResourceWrapper) {
            xaRes = ((ActiveMQXAResourceWrapper)xaRes).getDelegate(false);
        }
        XAResource xaResource = this.getDelegate(false);
        try {
            return xaResource.isSameRM(xaRes);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        XAResource xaResource = this.getDelegate(true);
        if (ActiveMQXARecoveryLogger.LOGGER.isDebugEnabled()) {
            ActiveMQXARecoveryLogger.LOGGER.debug("prepare " + xaResource + " xid ");
        }
        try {
            return xaResource.prepare(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        XAResource xaResource = this.getDelegate(false);
        if (ActiveMQXARecoveryLogger.LOGGER.isDebugEnabled()) {
            ActiveMQXARecoveryLogger.LOGGER.debug("start " + xaResource + " xid ");
        }
        try {
            xaResource.start(xid, flags);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        XAResource xaResource = this.getDelegate(false);
        if (ActiveMQXARecoveryLogger.LOGGER.isDebugEnabled()) {
            ActiveMQXARecoveryLogger.LOGGER.debug("end " + xaResource + " xid ");
        }
        try {
            xaResource.end(xid, flags);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        XAResource xaResource = this.getDelegate(false);
        if (ActiveMQXARecoveryLogger.LOGGER.isDebugEnabled()) {
            ActiveMQXARecoveryLogger.LOGGER.debug("getTransactionTimeout " + xaResource + " xid ");
        }
        try {
            return xaResource.getTransactionTimeout();
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        XAResource xaResource = this.getDelegate(false);
        if (ActiveMQXARecoveryLogger.LOGGER.isDebugEnabled()) {
            ActiveMQXARecoveryLogger.LOGGER.debug("setTransactionTimeout " + xaResource + " xid ");
        }
        try {
            return xaResource.setTransactionTimeout(seconds);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public void connectionFailed(ActiveMQException me, boolean failedOver) {
        if (me.getType() == ActiveMQExceptionType.DISCONNECTED) {
            if (ActiveMQXARecoveryLogger.LOGGER.isDebugEnabled()) {
                ActiveMQXARecoveryLogger.LOGGER.debug("being disconnected for server shutdown", (Throwable)me);
            }
        } else {
            ActiveMQXARecoveryLogger.LOGGER.xaRecoverConnectionError((Exception)me, this.csf);
        }
        this.close();
    }

    public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
        this.connectionFailed(me, failedOver);
    }

    public void beforeReconnect(ActiveMQException me) {
    }

    private XAResource getDelegate(boolean retry) throws XAException {
        XAResource result = null;
        Exception error = null;
        try {
            result = this.connect();
        }
        catch (Exception e) {
            error = e;
        }
        if (result == null) {
            if (retry) {
                XAException xae = new XAException("Connection unavailable for xa recovery");
                xae.errorCode = 4;
                if (error != null) {
                    xae.initCause(error);
                }
                if (ActiveMQXARecoveryLogger.LOGGER.isDebugEnabled()) {
                    ActiveMQXARecoveryLogger.LOGGER.debug("Cannot get connectionFactory XAResource", xae);
                }
                throw xae;
            }
            XAException xae = new XAException("Error trying to connect to any providers for xa recovery");
            xae.errorCode = -7;
            if (error != null) {
                xae.initCause(error);
            }
            if (ActiveMQXARecoveryLogger.LOGGER.isDebugEnabled()) {
                ActiveMQXARecoveryLogger.LOGGER.debug("Cannot get connectionFactory XAResource", xae);
            }
            throw xae;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XAResource connect() throws Exception {
        XARecoveryConfig[] xARecoveryConfigArray = lock;
        synchronized (lock) {
            if (this.delegate != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.delegate;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (XARecoveryConfig xaRecoveryConfig : this.xaRecoveryConfigs) {
                if (xaRecoveryConfig == null) continue;
                if (ActiveMQXARecoveryLogger.LOGGER.isDebugEnabled()) {
                    ActiveMQXARecoveryLogger.LOGGER.debug("Trying to connect recovery on " + xaRecoveryConfig + " of " + Arrays.toString(this.xaRecoveryConfigs));
                }
                ClientSession cs = null;
                try {
                    this.serverLocator = xaRecoveryConfig.getDiscoveryConfiguration() != null ? ActiveMQClient.createServerLocator((boolean)false, (DiscoveryGroupConfiguration)xaRecoveryConfig.getDiscoveryConfiguration()) : ActiveMQClient.createServerLocator((boolean)false, (TransportConfiguration[])xaRecoveryConfig.getTransportConfig());
                    this.serverLocator.disableFinalizeCheck();
                    this.csf = this.serverLocator.createSessionFactory();
                    cs = xaRecoveryConfig.getUsername() == null ? this.csf.createSession(true, false, false) : this.csf.createSession(xaRecoveryConfig.getUsername(), xaRecoveryConfig.getPassword(), true, false, false, false, 1);
                }
                catch (Throwable e) {
                    ActiveMQXARecoveryLogger.LOGGER.xaRecoverAutoConnectionError(e, xaRecoveryConfig);
                    if (ActiveMQXARecoveryLogger.LOGGER.isDebugEnabled()) {
                        ActiveMQXARecoveryLogger.LOGGER.debug(e.getMessage(), e);
                    }
                    try {
                        if (cs != null) {
                            cs.close();
                        }
                        if (this.serverLocator == null) continue;
                        this.serverLocator.close();
                    }
                    catch (Throwable ignored) {
                        if (!ActiveMQXARecoveryLogger.LOGGER.isTraceEnabled()) continue;
                        ActiveMQXARecoveryLogger.LOGGER.trace(e.getMessage(), ignored);
                    }
                    continue;
                }
                cs.addFailureListener((SessionFailureListener)this);
                Object object = lock;
                synchronized (object) {
                    this.delegate = cs;
                }
                return this.delegate;
            }
            ActiveMQXARecoveryLogger.LOGGER.recoveryConnectFailed(Arrays.toString(this.xaRecoveryConfigs));
            throw new ActiveMQNotConnectedException();
        }
    }

    public String toString() {
        return "ActiveMQXAResourceWrapper [serverLocator=" + this.serverLocator + ", csf=" + this.csf + ", delegate=" + this.delegate + ", xaRecoveryConfigs=" + Arrays.toString(this.xaRecoveryConfigs) + ", instance=" + System.identityHashCode(this) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ServerLocator oldServerLocator = null;
        ClientSessionFactory oldCSF = null;
        ClientSession oldDelegate = null;
        Object object = lock;
        synchronized (object) {
            oldCSF = this.csf;
            this.csf = null;
            oldDelegate = this.delegate;
            this.delegate = null;
            oldServerLocator = this.serverLocator;
            this.serverLocator = null;
        }
        if (oldDelegate != null) {
            try {
                oldDelegate.close();
            }
            catch (Throwable ignorable) {
                ActiveMQXARecoveryLogger.LOGGER.debug(ignorable.getMessage(), ignorable);
            }
        }
        if (oldCSF != null) {
            try {
                oldCSF.close();
            }
            catch (Throwable ignorable) {
                ActiveMQXARecoveryLogger.LOGGER.debug(ignorable.getMessage(), ignorable);
            }
        }
        if (oldServerLocator != null) {
            try {
                oldServerLocator.close();
            }
            catch (Throwable ignorable) {
                ActiveMQXARecoveryLogger.LOGGER.debug(ignorable.getMessage(), ignorable);
            }
        }
    }

    protected XAException check(XAException e) throws XAException {
        ActiveMQXARecoveryLogger.LOGGER.xaRecoveryError(e);
        this.close();
        throw e;
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

