/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalEventLoopGroup;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.protocol.ProtocolHandler;
import org.apache.activemq.artemis.core.remoting.impl.AbstractAcceptor;
import org.apache.activemq.artemis.core.remoting.impl.netty.ActiveMQChannelHandler;
import org.apache.activemq.artemis.core.remoting.impl.netty.ConnectionCreator;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyServerConnection;
import org.apache.activemq.artemis.core.remoting.impl.netty.TransportConstants;
import org.apache.activemq.artemis.core.remoting.impl.ssl.SSLSupport;
import org.apache.activemq.artemis.core.security.ActiveMQPrincipal;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationService;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ServerConnectionLifeCycleListener;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.apache.activemq.artemis.utils.TypedProperties;
import org.jboss.logging.Logger;

public class NettyAcceptor
extends AbstractAcceptor {
    private final String protocolsString;
    private final String name;
    private final ClusterConnection clusterConnection;
    private Class<? extends ServerChannel> channelClazz;
    private EventLoopGroup eventLoopGroup;
    private volatile ChannelGroup serverChannelGroup;
    private volatile ChannelGroup channelGroup;
    private ServerBootstrap bootstrap;
    private final BufferHandler handler;
    private final ServerConnectionLifeCycleListener listener;
    private final boolean sslEnabled;
    private final boolean useInvm;
    private final ProtocolHandler protocolHandler;
    private final String host;
    private final int port;
    private final String keyStoreProvider;
    private String keyStorePath;
    private final String keyStorePassword;
    private final String trustStoreProvider;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final String enabledCipherSuites;
    private final String enabledProtocols;
    private final boolean needClientAuth;
    private final boolean verifyHost;
    private final boolean tcpNoDelay;
    private final int backlog;
    private final int tcpSendBufferSize;
    private final int tcpReceiveBufferSize;
    private final int nioRemotingThreads;
    private final ConcurrentMap<Object, NettyServerConnection> connections = new ConcurrentHashMap<Object, NettyServerConnection>();
    private final Map<String, Object> configuration;
    private final ScheduledExecutorService scheduledThreadPool;
    private NotificationService notificationService;
    private boolean paused;
    private BatchFlusher flusher;
    private ScheduledFuture<?> batchFlusherFuture;
    private final long batchDelay;
    private final boolean directDeliver;
    private final boolean httpUpgradeEnabled;
    private final long connectionsAllowed;
    private Map<String, Object> extraConfigs;
    private static final Logger logger;

    public NettyAcceptor(String name, ClusterConnection clusterConnection, Map<String, Object> configuration, BufferHandler handler, ServerConnectionLifeCycleListener listener, ScheduledExecutorService scheduledThreadPool, Map<String, ProtocolManager> protocolMap) {
        super(protocolMap);
        this.name = name;
        this.clusterConnection = clusterConnection;
        this.configuration = configuration;
        this.handler = handler;
        this.listener = listener;
        this.sslEnabled = ConfigurationHelper.getBooleanProperty((String)"sslEnabled", (boolean)false, configuration);
        this.nioRemotingThreads = ConfigurationHelper.getIntProperty((String)"nioRemotingThreads", (int)-1, configuration);
        this.backlog = ConfigurationHelper.getIntProperty((String)"backlog", (int)-1, configuration);
        this.useInvm = ConfigurationHelper.getBooleanProperty((String)"useInvm", (boolean)false, configuration);
        this.protocolHandler = new ProtocolHandler(protocolMap, this, configuration, scheduledThreadPool);
        this.protocolsString = NettyAcceptor.getProtocols(protocolMap);
        this.host = ConfigurationHelper.getStringProperty((String)"host", (String)"localhost", configuration);
        this.port = ConfigurationHelper.getIntProperty((String)"port", (int)61616, configuration);
        if (this.sslEnabled) {
            this.keyStoreProvider = ConfigurationHelper.getStringProperty((String)"keyStoreProvider", (String)"JKS", configuration);
            this.keyStorePath = ConfigurationHelper.getStringProperty((String)"keyStorePath", (String)TransportConstants.DEFAULT_KEYSTORE_PATH, configuration);
            this.keyStorePassword = ConfigurationHelper.getPasswordProperty((String)"keyStorePassword", (String)TransportConstants.DEFAULT_KEYSTORE_PASSWORD, configuration, (String)ActiveMQDefaultConfiguration.getPropMaskPassword(), (String)ActiveMQDefaultConfiguration.getPropPasswordCodec());
            this.trustStoreProvider = ConfigurationHelper.getStringProperty((String)"trustStoreProvider", (String)"JKS", configuration);
            this.trustStorePath = ConfigurationHelper.getStringProperty((String)"trustStorePath", (String)TransportConstants.DEFAULT_TRUSTSTORE_PATH, configuration);
            this.trustStorePassword = ConfigurationHelper.getPasswordProperty((String)"trustStorePassword", (String)TransportConstants.DEFAULT_TRUSTSTORE_PASSWORD, configuration, (String)ActiveMQDefaultConfiguration.getPropMaskPassword(), (String)ActiveMQDefaultConfiguration.getPropPasswordCodec());
            this.enabledCipherSuites = ConfigurationHelper.getStringProperty((String)"enabledCipherSuites", (String)TransportConstants.DEFAULT_ENABLED_CIPHER_SUITES, configuration);
            this.enabledProtocols = ConfigurationHelper.getStringProperty((String)"enabledProtocols", (String)TransportConstants.DEFAULT_ENABLED_PROTOCOLS, configuration);
            this.needClientAuth = ConfigurationHelper.getBooleanProperty((String)"needClientAuth", (boolean)false, configuration);
            this.verifyHost = ConfigurationHelper.getBooleanProperty((String)"verifyHost", (boolean)false, configuration);
        } else {
            this.keyStoreProvider = "JKS";
            this.keyStorePath = TransportConstants.DEFAULT_KEYSTORE_PATH;
            this.keyStorePassword = TransportConstants.DEFAULT_KEYSTORE_PASSWORD;
            this.trustStoreProvider = "JKS";
            this.trustStorePath = TransportConstants.DEFAULT_TRUSTSTORE_PATH;
            this.trustStorePassword = TransportConstants.DEFAULT_TRUSTSTORE_PASSWORD;
            this.enabledCipherSuites = TransportConstants.DEFAULT_ENABLED_CIPHER_SUITES;
            this.enabledProtocols = TransportConstants.DEFAULT_ENABLED_PROTOCOLS;
            this.needClientAuth = false;
            this.verifyHost = false;
        }
        this.tcpNoDelay = ConfigurationHelper.getBooleanProperty((String)"tcpNoDelay", (boolean)true, configuration);
        this.tcpSendBufferSize = ConfigurationHelper.getIntProperty((String)"tcpSendBufferSize", (int)32768, configuration);
        this.tcpReceiveBufferSize = ConfigurationHelper.getIntProperty((String)"tcpReceiveBufferSize", (int)32768, configuration);
        this.scheduledThreadPool = scheduledThreadPool;
        this.batchDelay = ConfigurationHelper.getLongProperty((String)"batchDelay", (long)0L, configuration);
        this.directDeliver = ConfigurationHelper.getBooleanProperty((String)"directDeliver", (boolean)true, configuration);
        this.httpUpgradeEnabled = ConfigurationHelper.getBooleanProperty((String)"httpUpgradeEnabled", (boolean)false, configuration);
        this.connectionsAllowed = ConfigurationHelper.getLongProperty((String)"connectionsAllowed", (long)-1L, configuration);
    }

    public synchronized void start() throws Exception {
        if (this.channelClazz != null) {
            return;
        }
        if (this.useInvm) {
            this.channelClazz = LocalServerChannel.class;
            this.eventLoopGroup = new LocalEventLoopGroup();
        } else {
            int threadsToUse = this.nioRemotingThreads == -1 ? Runtime.getRuntime().availableProcessors() * 3 : this.nioRemotingThreads;
            this.channelClazz = NioServerSocketChannel.class;
            this.eventLoopGroup = new NioEventLoopGroup(threadsToUse, (ThreadFactory)AccessController.doPrivileged(new PrivilegedAction<ActiveMQThreadFactory>(){

                @Override
                public ActiveMQThreadFactory run() {
                    return new ActiveMQThreadFactory("activemq-netty-threads", true, ClientSessionFactoryImpl.class.getClassLoader());
                }
            }));
        }
        this.bootstrap = new ServerBootstrap();
        this.bootstrap.group(this.eventLoopGroup);
        this.bootstrap.channel(this.channelClazz);
        ChannelInitializer<Channel> factory = new ChannelInitializer<Channel>(){

            public void initChannel(Channel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                if (NettyAcceptor.this.sslEnabled) {
                    pipeline.addLast("ssl", (ChannelHandler)NettyAcceptor.this.getSslHandler());
                    pipeline.addLast("sslHandshakeExceptionHandler", (ChannelHandler)new SslHandshakeExceptionHandler());
                }
                pipeline.addLast(new ChannelHandler[]{NettyAcceptor.this.protocolHandler.getProtocolDecoder()});
            }
        };
        this.bootstrap.childHandler((ChannelHandler)factory);
        this.bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)this.tcpNoDelay);
        if (this.tcpReceiveBufferSize != -1) {
            this.bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.tcpReceiveBufferSize);
        }
        if (this.tcpSendBufferSize != -1) {
            this.bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.tcpSendBufferSize);
        }
        if (this.backlog != -1) {
            this.bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.backlog);
        }
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
        this.bootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)true);
        this.bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.channelGroup = new DefaultChannelGroup("activemq-accepted-channels", (EventExecutor)GlobalEventExecutor.INSTANCE);
        this.serverChannelGroup = new DefaultChannelGroup("activemq-acceptor-channels", (EventExecutor)GlobalEventExecutor.INSTANCE);
        if (!this.httpUpgradeEnabled) {
            this.startServerChannels();
            this.paused = false;
            if (this.notificationService != null) {
                TypedProperties props = new TypedProperties();
                props.putSimpleStringProperty(new SimpleString("factory"), new SimpleString(NettyAcceptorFactory.class.getName()));
                props.putSimpleStringProperty(new SimpleString("host"), new SimpleString(this.host));
                props.putIntProperty(new SimpleString("port"), this.port);
                Notification notification = new Notification(null, (NotificationType)CoreNotificationType.ACCEPTOR_STARTED, props);
                this.notificationService.sendNotification(notification);
            }
            if (this.batchDelay > 0L) {
                this.flusher = new BatchFlusher();
                this.batchFlusherFuture = this.scheduledThreadPool.scheduleWithFixedDelay(this.flusher, this.batchDelay, this.batchDelay, TimeUnit.MILLISECONDS);
            }
            ActiveMQServerLogger.LOGGER.startedAcceptor(this.host, this.port, this.protocolsString);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public void transfer(Channel channel) {
        if (this.paused || this.eventLoopGroup == null) {
            throw ActiveMQMessageBundle.BUNDLE.acceptorUnavailable();
        }
        channel.pipeline().addLast(new ChannelHandler[]{this.protocolHandler.getProtocolDecoder()});
    }

    @Override
    public void reload() {
        this.serverChannelGroup.disconnect();
        this.serverChannelGroup.clear();
        this.startServerChannels();
    }

    public synchronized SslHandler getSslHandler() throws Exception {
        SSLContext context;
        try {
            if (this.keyStorePath == null && "JKS".equals(this.keyStoreProvider)) {
                throw new IllegalArgumentException("If \"sslEnabled\" is true then \"keyStorePath\" must be non-null unless an alternative \"keyStoreProvider\" has been specified.");
            }
            context = SSLSupport.createContext((String)this.keyStoreProvider, (String)this.keyStorePath, (String)this.keyStorePassword, (String)this.trustStoreProvider, (String)this.trustStorePath, (String)this.trustStorePassword);
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException("Unable to create NettyAcceptor for " + this.host + ":" + this.port);
            ise.initCause(e);
            throw ise;
        }
        SSLEngine engine = this.verifyHost ? context.createSSLEngine(this.host, this.port) : context.createSSLEngine();
        engine.setUseClientMode(false);
        if (this.needClientAuth) {
            engine.setNeedClientAuth(true);
        }
        String[] originalProtocols = engine.getEnabledProtocols();
        if (this.enabledCipherSuites != null) {
            try {
                engine.setEnabledCipherSuites(SSLSupport.parseCommaSeparatedListIntoArray((String)this.enabledCipherSuites));
            }
            catch (IllegalArgumentException e) {
                ActiveMQServerLogger.LOGGER.invalidCipherSuite(SSLSupport.parseArrayIntoCommandSeparatedList((String[])engine.getSupportedCipherSuites()));
                throw e;
            }
        }
        if (this.enabledProtocols != null) {
            try {
                engine.setEnabledProtocols(SSLSupport.parseCommaSeparatedListIntoArray((String)this.enabledProtocols));
            }
            catch (IllegalArgumentException e) {
                ActiveMQServerLogger.LOGGER.invalidProtocol(SSLSupport.parseArrayIntoCommandSeparatedList((String[])engine.getSupportedProtocols()));
                throw e;
            }
        } else {
            engine.setEnabledProtocols(originalProtocols);
        }
        String[] protocols = engine.getEnabledProtocols();
        HashSet<String> set = new HashSet<String>();
        for (String s : protocols) {
            if (s.equalsIgnoreCase("SSLv3") || s.equals("SSLv2Hello")) {
                ActiveMQServerLogger.LOGGER.disallowedProtocol(s, this.name);
                continue;
            }
            set.add(s);
        }
        engine.setEnabledProtocols(set.toArray(new String[set.size()]));
        if (this.verifyHost) {
            SSLParameters sslParameters = engine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            engine.setSSLParameters(sslParameters);
        }
        return new SslHandler(engine);
    }

    private void startServerChannels() {
        String[] hosts;
        for (String h : hosts = TransportConfiguration.splitHosts((String)this.host)) {
            Object address = this.useInvm ? new LocalAddress(h) : new InetSocketAddress(h, this.port);
            Channel serverChannel = this.bootstrap.bind((SocketAddress)address).syncUninterruptibly().channel();
            this.serverChannelGroup.add((Object)serverChannel);
        }
    }

    @Override
    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public synchronized void stop() {
        Object future;
        if (this.channelClazz == null) {
            return;
        }
        if (this.protocolHandler != null) {
            this.protocolHandler.close();
        }
        if (this.batchFlusherFuture != null) {
            this.batchFlusherFuture.cancel(false);
            this.flusher.cancel();
            this.flusher = null;
            this.batchFlusherFuture = null;
        }
        if (this.serverChannelGroup != null) {
            this.serverChannelGroup.close().awaitUninterruptibly();
        }
        if (this.channelGroup != null && !(future = this.channelGroup.close().awaitUninterruptibly()).isSuccess()) {
            ActiveMQServerLogger.LOGGER.nettyChannelGroupError();
            for (Channel channel : future.group()) {
                if (!channel.isActive()) continue;
                ActiveMQServerLogger.LOGGER.nettyChannelStillOpen(channel, channel.remoteAddress());
            }
        }
        this.eventLoopGroup.shutdownGracefully(100L, 3000L, TimeUnit.MILLISECONDS);
        this.eventLoopGroup = null;
        this.channelClazz = null;
        for (Connection connection : this.connections.values()) {
            this.listener.connectionDestroyed(connection.getID());
        }
        this.connections.clear();
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("factory"), new SimpleString(NettyAcceptorFactory.class.getName()));
            props.putSimpleStringProperty(new SimpleString("host"), new SimpleString(this.host));
            props.putIntProperty(new SimpleString("port"), this.port);
            Notification notification = new Notification(null, (NotificationType)CoreNotificationType.ACCEPTOR_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                logger.warn("failed to send notification", (Object)e.getMessage(), (Throwable)e);
            }
        }
        this.paused = false;
    }

    public boolean isStarted() {
        return this.channelClazz != null;
    }

    @Override
    public synchronized void pause() {
        ChannelGroupFuture future;
        if (this.paused) {
            return;
        }
        if (this.channelClazz == null) {
            return;
        }
        if (this.serverChannelGroup != null && !(future = this.serverChannelGroup.close().awaitUninterruptibly()).isSuccess()) {
            ActiveMQServerLogger.LOGGER.nettyChannelGroupBindError();
            for (Channel channel : future.group()) {
                if (!channel.isActive()) continue;
                ActiveMQServerLogger.LOGGER.nettyChannelStillBound(channel, channel.remoteAddress());
            }
        }
        this.paused = true;
    }

    @Override
    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @Override
    public void setDefaultActiveMQPrincipal(ActiveMQPrincipal defaultActiveMQPrincipal) {
        throw new IllegalStateException("unsecure connections not allowed");
    }

    @Override
    public boolean isUnsecurable() {
        return false;
    }

    @Override
    public ClusterConnection getClusterConnection() {
        return this.clusterConnection;
    }

    public ConnectionCreator createConnectionCreator() {
        return new ActiveMQServerChannelHandler(this.channelGroup, this.handler, new Listener());
    }

    private static String getProtocols(Map<String, ProtocolManager> protocolManager) {
        StringBuilder sb = new StringBuilder();
        if (protocolManager != null) {
            Set<String> strings = protocolManager.keySet();
            for (String string : strings) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(string);
            }
        }
        return sb.toString();
    }

    static {
        if (System.getProperty("io.netty.leakDetectionLevel") == null && System.getProperty("io.netty.leakDetection.level") == null) {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
        }
        logger = Logger.getLogger(NettyAcceptor.class);
    }

    private class SslHandshakeExceptionHandler
    implements ChannelHandler {
        private SslHandshakeExceptionHandler() {
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (cause.getMessage() != null && cause.getMessage().startsWith(SSLHandshakeException.class.getName())) {
                Throwable rootCause = this.getRootCause(cause);
                String errorMessage = rootCause.getClass().getName() + ": " + rootCause.getMessage();
                ActiveMQServerLogger.LOGGER.sslHandshakeFailed(ctx.channel().remoteAddress().toString(), errorMessage);
                if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                    ActiveMQServerLogger.LOGGER.debug("SSL handshake failed", cause);
                }
            }
        }

        private Throwable getRootCause(Throwable throwable) {
            ArrayList<Throwable> list = new ArrayList<Throwable>();
            while (throwable != null && !list.contains(throwable)) {
                list.add(throwable);
                throwable = throwable.getCause();
            }
            return list.size() < 2 ? throwable : (Throwable)list.get(list.size() - 1);
        }
    }

    private class BatchFlusher
    implements Runnable {
        private boolean cancelled;

        private BatchFlusher() {
        }

        @Override
        public synchronized void run() {
            if (!this.cancelled) {
                for (Connection connection : NettyAcceptor.this.connections.values()) {
                    connection.checkFlushBatchBuffer();
                }
            }
        }

        public synchronized void cancel() {
            this.cancelled = true;
        }
    }

    private class Listener
    implements ServerConnectionLifeCycleListener {
        private Listener() {
        }

        public void connectionCreated(ActiveMQComponent component, Connection connection, ProtocolManager protocol) {
            if (NettyAcceptor.this.connections.putIfAbsent(connection.getID(), (NettyServerConnection)connection) != null) {
                throw ActiveMQMessageBundle.BUNDLE.connectionExists(connection.getID());
            }
            NettyAcceptor.this.listener.connectionCreated(component, connection, protocol);
        }

        public void connectionDestroyed(Object connectionID) {
            if (NettyAcceptor.this.connections.remove(connectionID) != null) {
                NettyAcceptor.this.listener.connectionDestroyed(connectionID);
            }
        }

        public void connectionException(final Object connectionID, final ActiveMQException me) {
            new Thread(){

                @Override
                public void run() {
                    NettyAcceptor.this.listener.connectionException(connectionID, me);
                }
            }.start();
        }

        public void connectionReadyForWrites(Object connectionID, boolean ready) {
            NettyServerConnection conn = (NettyServerConnection)((Object)NettyAcceptor.this.connections.get(connectionID));
            if (conn != null) {
                conn.fireReady(ready);
            }
            NettyAcceptor.this.listener.connectionReadyForWrites(connectionID, ready);
        }
    }

    private final class ActiveMQServerChannelHandler
    extends ActiveMQChannelHandler
    implements ConnectionCreator {
        ActiveMQServerChannelHandler(ChannelGroup group, BufferHandler handler, ServerConnectionLifeCycleListener listener) {
            super(group, handler, (BaseConnectionLifeCycleListener)listener);
        }

        @Override
        public NettyServerConnection createConnection(ChannelHandlerContext ctx, String protocol, boolean httpEnabled) throws Exception {
            if (NettyAcceptor.this.connectionsAllowed == -1L || (long)NettyAcceptor.this.connections.size() < NettyAcceptor.this.connectionsAllowed) {
                super.channelActive(ctx);
                Listener connectionListener = new Listener();
                NettyServerConnection nc = new NettyServerConnection(NettyAcceptor.this.configuration, ctx.channel(), connectionListener, !httpEnabled && NettyAcceptor.this.batchDelay > 0L, NettyAcceptor.this.directDeliver);
                connectionListener.connectionCreated((ActiveMQComponent)NettyAcceptor.this, (Connection)nc, NettyAcceptor.this.protocolHandler.getProtocol(protocol));
                SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
                if (sslHandler != null) {
                    sslHandler.handshakeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

                        public void operationComplete(Future<Channel> future) throws Exception {
                            if (future.isSuccess()) {
                                ActiveMQServerChannelHandler.this.active = true;
                            } else {
                                ((Channel)future.getNow()).close();
                            }
                        }
                    });
                } else {
                    this.active = true;
                }
                return nc;
            }
            ActiveMQServerLogger.LOGGER.connectionLimitReached(NettyAcceptor.this.connectionsAllowed, ctx.channel().remoteAddress().toString());
            ctx.channel().close();
            return null;
        }
    }
}

