/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.protocol.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.activemq.artemis.utils.StringUtil;

public class WebSocketServerHandler
extends SimpleChannelInboundHandler<Object> {
    private static final String WEBSOCKET_PATH = "/stomp";
    private HttpRequest httpRequest;
    private WebSocketServerHandshaker handshaker;
    private List<String> supportedProtocols;
    private static final BinaryWebSocketEncoder BINARY_WEBSOCKET_ENCODER = new BinaryWebSocketEncoder();

    public WebSocketServerHandler(List<String> supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        WebSocketFrame frame;
        boolean handle;
        if (msg instanceof FullHttpRequest) {
            this.handleHttpRequest(ctx, (FullHttpRequest)msg);
        } else if (msg instanceof WebSocketFrame && (handle = this.handleWebSocketFrame(ctx, frame = (WebSocketFrame)msg))) {
            ctx.fireChannelRead((Object)frame.content().retain());
        }
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req) throws Exception {
        if (req.getMethod() != HttpMethod.GET) {
            this.sendHttpResponse(ctx, (HttpRequest)req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
            return;
        }
        String supportedProtocolsCSV = StringUtil.joinStringList(this.supportedProtocols, (String)",");
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketLocation((HttpRequest)req), supportedProtocolsCSV, false);
        this.httpRequest = req;
        this.handshaker = wsFactory.newHandshaker((HttpRequest)req);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            ChannelFuture handshake = this.handshaker.handshake(ctx.channel(), req);
            handshake.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        future.channel().pipeline().addAfter("wsencoder", "binary-websocket-encoder", (ChannelHandler)BINARY_WEBSOCKET_ENCODER);
                    } else {
                        future.channel().pipeline().fireExceptionCaught(future.cause());
                    }
                }
            });
        }
    }

    private boolean handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), ((CloseWebSocketFrame)frame).retain());
            return false;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.writeAndFlush((Object)new PongWebSocketFrame(frame.content().retain()));
            return false;
        }
        if (!(frame instanceof TextWebSocketFrame) && !(frame instanceof BinaryWebSocketFrame)) {
            throw new UnsupportedOperationException(String.format("%s frame types not supported", frame.getClass().getName()));
        }
        return true;
    }

    private void sendHttpResponse(ChannelHandlerContext ctx, HttpRequest req, FullHttpResponse res) {
        if (res.getStatus().code() != 200) {
            res.content().writeBytes(res.getStatus().toString().getBytes(StandardCharsets.UTF_8));
            HttpHeaders.setContentLength((HttpMessage)res, (long)res.content().readableBytes());
        }
        ChannelFuture f = ctx.writeAndFlush((Object)res);
        if (!HttpHeaders.isKeepAlive((HttpMessage)req) || res.getStatus().code() != 200) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }

    private String getWebSocketLocation(HttpRequest req) {
        return "ws://" + req.headers().get("Host") + WEBSOCKET_PATH;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    @ChannelHandler.Sharable
    private static final class BinaryWebSocketEncoder
    extends ChannelOutboundHandlerAdapter {
        private BinaryWebSocketEncoder() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (msg instanceof ByteBuf) {
                msg = new BinaryWebSocketFrame((ByteBuf)msg);
            }
            ctx.write(msg, promise);
        }
    }
}

