/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.embedded;

import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;

public class EmbeddedActiveMQ {
    protected ActiveMQSecurityManager securityManager;
    protected String configResourcePath = null;
    protected Configuration configuration;
    protected ActiveMQServer activeMQServer;
    protected MBeanServer mbeanServer;

    public EmbeddedActiveMQ setConfigResourcePath(String filename) {
        this.configResourcePath = filename;
        return this;
    }

    public EmbeddedActiveMQ setSecurityManager(ActiveMQSecurityManager securityManager) {
        this.securityManager = securityManager;
        return this;
    }

    public boolean waitClusterForming(long timeWait, TimeUnit unit, int iterations, int servers) throws Exception {
        if (this.activeMQServer.getClusterManager().getClusterConnections() == null || this.activeMQServer.getClusterManager().getClusterConnections().size() == 0) {
            return servers == 0;
        }
        for (int i = 0; i < iterations; ++i) {
            for (ClusterConnection connection : this.activeMQServer.getClusterManager().getClusterConnections()) {
                if (connection.getTopology().getMembers().size() == servers) {
                    return true;
                }
                Thread.sleep(unit.toMillis(timeWait));
            }
        }
        return false;
    }

    public EmbeddedActiveMQ setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
        return this;
    }

    public EmbeddedActiveMQ setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ActiveMQServer getActiveMQServer() {
        return this.activeMQServer;
    }

    public EmbeddedActiveMQ start() throws Exception {
        this.initStart();
        this.activeMQServer.start();
        return this;
    }

    protected void initStart() throws Exception {
        if (this.configuration == null) {
            if (this.configResourcePath == null) {
                this.configResourcePath = "broker.xml";
            }
            FileDeploymentManager deploymentManager = new FileDeploymentManager(this.configResourcePath);
            FileConfiguration config = new FileConfiguration();
            deploymentManager.addDeployable(config);
            deploymentManager.readConfiguration();
            this.configuration = config;
        }
        if (this.securityManager == null) {
            this.securityManager = new ActiveMQJAASSecurityManager();
        }
        this.activeMQServer = this.mbeanServer == null ? new ActiveMQServerImpl(this.configuration, this.securityManager) : new ActiveMQServerImpl(this.configuration, this.mbeanServer, this.securityManager);
    }

    public EmbeddedActiveMQ stop() throws Exception {
        this.activeMQServer.stop();
        return this;
    }
}

