/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.transaction.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.RefsOperation;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;

public class TransactionImpl
implements Transaction {
    private static final boolean isTrace = ActiveMQServerLogger.LOGGER.isTraceEnabled();
    private List<TransactionOperation> operations;
    private static final int INITIAL_NUM_PROPERTIES = 10;
    private Object[] properties = new Object[10];
    protected final StorageManager storageManager;
    private final Xid xid;
    private final long id;
    private volatile Transaction.State state = Transaction.State.ACTIVE;
    private ActiveMQException exception;
    private final Object timeoutLock = new Object();
    private final long createTime;
    private volatile boolean containsPersistent;
    private int timeoutSeconds = -1;

    public TransactionImpl(StorageManager storageManager, int timeoutSeconds) {
        this.storageManager = storageManager;
        this.xid = null;
        this.id = storageManager.generateID();
        this.createTime = System.currentTimeMillis();
        this.timeoutSeconds = timeoutSeconds;
    }

    public TransactionImpl(StorageManager storageManager) {
        this.storageManager = storageManager;
        this.xid = null;
        this.id = storageManager.generateID();
        this.createTime = System.currentTimeMillis();
    }

    public TransactionImpl(Xid xid, StorageManager storageManager, int timeoutSeconds) {
        this.storageManager = storageManager;
        this.xid = xid;
        this.id = storageManager.generateID();
        this.createTime = System.currentTimeMillis();
        this.timeoutSeconds = timeoutSeconds;
    }

    public TransactionImpl(long id, Xid xid, StorageManager storageManager) {
        this.storageManager = storageManager;
        this.xid = xid;
        this.id = id;
        this.createTime = System.currentTimeMillis();
    }

    @Override
    public boolean isEffective() {
        return this.state == Transaction.State.PREPARED || this.state == Transaction.State.COMMITTED || this.state == Transaction.State.ROLLEDBACK;
    }

    @Override
    public void setContainsPersistent() {
        this.containsPersistent = true;
    }

    @Override
    public boolean isContainsPersistent() {
        return this.containsPersistent;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeoutSeconds = timeout;
    }

    @Override
    public RefsOperation createRefsOperation(Queue queue) {
        return new RefsOperation(queue, this.storageManager);
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasTimedOut(long currentTime, int defaultTimeout) {
        Object object = this.timeoutLock;
        synchronized (object) {
            boolean timedout;
            if (this.timeoutSeconds == -1) {
                timedout = this.getState() != Transaction.State.PREPARED && currentTime > this.createTime + (long)(defaultTimeout * 1000);
            } else {
                boolean bl = timedout = this.getState() != Transaction.State.PREPARED && currentTime > this.createTime + (long)(this.timeoutSeconds * 1000);
            }
            if (timedout) {
                this.markAsRollbackOnly(new ActiveMQException("TX Timeout"));
            }
            return timedout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void prepare() throws Exception {
        block13: {
            block14: {
                if (isTrace) {
                    ActiveMQServerLogger.LOGGER.trace("TransactionImpl::prepare::" + this);
                }
                this.storageManager.readLock();
                Object object = this.timeoutLock;
                // MONITORENTER : object
                if (this.isEffective()) {
                    ActiveMQServerLogger.LOGGER.debug("TransactionImpl::prepare::" + this + " is being ignored");
                    // MONITOREXIT : object
                    this.storageManager.readUnLock();
                    return;
                }
                if (this.state != Transaction.State.ROLLBACK_ONLY) break block13;
                if (!isTrace) break block14;
                ActiveMQServerLogger.LOGGER.trace("TransactionImpl::prepare::rollbackonly, rollingback " + this);
            }
            this.internalRollback();
            if (this.exception != null) {
                throw this.exception;
            }
            // MONITOREXIT : object
            this.storageManager.readUnLock();
            return;
        }
        try {
            if (this.state != Transaction.State.ACTIVE) {
                throw new IllegalStateException("Transaction is in invalid state " + (Object)((Object)this.state));
            }
            if (this.xid == null) {
                throw new IllegalStateException("Cannot prepare non XA transaction");
            }
            this.beforePrepare();
            this.storageManager.prepare(this.id, this.xid);
            this.state = Transaction.State.PREPARED;
            this.storageManager.afterCompleteOperations(new IOCallback(){

                public void onError(int errorCode, String errorMessage) {
                    ActiveMQServerLogger.LOGGER.ioErrorOnTX(errorCode, errorMessage);
                }

                public void done() {
                    TransactionImpl.this.afterPrepare();
                }
            });
            // MONITOREXIT : object
            return;
        }
        finally {
            this.storageManager.readUnLock();
        }
    }

    @Override
    public void commit() throws Exception {
        this.commit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(boolean onePhase) throws Exception {
        if (isTrace) {
            ActiveMQServerLogger.LOGGER.trace("TransactionImpl::commit::" + this);
        }
        Object object = this.timeoutLock;
        synchronized (object) {
            if (this.state == Transaction.State.COMMITTED) {
                ActiveMQServerLogger.LOGGER.debug("TransactionImpl::commit::" + this + " is being ignored");
                return;
            }
            if (this.state == Transaction.State.ROLLBACK_ONLY) {
                this.internalRollback();
                if (this.exception != null) {
                    throw this.exception;
                }
                return;
            }
            if (this.xid != null ? onePhase && this.state != Transaction.State.ACTIVE || !onePhase && this.state != Transaction.State.PREPARED : this.state != Transaction.State.ACTIVE) {
                throw new ActiveMQIllegalStateException("Transaction is in invalid state " + (Object)((Object)this.state));
            }
            this.beforeCommit();
            this.doCommit();
            final List<TransactionOperation> operationsToComplete = this.operations;
            this.operations = null;
            this.storageManager.afterCompleteOperations(new IOCallback(){

                public void onError(int errorCode, String errorMessage) {
                    ActiveMQServerLogger.LOGGER.ioErrorOnTX(errorCode, errorMessage);
                }

                public void done() {
                    TransactionImpl.this.afterCommit(operationsToComplete);
                }
            });
        }
    }

    protected void doCommit() throws Exception {
        if (this.containsPersistent || this.xid != null && this.state == Transaction.State.PREPARED) {
            this.storageManager.commit(this.id);
        }
        this.state = Transaction.State.COMMITTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws Exception {
        if (isTrace) {
            ActiveMQServerLogger.LOGGER.trace("TransactionImpl::rollback::" + this);
        }
        Object object = this.timeoutLock;
        synchronized (object) {
            if (this.state == Transaction.State.ROLLEDBACK) {
                ActiveMQServerLogger.LOGGER.debug("TransactionImpl::rollback::" + this + " is being ignored");
                return;
            }
            if (this.xid != null ? this.state != Transaction.State.PREPARED && this.state != Transaction.State.ACTIVE && this.state != Transaction.State.ROLLBACK_ONLY : this.state != Transaction.State.ACTIVE && this.state != Transaction.State.ROLLBACK_ONLY) {
                throw new ActiveMQIllegalStateException("Transaction is in invalid state " + (Object)((Object)this.state));
            }
            this.internalRollback();
        }
    }

    private void internalRollback() throws Exception {
        if (isTrace) {
            ActiveMQServerLogger.LOGGER.trace("TransactionImpl::internalRollback " + this);
        }
        this.beforeRollback();
        try {
            this.doRollback();
            this.state = Transaction.State.ROLLEDBACK;
        }
        catch (IllegalStateException e) {
            ActiveMQServerLogger.LOGGER.warn(e);
        }
        final List<TransactionOperation> operationsToComplete = this.operations;
        this.operations = null;
        this.storageManager.afterCompleteOperations(new IOCallback(){

            public void onError(int errorCode, String errorMessage) {
                ActiveMQServerLogger.LOGGER.ioErrorOnTX(errorCode, errorMessage);
            }

            public void done() {
                TransactionImpl.this.afterRollback(operationsToComplete);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend() {
        Object object = this.timeoutLock;
        synchronized (object) {
            if (this.state != Transaction.State.ACTIVE) {
                throw new IllegalStateException("Can only suspend active transaction");
            }
            this.state = Transaction.State.SUSPENDED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.timeoutLock;
        synchronized (object) {
            if (this.state != Transaction.State.SUSPENDED) {
                throw new IllegalStateException("Can only resume a suspended transaction");
            }
            this.state = Transaction.State.ACTIVE;
        }
    }

    @Override
    public Transaction.State getState() {
        return this.state;
    }

    @Override
    public void setState(Transaction.State state) {
        this.state = state;
    }

    @Override
    public Xid getXid() {
        return this.xid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAsRollbackOnly(ActiveMQException exception) {
        Object object = this.timeoutLock;
        synchronized (object) {
            if (isTrace) {
                ActiveMQServerLogger.LOGGER.trace("TransactionImpl::" + this + " marking rollbackOnly for " + exception.toString() + ", msg=" + exception.getMessage());
            }
            if (this.isEffective()) {
                ActiveMQServerLogger.LOGGER.debug("Trying to mark transaction " + this.id + " xid=" + this.xid + " as rollbackOnly but it was already effective (prepared, committed or rolledback!)");
                return;
            }
            if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                ActiveMQServerLogger.LOGGER.debug("Marking Transaction " + this.id + " as rollback only");
            }
            this.state = Transaction.State.ROLLBACK_ONLY;
            this.exception = exception;
        }
    }

    @Override
    public synchronized void addOperation(TransactionOperation operation) {
        this.checkCreateOperations();
        this.operations.add(operation);
    }

    private int getOperationsCount() {
        this.checkCreateOperations();
        return this.operations.size();
    }

    @Override
    public synchronized List<TransactionOperation> getAllOperations() {
        if (this.operations != null) {
            return new ArrayList<TransactionOperation>(this.operations);
        }
        return new ArrayList<TransactionOperation>();
    }

    @Override
    public void putProperty(int index, Object property) {
        if (index >= this.properties.length) {
            Object[] newProperties = new Object[index];
            System.arraycopy(this.properties, 0, newProperties, 0, this.properties.length);
            this.properties = newProperties;
        }
        this.properties[index] = property;
    }

    @Override
    public Object getProperty(int index) {
        return this.properties[index];
    }

    private void doRollback() throws Exception {
        if (this.containsPersistent || this.xid != null && this.state == Transaction.State.PREPARED) {
            this.storageManager.rollback(this.id);
        }
    }

    private void checkCreateOperations() {
        if (this.operations == null) {
            this.operations = new ArrayList<TransactionOperation>();
        }
    }

    private synchronized void afterCommit(List<TransactionOperation> oeprationsToComplete) {
        if (oeprationsToComplete != null) {
            for (TransactionOperation operation : oeprationsToComplete) {
                operation.afterCommit(this);
            }
            oeprationsToComplete.clear();
        }
    }

    private synchronized void afterRollback(List<TransactionOperation> oeprationsToComplete) {
        if (oeprationsToComplete != null) {
            for (TransactionOperation operation : oeprationsToComplete) {
                operation.afterRollback(this);
            }
            oeprationsToComplete.clear();
        }
    }

    private synchronized void beforeCommit() throws Exception {
        if (this.operations != null) {
            for (TransactionOperation operation : this.operations) {
                operation.beforeCommit(this);
            }
        }
    }

    private synchronized void beforePrepare() throws Exception {
        if (this.operations != null) {
            for (TransactionOperation operation : this.operations) {
                operation.beforePrepare(this);
            }
        }
    }

    private synchronized void beforeRollback() throws Exception {
        if (this.operations != null) {
            for (TransactionOperation operation : this.operations) {
                operation.beforeRollback(this);
            }
        }
    }

    private synchronized void afterPrepare() {
        if (this.operations != null) {
            for (TransactionOperation operation : this.operations) {
                operation.afterPrepare(this);
            }
        }
    }

    public String toString() {
        Date dt = new Date(this.createTime);
        return "TransactionImpl [xid=" + this.xid + ", id=" + this.id + ", xid=" + this.xid + ", state=" + (Object)((Object)this.state) + ", createTime=" + this.createTime + "(" + dt + ")" + ", timeoutSeconds=" + this.timeoutSeconds + ", nr operations = " + this.getOperationsCount() + "]@" + Integer.toHexString(this.hashCode());
    }
}

