/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.utils.IDGenerator;

public final class BatchingIDGenerator
implements IDGenerator {
    private final AtomicLong counter;
    private final long checkpointSize;
    private volatile long nextID;
    private final StorageManager storageManager;
    private List<Long> cleanupRecords = null;

    public BatchingIDGenerator(long start, long checkpointSize, StorageManager storageManager) {
        this.counter = new AtomicLong(start);
        this.nextID = start;
        this.checkpointSize = checkpointSize;
        this.storageManager = storageManager;
    }

    public void persistCurrentID() {
        long recordID = this.counter.incrementAndGet();
        this.storeID(recordID, recordID);
    }

    public void cleanup() {
        if (this.cleanupRecords != null) {
            Iterator<Long> iterRecord = this.cleanupRecords.iterator();
            while (iterRecord.hasNext()) {
                Long record = iterRecord.next();
                if (!iterRecord.hasNext()) continue;
                this.deleteID(record);
            }
            this.cleanupRecords.clear();
            this.cleanupRecords = null;
        }
    }

    public void loadState(long journalID, ActiveMQBuffer buffer) {
        this.addCleanupRecord(journalID);
        IDCounterEncoding encoding = new IDCounterEncoding();
        encoding.decode(buffer);
        this.nextID = encoding.id;
        this.counter.set(this.nextID);
    }

    public void forceNextID(long nextID) {
        long idJournal = this.counter.incrementAndGet();
        this.counter.set(nextID);
        this.storeID(idJournal, nextID);
    }

    public long generateID() {
        long id = this.counter.getAndIncrement();
        if (id >= this.nextID) {
            this.saveCheckPoint(id);
        }
        return id;
    }

    public long getCurrentID() {
        return this.counter.get();
    }

    private synchronized void saveCheckPoint(long id) {
        if (id >= this.nextID) {
            this.nextID += this.checkpointSize;
            if (!this.storageManager.isStarted()) {
                ActiveMQServerLogger.LOGGER.debug("The journalStorageManager is not loaded. This is probably ok as long as it's a notification being sent after shutdown");
            } else {
                this.storeID(this.counter.getAndIncrement(), this.nextID);
            }
        }
    }

    private void addCleanupRecord(long id) {
        if (this.cleanupRecords == null) {
            this.cleanupRecords = new LinkedList<Long>();
        }
        this.cleanupRecords.add(id);
    }

    private void storeID(long journalID, long id) {
        try {
            this.storageManager.storeID(journalID, id);
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.batchingIdError(e);
        }
    }

    private void deleteID(long journalID) {
        try {
            this.storageManager.deleteID(journalID);
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.batchingIdError(e);
        }
    }

    public static EncodingSupport createIDEncodingSupport(long id) {
        return new IDCounterEncoding(id);
    }

    protected static final class IDCounterEncoding
    implements EncodingSupport {
        private long id;

        public String toString() {
            return "IDCounterEncoding [id=" + this.id + "]";
        }

        private IDCounterEncoding(long id) {
            this.id = id;
        }

        IDCounterEncoding() {
        }

        public void decode(ActiveMQBuffer buffer) {
            this.id = buffer.readLong();
        }

        public void encode(ActiveMQBuffer buffer) {
            buffer.writeLong(this.id);
        }

        public int getEncodeSize() {
            return 8;
        }
    }
}

