/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.settings.impl;

import java.io.Serializable;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.settings.Mergeable;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.utils.BufferHelper;

public class AddressSettings
implements Mergeable<AddressSettings>,
Serializable,
EncodingSupport {
    private static final long serialVersionUID = 1607502280582336366L;
    public static final long DEFAULT_MAX_SIZE_BYTES = -1L;
    public static final AddressFullMessagePolicy DEFAULT_ADDRESS_FULL_MESSAGE_POLICY = AddressFullMessagePolicy.PAGE;
    public static final long DEFAULT_PAGE_SIZE = 0xA00000L;
    public static final int DEFAULT_MAX_DELIVERY_ATTEMPTS = 10;
    public static final int DEFAULT_PAGE_MAX_CACHE = 5;
    public static final int DEFAULT_MESSAGE_COUNTER_HISTORY_DAY_LIMIT = 0;
    public static final long DEFAULT_REDELIVER_DELAY = 0L;
    public static final double DEFAULT_REDELIVER_MULTIPLIER = 1.0;
    public static final boolean DEFAULT_LAST_VALUE_QUEUE = false;
    public static final boolean DEFAULT_AUTO_CREATE_QUEUES = true;
    public static final boolean DEFAULT_AUTO_DELETE_QUEUES = true;
    public static final long DEFAULT_REDISTRIBUTION_DELAY = -1L;
    public static final long DEFAULT_EXPIRY_DELAY = -1L;
    public static final boolean DEFAULT_SEND_TO_DLA_ON_NO_ROUTE = false;
    public static final long DEFAULT_SLOW_CONSUMER_THRESHOLD = -1L;
    public static final long DEFAULT_SLOW_CONSUMER_CHECK_PERIOD = 5L;
    public static final SlowConsumerPolicy DEFAULT_SLOW_CONSUMER_POLICY = SlowConsumerPolicy.NOTIFY;
    private AddressFullMessagePolicy addressFullMessagePolicy = null;
    private Long maxSizeBytes = null;
    private Long pageSizeBytes = null;
    private Integer pageMaxCache = null;
    private Boolean dropMessagesWhenFull = null;
    private Integer maxDeliveryAttempts = null;
    private Integer messageCounterHistoryDayLimit = null;
    private Long redeliveryDelay = null;
    private Double redeliveryMultiplier = null;
    private Long maxRedeliveryDelay = null;
    private SimpleString deadLetterAddress = null;
    private SimpleString expiryAddress = null;
    private Long expiryDelay = -1L;
    private Boolean lastValueQueue = null;
    private Long redistributionDelay = null;
    private Boolean sendToDLAOnNoRoute = null;
    private Long slowConsumerThreshold = null;
    private Long slowConsumerCheckPeriod = null;
    private SlowConsumerPolicy slowConsumerPolicy = null;
    private Boolean autoCreateJmsQueues = null;
    private Boolean autoDeleteJmsQueues = null;

    public AddressSettings(AddressSettings other) {
        this.addressFullMessagePolicy = other.addressFullMessagePolicy;
        this.maxSizeBytes = other.maxSizeBytes;
        this.pageSizeBytes = other.pageSizeBytes;
        this.pageMaxCache = other.pageMaxCache;
        this.dropMessagesWhenFull = other.dropMessagesWhenFull;
        this.maxDeliveryAttempts = other.maxDeliveryAttempts;
        this.messageCounterHistoryDayLimit = other.messageCounterHistoryDayLimit;
        this.redeliveryDelay = other.redeliveryDelay;
        this.redeliveryMultiplier = other.redeliveryMultiplier;
        this.maxRedeliveryDelay = other.maxRedeliveryDelay;
        this.deadLetterAddress = other.deadLetterAddress;
        this.expiryAddress = other.expiryAddress;
        this.expiryDelay = other.expiryDelay;
        this.lastValueQueue = other.lastValueQueue;
        this.redistributionDelay = other.redistributionDelay;
        this.sendToDLAOnNoRoute = other.sendToDLAOnNoRoute;
        this.slowConsumerThreshold = other.slowConsumerThreshold;
        this.slowConsumerCheckPeriod = other.slowConsumerCheckPeriod;
        this.slowConsumerPolicy = other.slowConsumerPolicy;
        this.autoCreateJmsQueues = other.autoCreateJmsQueues;
        this.autoDeleteJmsQueues = other.autoDeleteJmsQueues;
    }

    public AddressSettings() {
    }

    public boolean isAutoCreateJmsQueues() {
        return this.autoCreateJmsQueues != null ? this.autoCreateJmsQueues : true;
    }

    public AddressSettings setAutoCreateJmsQueues(boolean autoCreateJmsQueues) {
        this.autoCreateJmsQueues = autoCreateJmsQueues;
        return this;
    }

    public boolean isAutoDeleteJmsQueues() {
        return this.autoDeleteJmsQueues != null ? this.autoDeleteJmsQueues : true;
    }

    public AddressSettings setAutoDeleteJmsQueues(boolean autoDeleteJmsQueues) {
        this.autoDeleteJmsQueues = autoDeleteJmsQueues;
        return this;
    }

    public boolean isLastValueQueue() {
        return this.lastValueQueue != null ? this.lastValueQueue : false;
    }

    public AddressSettings setLastValueQueue(boolean lastValueQueue) {
        this.lastValueQueue = lastValueQueue;
        return this;
    }

    public AddressFullMessagePolicy getAddressFullMessagePolicy() {
        return this.addressFullMessagePolicy != null ? this.addressFullMessagePolicy : DEFAULT_ADDRESS_FULL_MESSAGE_POLICY;
    }

    public AddressSettings setAddressFullMessagePolicy(AddressFullMessagePolicy addressFullMessagePolicy) {
        this.addressFullMessagePolicy = addressFullMessagePolicy;
        return this;
    }

    public long getPageSizeBytes() {
        return this.pageSizeBytes != null ? this.pageSizeBytes : 0xA00000L;
    }

    public AddressSettings setPageSizeBytes(long pageSize) {
        this.pageSizeBytes = pageSize;
        return this;
    }

    public int getPageCacheMaxSize() {
        return this.pageMaxCache != null ? this.pageMaxCache : 5;
    }

    public AddressSettings setPageCacheMaxSize(int pageMaxCache) {
        this.pageMaxCache = pageMaxCache;
        return this;
    }

    public long getMaxSizeBytes() {
        return this.maxSizeBytes != null ? this.maxSizeBytes : -1L;
    }

    public AddressSettings setMaxSizeBytes(long maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    public int getMaxDeliveryAttempts() {
        return this.maxDeliveryAttempts != null ? this.maxDeliveryAttempts : 10;
    }

    public AddressSettings setMaxDeliveryAttempts(int maxDeliveryAttempts) {
        this.maxDeliveryAttempts = maxDeliveryAttempts;
        return this;
    }

    public int getMessageCounterHistoryDayLimit() {
        return this.messageCounterHistoryDayLimit != null ? this.messageCounterHistoryDayLimit : 0;
    }

    public AddressSettings setMessageCounterHistoryDayLimit(int messageCounterHistoryDayLimit) {
        this.messageCounterHistoryDayLimit = messageCounterHistoryDayLimit;
        return this;
    }

    public long getRedeliveryDelay() {
        return this.redeliveryDelay != null ? this.redeliveryDelay : 0L;
    }

    public AddressSettings setRedeliveryDelay(long redeliveryDelay) {
        this.redeliveryDelay = redeliveryDelay;
        return this;
    }

    public double getRedeliveryMultiplier() {
        return this.redeliveryMultiplier != null ? this.redeliveryMultiplier : 1.0;
    }

    public AddressSettings setRedeliveryMultiplier(double redeliveryMultiplier) {
        this.redeliveryMultiplier = redeliveryMultiplier;
        return this;
    }

    public long getMaxRedeliveryDelay() {
        return this.maxRedeliveryDelay != null ? this.maxRedeliveryDelay : this.getRedeliveryDelay() * 10L;
    }

    public AddressSettings setMaxRedeliveryDelay(long maxRedeliveryDelay) {
        this.maxRedeliveryDelay = maxRedeliveryDelay;
        return this;
    }

    public SimpleString getDeadLetterAddress() {
        return this.deadLetterAddress;
    }

    public AddressSettings setDeadLetterAddress(SimpleString deadLetterAddress) {
        this.deadLetterAddress = deadLetterAddress;
        return this;
    }

    public SimpleString getExpiryAddress() {
        return this.expiryAddress;
    }

    public AddressSettings setExpiryAddress(SimpleString expiryAddress) {
        this.expiryAddress = expiryAddress;
        return this;
    }

    public Long getExpiryDelay() {
        return this.expiryDelay;
    }

    public AddressSettings setExpiryDelay(Long expiryDelay) {
        this.expiryDelay = expiryDelay;
        return this;
    }

    public boolean isSendToDLAOnNoRoute() {
        return this.sendToDLAOnNoRoute != null ? this.sendToDLAOnNoRoute : false;
    }

    public AddressSettings setSendToDLAOnNoRoute(boolean value) {
        this.sendToDLAOnNoRoute = value;
        return this;
    }

    public long getRedistributionDelay() {
        return this.redistributionDelay != null ? this.redistributionDelay : -1L;
    }

    public AddressSettings setRedistributionDelay(long redistributionDelay) {
        this.redistributionDelay = redistributionDelay;
        return this;
    }

    public long getSlowConsumerThreshold() {
        return this.slowConsumerThreshold != null ? this.slowConsumerThreshold : -1L;
    }

    public AddressSettings setSlowConsumerThreshold(long slowConsumerThreshold) {
        this.slowConsumerThreshold = slowConsumerThreshold;
        return this;
    }

    public long getSlowConsumerCheckPeriod() {
        return this.slowConsumerCheckPeriod != null ? this.slowConsumerCheckPeriod : 5L;
    }

    public AddressSettings setSlowConsumerCheckPeriod(long slowConsumerCheckPeriod) {
        this.slowConsumerCheckPeriod = slowConsumerCheckPeriod;
        return this;
    }

    public SlowConsumerPolicy getSlowConsumerPolicy() {
        return this.slowConsumerPolicy != null ? this.slowConsumerPolicy : DEFAULT_SLOW_CONSUMER_POLICY;
    }

    public AddressSettings setSlowConsumerPolicy(SlowConsumerPolicy slowConsumerPolicy) {
        this.slowConsumerPolicy = slowConsumerPolicy;
        return this;
    }

    @Override
    public void merge(AddressSettings merged) {
        if (this.maxDeliveryAttempts == null) {
            this.maxDeliveryAttempts = merged.maxDeliveryAttempts;
        }
        if (this.dropMessagesWhenFull == null) {
            this.dropMessagesWhenFull = merged.dropMessagesWhenFull;
        }
        if (this.maxSizeBytes == null) {
            this.maxSizeBytes = merged.maxSizeBytes;
        }
        if (this.pageMaxCache == null) {
            this.pageMaxCache = merged.pageMaxCache;
        }
        if (this.pageSizeBytes == null) {
            this.pageSizeBytes = merged.getPageSizeBytes();
        }
        if (this.messageCounterHistoryDayLimit == null) {
            this.messageCounterHistoryDayLimit = merged.messageCounterHistoryDayLimit;
        }
        if (this.redeliveryDelay == null) {
            this.redeliveryDelay = merged.redeliveryDelay;
        }
        if (this.redeliveryMultiplier == null) {
            this.redeliveryMultiplier = merged.redeliveryMultiplier;
        }
        if (this.maxRedeliveryDelay == null) {
            this.maxRedeliveryDelay = merged.maxRedeliveryDelay;
        }
        if (this.deadLetterAddress == null) {
            this.deadLetterAddress = merged.deadLetterAddress;
        }
        if (this.expiryAddress == null) {
            this.expiryAddress = merged.expiryAddress;
        }
        if (this.expiryDelay == null) {
            this.expiryDelay = merged.expiryDelay;
        }
        if (this.redistributionDelay == null) {
            this.redistributionDelay = merged.redistributionDelay;
        }
        if (this.sendToDLAOnNoRoute == null) {
            this.sendToDLAOnNoRoute = merged.sendToDLAOnNoRoute;
        }
        if (this.addressFullMessagePolicy == null) {
            this.addressFullMessagePolicy = merged.addressFullMessagePolicy;
        }
        if (this.slowConsumerThreshold == null) {
            this.slowConsumerThreshold = merged.slowConsumerThreshold;
        }
        if (this.slowConsumerCheckPeriod == null) {
            this.slowConsumerCheckPeriod = merged.slowConsumerCheckPeriod;
        }
        if (this.slowConsumerPolicy == null) {
            this.slowConsumerPolicy = merged.slowConsumerPolicy;
        }
        if (this.autoCreateJmsQueues == null) {
            this.autoCreateJmsQueues = merged.autoCreateJmsQueues;
        }
        if (this.autoDeleteJmsQueues == null) {
            this.autoDeleteJmsQueues = merged.autoDeleteJmsQueues;
        }
    }

    public void decode(ActiveMQBuffer buffer) {
        SimpleString policyStr = buffer.readNullableSimpleString();
        this.addressFullMessagePolicy = policyStr != null ? AddressFullMessagePolicy.valueOf((String)policyStr.toString()) : null;
        this.maxSizeBytes = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.pageSizeBytes = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.pageMaxCache = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        this.dropMessagesWhenFull = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.maxDeliveryAttempts = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        this.messageCounterHistoryDayLimit = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        this.redeliveryDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.redeliveryMultiplier = BufferHelper.readNullableDouble((ActiveMQBuffer)buffer);
        this.maxRedeliveryDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.deadLetterAddress = buffer.readNullableSimpleString();
        this.expiryAddress = buffer.readNullableSimpleString();
        this.expiryDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.lastValueQueue = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.redistributionDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.sendToDLAOnNoRoute = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.slowConsumerThreshold = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.slowConsumerCheckPeriod = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        policyStr = buffer.readNullableSimpleString();
        this.slowConsumerPolicy = policyStr != null ? SlowConsumerPolicy.valueOf(policyStr.toString()) : null;
        this.autoCreateJmsQueues = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.autoDeleteJmsQueues = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
    }

    public int getEncodeSize() {
        return BufferHelper.sizeOfNullableSimpleString(this.addressFullMessagePolicy != null ? this.addressFullMessagePolicy.toString() : null) + BufferHelper.sizeOfNullableLong((Long)this.maxSizeBytes) + BufferHelper.sizeOfNullableLong((Long)this.pageSizeBytes) + BufferHelper.sizeOfNullableInteger((Integer)this.pageMaxCache) + BufferHelper.sizeOfNullableBoolean((Boolean)this.dropMessagesWhenFull) + BufferHelper.sizeOfNullableInteger((Integer)this.maxDeliveryAttempts) + BufferHelper.sizeOfNullableInteger((Integer)this.messageCounterHistoryDayLimit) + BufferHelper.sizeOfNullableLong((Long)this.redeliveryDelay) + BufferHelper.sizeOfNullableDouble((Double)this.redeliveryMultiplier) + BufferHelper.sizeOfNullableLong((Long)this.maxRedeliveryDelay) + SimpleString.sizeofNullableString((SimpleString)this.deadLetterAddress) + SimpleString.sizeofNullableString((SimpleString)this.expiryAddress) + BufferHelper.sizeOfNullableLong((Long)this.expiryDelay) + BufferHelper.sizeOfNullableBoolean((Boolean)this.lastValueQueue) + BufferHelper.sizeOfNullableLong((Long)this.redistributionDelay) + BufferHelper.sizeOfNullableBoolean((Boolean)this.sendToDLAOnNoRoute) + BufferHelper.sizeOfNullableLong((Long)this.slowConsumerCheckPeriod) + BufferHelper.sizeOfNullableLong((Long)this.slowConsumerThreshold) + BufferHelper.sizeOfNullableSimpleString(this.slowConsumerPolicy != null ? this.slowConsumerPolicy.toString() : null) + BufferHelper.sizeOfNullableBoolean((Boolean)this.autoCreateJmsQueues) + BufferHelper.sizeOfNullableBoolean((Boolean)this.autoDeleteJmsQueues);
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeNullableSimpleString(this.addressFullMessagePolicy != null ? new SimpleString(this.addressFullMessagePolicy.toString()) : null);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.maxSizeBytes);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.pageSizeBytes);
        BufferHelper.writeNullableInteger((ActiveMQBuffer)buffer, (Integer)this.pageMaxCache);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.dropMessagesWhenFull);
        BufferHelper.writeNullableInteger((ActiveMQBuffer)buffer, (Integer)this.maxDeliveryAttempts);
        BufferHelper.writeNullableInteger((ActiveMQBuffer)buffer, (Integer)this.messageCounterHistoryDayLimit);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.redeliveryDelay);
        BufferHelper.writeNullableDouble((ActiveMQBuffer)buffer, (Double)this.redeliveryMultiplier);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.maxRedeliveryDelay);
        buffer.writeNullableSimpleString(this.deadLetterAddress);
        buffer.writeNullableSimpleString(this.expiryAddress);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.expiryDelay);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.lastValueQueue);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.redistributionDelay);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.sendToDLAOnNoRoute);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.slowConsumerThreshold);
        BufferHelper.writeNullableLong((ActiveMQBuffer)buffer, (Long)this.slowConsumerCheckPeriod);
        buffer.writeNullableSimpleString(this.slowConsumerPolicy != null ? new SimpleString(this.slowConsumerPolicy.toString()) : null);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.autoCreateJmsQueues);
        BufferHelper.writeNullableBoolean((ActiveMQBuffer)buffer, (Boolean)this.autoDeleteJmsQueues);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addressFullMessagePolicy == null ? 0 : this.addressFullMessagePolicy.hashCode());
        result = 31 * result + (this.deadLetterAddress == null ? 0 : this.deadLetterAddress.hashCode());
        result = 31 * result + (this.dropMessagesWhenFull == null ? 0 : this.dropMessagesWhenFull.hashCode());
        result = 31 * result + (this.expiryAddress == null ? 0 : this.expiryAddress.hashCode());
        result = 31 * result + (this.expiryDelay == null ? 0 : this.expiryDelay.hashCode());
        result = 31 * result + (this.lastValueQueue == null ? 0 : this.lastValueQueue.hashCode());
        result = 31 * result + (this.maxDeliveryAttempts == null ? 0 : this.maxDeliveryAttempts.hashCode());
        result = 31 * result + (this.maxSizeBytes == null ? 0 : this.maxSizeBytes.hashCode());
        result = 31 * result + (this.messageCounterHistoryDayLimit == null ? 0 : this.messageCounterHistoryDayLimit.hashCode());
        result = 31 * result + (this.pageSizeBytes == null ? 0 : this.pageSizeBytes.hashCode());
        result = 31 * result + (this.pageMaxCache == null ? 0 : this.pageMaxCache.hashCode());
        result = 31 * result + (this.redeliveryDelay == null ? 0 : this.redeliveryDelay.hashCode());
        result = 31 * result + (this.redeliveryMultiplier == null ? 0 : this.redeliveryMultiplier.hashCode());
        result = 31 * result + (this.maxRedeliveryDelay == null ? 0 : this.maxRedeliveryDelay.hashCode());
        result = 31 * result + (this.redistributionDelay == null ? 0 : this.redistributionDelay.hashCode());
        result = 31 * result + (this.sendToDLAOnNoRoute == null ? 0 : this.sendToDLAOnNoRoute.hashCode());
        result = 31 * result + (this.slowConsumerThreshold == null ? 0 : this.slowConsumerThreshold.hashCode());
        result = 31 * result + (this.slowConsumerCheckPeriod == null ? 0 : this.slowConsumerCheckPeriod.hashCode());
        result = 31 * result + (this.slowConsumerPolicy == null ? 0 : this.slowConsumerPolicy.hashCode());
        result = 31 * result + (this.autoCreateJmsQueues == null ? 0 : this.autoCreateJmsQueues.hashCode());
        result = 31 * result + (this.autoDeleteJmsQueues == null ? 0 : this.autoDeleteJmsQueues.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddressSettings other = (AddressSettings)obj;
        if (this.addressFullMessagePolicy == null ? other.addressFullMessagePolicy != null : !this.addressFullMessagePolicy.equals((Object)other.addressFullMessagePolicy)) {
            return false;
        }
        if (this.deadLetterAddress == null ? other.deadLetterAddress != null : !this.deadLetterAddress.equals((Object)other.deadLetterAddress)) {
            return false;
        }
        if (this.dropMessagesWhenFull == null ? other.dropMessagesWhenFull != null : !this.dropMessagesWhenFull.equals(other.dropMessagesWhenFull)) {
            return false;
        }
        if (this.expiryAddress == null ? other.expiryAddress != null : !this.expiryAddress.equals((Object)other.expiryAddress)) {
            return false;
        }
        if (this.expiryDelay == null ? other.expiryDelay != null : !this.expiryDelay.equals(other.expiryDelay)) {
            return false;
        }
        if (this.lastValueQueue == null ? other.lastValueQueue != null : !this.lastValueQueue.equals(other.lastValueQueue)) {
            return false;
        }
        if (this.maxDeliveryAttempts == null ? other.maxDeliveryAttempts != null : !this.maxDeliveryAttempts.equals(other.maxDeliveryAttempts)) {
            return false;
        }
        if (this.maxSizeBytes == null ? other.maxSizeBytes != null : !this.maxSizeBytes.equals(other.maxSizeBytes)) {
            return false;
        }
        if (this.messageCounterHistoryDayLimit == null ? other.messageCounterHistoryDayLimit != null : !this.messageCounterHistoryDayLimit.equals(other.messageCounterHistoryDayLimit)) {
            return false;
        }
        if (this.pageSizeBytes == null ? other.pageSizeBytes != null : !this.pageSizeBytes.equals(other.pageSizeBytes)) {
            return false;
        }
        if (this.pageMaxCache == null ? other.pageMaxCache != null : !this.pageMaxCache.equals(other.pageMaxCache)) {
            return false;
        }
        if (this.redeliveryDelay == null ? other.redeliveryDelay != null : !this.redeliveryDelay.equals(other.redeliveryDelay)) {
            return false;
        }
        if (this.redeliveryMultiplier == null ? other.redeliveryMultiplier != null : !this.redeliveryMultiplier.equals(other.redeliveryMultiplier)) {
            return false;
        }
        if (this.maxRedeliveryDelay == null ? other.maxRedeliveryDelay != null : !this.maxRedeliveryDelay.equals(other.maxRedeliveryDelay)) {
            return false;
        }
        if (this.redistributionDelay == null ? other.redistributionDelay != null : !this.redistributionDelay.equals(other.redistributionDelay)) {
            return false;
        }
        if (this.sendToDLAOnNoRoute == null ? other.sendToDLAOnNoRoute != null : !this.sendToDLAOnNoRoute.equals(other.sendToDLAOnNoRoute)) {
            return false;
        }
        if (this.slowConsumerThreshold == null ? other.slowConsumerThreshold != null : !this.slowConsumerThreshold.equals(other.slowConsumerThreshold)) {
            return false;
        }
        if (this.slowConsumerCheckPeriod == null ? other.slowConsumerCheckPeriod != null : !this.slowConsumerCheckPeriod.equals(other.slowConsumerCheckPeriod)) {
            return false;
        }
        if (this.slowConsumerPolicy == null ? other.slowConsumerPolicy != null : !this.slowConsumerPolicy.equals((Object)other.slowConsumerPolicy)) {
            return false;
        }
        if (this.autoCreateJmsQueues == null ? other.autoCreateJmsQueues != null : !this.autoCreateJmsQueues.equals(other.autoCreateJmsQueues)) {
            return false;
        }
        return !(this.autoDeleteJmsQueues == null ? other.autoDeleteJmsQueues != null : !this.autoDeleteJmsQueues.equals(other.autoDeleteJmsQueues));
    }

    public String toString() {
        return "AddressSettings [addressFullMessagePolicy=" + this.addressFullMessagePolicy + ", deadLetterAddress=" + this.deadLetterAddress + ", dropMessagesWhenFull=" + this.dropMessagesWhenFull + ", expiryAddress=" + this.expiryAddress + ", expiryDelay=" + this.expiryDelay + ", lastValueQueue=" + this.lastValueQueue + ", maxDeliveryAttempts=" + this.maxDeliveryAttempts + ", maxSizeBytes=" + this.maxSizeBytes + ", messageCounterHistoryDayLimit=" + this.messageCounterHistoryDayLimit + ", pageSizeBytes=" + this.pageSizeBytes + ", pageMaxCache=" + this.pageMaxCache + ", redeliveryDelay=" + this.redeliveryDelay + ", redeliveryMultiplier=" + this.redeliveryMultiplier + ", maxRedeliveryDelay=" + this.maxRedeliveryDelay + ", redistributionDelay=" + this.redistributionDelay + ", sendToDLAOnNoRoute=" + this.sendToDLAOnNoRoute + ", slowConsumerThreshold=" + this.slowConsumerThreshold + ", slowConsumerCheckPeriod=" + this.slowConsumerCheckPeriod + ", slowConsumerPolicy=" + (Object)((Object)this.slowConsumerPolicy) + ", autoCreateJmsQueues=" + this.autoCreateJmsQueues + ", autoDeleteJmsQueues=" + this.autoDeleteJmsQueues + "]";
    }
}

