/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.nullpm;

import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.server.impl.ServerMessageImpl;

class NullStorageLargeServerMessage
extends ServerMessageImpl
implements LargeServerMessage {
    public NullStorageLargeServerMessage() {
    }

    public NullStorageLargeServerMessage(NullStorageLargeServerMessage other) {
        super(other);
    }

    @Override
    public void releaseResources() {
    }

    @Override
    public synchronized void addBytes(byte[] bytes) {
        if (this.buffer == null) {
            this.buffer = ActiveMQBuffers.dynamicBuffer((int)bytes.length);
        }
        this.buffer.writeBytes(bytes);
    }

    @Override
    public void deleteFile() throws Exception {
    }

    @Override
    public boolean isLargeMessage() {
        return true;
    }

    @Override
    public void decrementDelayDeletionCount() {
    }

    @Override
    public void incrementDelayDeletionCount() {
    }

    public synchronized int getEncodeSize() {
        return this.getHeadersAndPropertiesEncodeSize();
    }

    @Override
    public String toString() {
        return "NullStorageLargeServerMessage[messageID=" + this.messageID + ", durable=" + this.durable + ", address=" + this.getAddress() + ",properties=" + this.properties.toString() + "]";
    }

    @Override
    public ServerMessage copy() {
        return new NullStorageLargeServerMessage(this);
    }

    @Override
    public void setPaged() {
    }

    @Override
    public void setPendingRecordID(long pendingRecordID) {
    }

    @Override
    public long getPendingRecordID() {
        return -1L;
    }

    @Override
    public SequentialFile getFile() {
        return null;
    }
}

