/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.lang.invoke.MethodHandles;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.activemq.artemis.ra.ActiveMQRABytesMessage;
import org.apache.activemq.artemis.ra.ActiveMQRAMapMessage;
import org.apache.activemq.artemis.ra.ActiveMQRAMessage;
import org.apache.activemq.artemis.ra.ActiveMQRAMessageListener;
import org.apache.activemq.artemis.ra.ActiveMQRAObjectMessage;
import org.apache.activemq.artemis.ra.ActiveMQRASession;
import org.apache.activemq.artemis.ra.ActiveMQRAStreamMessage;
import org.apache.activemq.artemis.ra.ActiveMQRATextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQRAMessageConsumer
implements MessageConsumer {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected MessageConsumer consumer;
    protected ActiveMQRASession session;

    public ActiveMQRAMessageConsumer(MessageConsumer consumer, ActiveMQRASession session) {
        this.consumer = consumer;
        this.session = session;
        if (logger.isTraceEnabled()) {
            logger.trace("new ActiveMQMessageConsumer {} consumer={} session={}", new Object[]{this, consumer, session});
        }
    }

    public void close() throws JMSException {
        logger.trace("close {}", (Object)this);
        try {
            this.closeConsumer();
        }
        finally {
            this.session.removeConsumer(this);
        }
    }

    void checkState() throws JMSException {
        logger.trace("checkState()");
        this.session.checkState();
    }

    public MessageListener getMessageListener() throws JMSException {
        logger.trace("getMessageListener()");
        this.checkState();
        this.session.checkStrict();
        return this.consumer.getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.session.lock();
        try {
            this.checkState();
            this.session.checkStrict();
            if (listener == null) {
                this.consumer.setMessageListener(null);
            } else {
                this.consumer.setMessageListener(this.wrapMessageListener(listener));
            }
        }
        finally {
            this.session.unlock();
        }
    }

    public String getMessageSelector() throws JMSException {
        logger.trace("getMessageSelector()");
        this.checkState();
        return this.consumer.getMessageSelector();
    }

    public Message receive() throws JMSException {
        this.session.lock();
        try {
            logger.trace("receive {}", (Object)this);
            this.checkState();
            Message message = this.consumer.receive();
            logger.trace("received {} result={}", (Object)this, (Object)message);
            if (message == null) {
                Message message2 = null;
                return message2;
            }
            Message message3 = this.wrapMessage(message);
            return message3;
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(long timeout) throws JMSException {
        this.session.lock();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("receive {} timeout={}", (Object)this, (Object)timeout);
            }
            this.checkState();
            Message message = this.consumer.receive(timeout);
            logger.trace("received {} result={}", (Object)this, (Object)message);
            if (message == null) {
                Message message2 = null;
                return message2;
            }
            Message message3 = this.wrapMessage(message);
            return message3;
        }
        finally {
            this.session.unlock();
        }
    }

    public Message receiveNoWait() throws JMSException {
        this.session.lock();
        try {
            logger.trace("receiveNoWait {}", (Object)this);
            this.checkState();
            Message message = this.consumer.receiveNoWait();
            logger.trace("received {} result={}", (Object)this, (Object)message);
            if (message == null) {
                Message message2 = null;
                return message2;
            }
            Message message3 = this.wrapMessage(message);
            return message3;
        }
        finally {
            this.session.unlock();
        }
    }

    void closeConsumer() throws JMSException {
        logger.trace("closeConsumer()");
        this.consumer.close();
    }

    Message wrapMessage(Message message) {
        logger.trace("wrapMessage({})", (Object)message);
        if (message instanceof BytesMessage) {
            BytesMessage bytesMessage = (BytesMessage)message;
            return new ActiveMQRABytesMessage(bytesMessage, this.session);
        }
        if (message instanceof MapMessage) {
            MapMessage mapMessage = (MapMessage)message;
            return new ActiveMQRAMapMessage(mapMessage, this.session);
        }
        if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)message;
            return new ActiveMQRAObjectMessage(objectMessage, this.session);
        }
        if (message instanceof StreamMessage) {
            StreamMessage streamMessage = (StreamMessage)message;
            return new ActiveMQRAStreamMessage(streamMessage, this.session);
        }
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            return new ActiveMQRATextMessage(textMessage, this.session);
        }
        return new ActiveMQRAMessage(message, this.session);
    }

    MessageListener wrapMessageListener(MessageListener listener) {
        logger.trace("getMessageSelector()");
        return new ActiveMQRAMessageListener(listener, this);
    }
}

