/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire.amq;

import java.io.IOException;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerImpl;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireMessageConverter;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireUtil;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQServerConsumer;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQServerSession;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQSession;
import org.apache.activemq.artemis.core.protocol.openwire.amq.BrowserListener;
import org.apache.activemq.artemis.core.protocol.openwire.amq.MessageInfo;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.wireformat.WireFormat;

public class AMQConsumer
implements BrowserListener {
    private AMQSession session;
    private ActiveMQDestination actualDest;
    private ConsumerInfo info;
    private final ScheduledExecutorService scheduledPool;
    private long nativeId = -1L;
    private SimpleString subQueueName = null;
    private final int prefetchSize;
    private AtomicInteger windowAvailable;
    private final Queue<MessageInfo> deliveringRefs = new ConcurrentLinkedQueue<MessageInfo>();
    private long messagePullSequence = 0L;
    private MessagePullHandler messagePullHandler;

    public AMQConsumer(AMQSession amqSession, ActiveMQDestination d, ConsumerInfo info, ScheduledExecutorService scheduledPool) {
        this.session = amqSession;
        this.actualDest = d;
        this.info = info;
        this.scheduledPool = scheduledPool;
        this.prefetchSize = info.getPrefetchSize();
        this.windowAvailable = new AtomicInteger(this.prefetchSize);
        if (this.prefetchSize == 0) {
            this.messagePullHandler = new MessagePullHandler();
        }
    }

    public void init() throws Exception {
        AMQServerSession coreSession = this.session.getCoreSession();
        SimpleString selector = this.info.getSelector() == null ? null : new SimpleString(this.info.getSelector());
        this.nativeId = this.session.getCoreServer().getStorageManager().generateID();
        SimpleString address = new SimpleString(this.actualDest.getPhysicalName());
        if (this.actualDest.isTopic()) {
            String physicalName = this.actualDest.getPhysicalName();
            if (physicalName.contains(".>")) {
                physicalName = OpenWireUtil.convertWildcard(physicalName);
            }
            address = new SimpleString("jms.topic." + physicalName);
            if (this.info.isDurable()) {
                this.subQueueName = new SimpleString(org.apache.activemq.artemis.jms.client.ActiveMQDestination.createQueueNameForDurableSubscription((boolean)true, (String)this.info.getClientId(), (String)this.info.getSubscriptionName()));
                QueueQueryResult result = coreSession.executeQueueQuery(this.subQueueName);
                if (result.isExists()) {
                    boolean topicChanged;
                    if (result.getConsumerCount() > 0) {
                        throw new IllegalStateException("Cannot create a subscriber on the durable subscription since it already has subscriber(s)");
                    }
                    SimpleString oldFilterString = result.getFilterString();
                    boolean selectorChanged = selector == null && oldFilterString != null || oldFilterString == null && selector != null || oldFilterString != null && selector != null && !oldFilterString.equals((Object)selector);
                    SimpleString oldTopicName = result.getAddress();
                    boolean bl = topicChanged = !oldTopicName.equals((Object)address);
                    if (selectorChanged || topicChanged) {
                        coreSession.deleteQueue(this.subQueueName);
                        coreSession.createQueue(address, this.subQueueName, selector, false, true);
                    }
                } else {
                    coreSession.createQueue(address, this.subQueueName, selector, false, true);
                }
            } else {
                this.subQueueName = new SimpleString(UUID.randomUUID().toString());
                coreSession.createQueue(address, this.subQueueName, selector, true, false);
            }
            coreSession.createConsumer(this.nativeId, this.subQueueName, null, this.info.isBrowser(), false, -1);
        } else {
            SimpleString queueName = new SimpleString("jms.queue." + this.actualDest.getPhysicalName());
            coreSession.createConsumer(this.nativeId, queueName, selector, this.info.isBrowser(), false, -1);
        }
        if (this.info.isBrowser()) {
            AMQServerConsumer coreConsumer = coreSession.getConsumer(this.nativeId);
            coreConsumer.setBrowserListener(this);
        }
    }

    public long getNativeId() {
        return this.nativeId;
    }

    public ConsumerId getId() {
        return this.info.getConsumerId();
    }

    public WireFormat getMarshaller() {
        return this.session.getMarshaller();
    }

    public void acquireCredit(int n) throws Exception {
        boolean promptDelivery;
        boolean bl = promptDelivery = this.windowAvailable.get() == 0;
        if (this.windowAvailable.get() < this.prefetchSize) {
            this.windowAvailable.addAndGet(n);
        }
        if (promptDelivery) {
            this.session.getCoreSession().promptDelivery(this.nativeId);
        }
    }

    public int handleDeliver(ServerMessage message, int deliveryCount) {
        try {
            if (this.messagePullHandler != null && !this.messagePullHandler.checkForcedConsumer(message)) {
                return 0;
            }
            MessageDispatch dispatch = OpenWireMessageConverter.createMessageDispatch(message, deliveryCount - 1, this);
            int size = dispatch.getMessage().getSize();
            this.deliveringRefs.add(new MessageInfo(dispatch.getMessage().getMessageId(), message.getMessageID(), size));
            this.session.deliverMessage(dispatch);
            this.windowAvailable.decrementAndGet();
            return size;
        }
        catch (IOException e) {}
        finally {
            return 0;
        }
    }

    public void handleDeliverNullDispatch() {
        MessageDispatch md = new MessageDispatch();
        md.setConsumerId(this.getId());
        md.setDestination(this.actualDest);
        this.session.deliverMessage(md);
        this.windowAvailable.decrementAndGet();
    }

    public void acknowledge(MessageAck ack) throws Exception {
        MessageId first = ack.getFirstMessageId();
        MessageId lastm = ack.getLastMessageId();
        TransactionId tid = ack.getTransactionId();
        boolean isLocalTx = tid != null && tid.isLocalTransaction();
        boolean single = lastm.equals((Object)first);
        MessageInfo mi = null;
        int n = 0;
        if (ack.isIndividualAck()) {
            Iterator iter = this.deliveringRefs.iterator();
            while (iter.hasNext()) {
                mi = (MessageInfo)iter.next();
                if (!mi.amqId.equals((Object)lastm)) continue;
                ++n;
                iter.remove();
                this.session.getCoreSession().individualAcknowledge(this.nativeId, mi.nativeId);
                this.session.getCoreSession().commit();
                break;
            }
        } else if (ack.isRedeliveredAck()) {
            n = 1;
        } else if (ack.isPoisonAck()) {
            Iterator iter = this.deliveringRefs.iterator();
            boolean firstFound = false;
            while (iter.hasNext()) {
                mi = (MessageInfo)iter.next();
                if (mi.amqId.equals((Object)first)) {
                    ++n;
                    iter.remove();
                    this.session.getCoreSession().moveToDeadLetterAddress(this.nativeId, mi.nativeId, ack.getPoisonCause());
                    this.session.getCoreSession().commit();
                    if (!single) {
                        firstFound = true;
                        continue;
                    }
                } else {
                    if (!firstFound && first != null) continue;
                    ++n;
                    iter.remove();
                    this.session.getCoreSession().moveToDeadLetterAddress(this.nativeId, mi.nativeId, ack.getPoisonCause());
                    this.session.getCoreSession().commit();
                    if (!mi.amqId.equals((Object)lastm)) continue;
                }
                break;
            }
        } else if (ack.isDeliveredAck() || ack.isExpiredAck()) {
            n = 1;
        } else {
            Iterator iter = this.deliveringRefs.iterator();
            boolean firstFound = false;
            while (iter.hasNext()) {
                MessageInfo ami = (MessageInfo)iter.next();
                if (ami.amqId.equals((Object)first)) {
                    ++n;
                    if (!isLocalTx) {
                        iter.remove();
                    } else {
                        ami.setLocalAcked(true);
                    }
                    if (single) {
                        mi = ami;
                        break;
                    }
                    firstFound = true;
                    continue;
                }
                if (!firstFound && first != null) continue;
                ++n;
                if (!isLocalTx) {
                    iter.remove();
                } else {
                    ami.setLocalAcked(true);
                }
                if (!ami.amqId.equals((Object)lastm)) continue;
                mi = ami;
                break;
            }
            if (mi != null && !isLocalTx) {
                this.session.getCoreSession().acknowledge(this.nativeId, mi.nativeId);
            }
        }
        this.acquireCredit(n);
    }

    @Override
    public void browseFinished() {
        MessageDispatch md = new MessageDispatch();
        md.setConsumerId(this.info.getConsumerId());
        md.setMessage(null);
        md.setDestination(null);
        this.session.deliverMessage(md);
    }

    public boolean handledTransactionalMsg() {
        return false;
    }

    public void finishTx() throws Exception {
        MessageInfo lastMi = null;
        MessageInfo mi = null;
        Iterator iter = this.deliveringRefs.iterator();
        while (iter.hasNext()) {
            mi = (MessageInfo)iter.next();
            if (!mi.isLocalAcked()) continue;
            iter.remove();
            lastMi = mi;
        }
        if (lastMi != null) {
            this.session.getCoreSession().acknowledge(this.nativeId, lastMi.nativeId);
        }
    }

    public void rollbackTx(Set<Long> acked) throws Exception {
        MessageInfo lastMi = null;
        MessageInfo mi2 = null;
        for (MessageInfo mi2 : this.deliveringRefs) {
            if (!mi2.isLocalAcked()) continue;
            acked.add(mi2.nativeId);
            lastMi = mi2;
        }
        if (lastMi != null) {
            this.session.getCoreSession().acknowledge(this.nativeId, lastMi.nativeId);
        }
    }

    public ActiveMQDestination getDestination() {
        return this.actualDest;
    }

    public ConsumerInfo getInfo() {
        return this.info;
    }

    public boolean hasCredits() {
        return this.windowAvailable.get() > 0;
    }

    public void processMessagePull(MessagePull messagePull) throws Exception {
        this.windowAvailable.incrementAndGet();
        if (this.messagePullHandler != null) {
            this.messagePullHandler.nextSequence(this.messagePullSequence++, messagePull.getTimeout());
        }
    }

    public void removeConsumer() throws Exception {
        this.session.removeConsumer(this.nativeId);
    }

    public ActiveMQDestination getActualDestination() {
        return this.actualDest;
    }

    private class MessagePullHandler {
        private long next = -1L;
        private long timeout;
        private CountDownLatch latch = new CountDownLatch(1);
        private ScheduledFuture<?> messagePullFuture;

        private MessagePullHandler() {
        }

        public void nextSequence(long next, long timeout) throws Exception {
            this.next = next;
            this.timeout = timeout;
            this.latch = new CountDownLatch(1);
            AMQConsumer.this.session.getCoreSession().forceConsumerDelivery(AMQConsumer.this.nativeId, AMQConsumer.this.messagePullSequence);
            if (timeout <= 0L) {
                this.latch.await(10L, TimeUnit.SECONDS);
                if (this.next >= 0L) {
                    AMQConsumer.this.handleDeliverNullDispatch();
                }
            }
        }

        public boolean checkForcedConsumer(ServerMessage message) {
            if (message.containsProperty(ClientConsumerImpl.FORCED_DELIVERY_MESSAGE)) {
                System.out.println("MessagePullHandler.checkForcedConsumer");
                if (this.next >= 0L) {
                    if (this.timeout <= 0L) {
                        this.latch.countDown();
                    } else {
                        this.messagePullFuture = AMQConsumer.this.scheduledPool.schedule(new Runnable(){

                            @Override
                            public void run() {
                                if (MessagePullHandler.this.next >= 0L) {
                                    AMQConsumer.this.handleDeliverNullDispatch();
                                }
                            }
                        }, this.timeout, TimeUnit.MILLISECONDS);
                    }
                }
                return false;
            }
            this.next = -1L;
            if (this.messagePullFuture != null) {
                this.messagePullFuture.cancel(true);
            }
            this.latch.countDown();
            return true;
        }
    }
}

