/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire.amq;

import java.util.List;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQServerSession;
import org.apache.activemq.artemis.core.protocol.openwire.amq.BrowserListener;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.HandleStatus;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.server.impl.ServerConsumerImpl;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;

public class AMQServerConsumer
extends ServerConsumerImpl {
    public AMQServerConsumer(long consumerID, AMQServerSession serverSession, QueueBinding binding, Filter filter, boolean started, boolean browseOnly, StorageManager storageManager, SessionCallback callback, boolean preAcknowledge, boolean strictUpdateDeliveryCount, ManagementService managementService, boolean supportLargeMessage, Integer credits) throws Exception {
        super(consumerID, (ServerSession)serverSession, binding, filter, started, browseOnly, storageManager, callback, preAcknowledge, strictUpdateDeliveryCount, managementService, supportLargeMessage, credits);
    }

    public void setBrowserListener(BrowserListener listener) {
        AMQBrowserDeliverer newBrowserDeliverer = new AMQBrowserDeliverer(this.browserDeliverer);
        newBrowserDeliverer.listener = listener;
        this.browserDeliverer = newBrowserDeliverer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void amqPutBackToDeliveringList(List<MessageReference> refs) {
        java.util.Queue queue = this.deliveringRefs;
        synchronized (queue) {
            for (MessageReference ref : refs) {
                ref.incrementDeliveryCount();
                this.deliveringRefs.add(ref);
            }
            if (refs.size() > 0) {
                long first = refs.get(0).getMessage().getMessageID();
                MessageReference m = (MessageReference)this.deliveringRefs.peek();
                while (m.getMessage().getMessageID() != first) {
                    this.deliveringRefs.poll();
                    this.deliveringRefs.add(m);
                    m = (MessageReference)this.deliveringRefs.peek();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToDeadLetterAddress(long mid, Throwable cause) throws Exception {
        QueueImpl queue;
        MessageReference ref = this.removeReferenceByID(mid);
        if (ref == null) {
            throw new IllegalStateException("Cannot find ref to ack " + mid);
        }
        ServerMessage coreMsg = ref.getMessage();
        coreMsg.putStringProperty("__HDR_dlqDeliveryFailureCause", cause.toString());
        QueueImpl queueImpl = queue = (QueueImpl)ref.getQueue();
        synchronized (queueImpl) {
            queue.sendToDeadLetterAddress(ref);
            queue.decDelivering();
        }
    }

    private class AMQBrowserDeliverer
    extends ServerConsumerImpl.BrowserDeliverer {
        private BrowserListener listener;

        public AMQBrowserDeliverer(ServerConsumerImpl.BrowserDeliverer other) {
            super((ServerConsumerImpl)AMQServerConsumer.this, other.iterator);
            this.listener = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            block14: {
                if (this.current != null) {
                    try {
                        HandleStatus status = AMQServerConsumer.this.handle(this.current);
                        if (status == HandleStatus.BUSY) {
                            return;
                        }
                        if (status == HandleStatus.HANDLED) {
                            AMQServerConsumer.this.proceedDeliver(this.current);
                        }
                        this.current = null;
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.errorBrowserHandlingMessage(e, this.current);
                        return;
                    }
                }
                MessageReference ref = null;
                try {
                    while (true) {
                        HandleStatus status;
                        ref = null;
                        Queue queue = AMQServerConsumer.this.messageQueue;
                        synchronized (queue) {
                            if (!this.iterator.hasNext()) {
                                if (this.listener != null) {
                                    this.listener.browseFinished();
                                }
                                break block14;
                            }
                            ref = (MessageReference)this.iterator.next();
                            status = AMQServerConsumer.this.handle(ref);
                        }
                        if (status == HandleStatus.HANDLED) {
                            AMQServerConsumer.this.proceedDeliver(ref);
                            continue;
                        }
                        if (status == HandleStatus.BUSY) break;
                    }
                    this.current = ref;
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorBrowserHandlingMessage(e, ref);
                }
            }
        }
    }
}

