/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.boot.Artemis;
import org.apache.activemq.artemis.maven.ArtemisAbstractPlugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="upgrade", defaultPhase=LifecyclePhase.TEST_COMPILE, threadSafe=true)
public class ArtemisUpgradePlugin
extends ArtemisAbstractPlugin {
    @Parameter
    String name;
    @Parameter(defaultValue="${activemq.basedir}", required=true)
    private File home;
    @Parameter(defaultValue="${activemq.basedir}/artemis-distribution/target/apache-artemis-${project.version}-bin/apache-artemis-${project.version}/", required=true)
    private File alternateHome;
    @Parameter(defaultValue="${basedir}/target/server0", required=true)
    private File instance;
    @Parameter
    private String[] args;
    @Parameter
    boolean useSystemOutput = this.getLog().isDebugEnabled();

    @Override
    protected boolean isIgnore() {
        return false;
    }

    private void add(List<String> list, String ... str) {
        for (String s : str) {
            list.add(s);
        }
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)("Local " + String.valueOf(this.localRepository)));
        MavenProject project = (MavenProject)this.getPluginContext().get("project");
        this.home = this.findArtemisHome(this.home, this.alternateHome);
        Map properties = this.getPluginContext();
        Set entries = properties.entrySet();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Entries.size " + entries.size()));
            for (Map.Entry entry : entries) {
                this.getLog().debug((CharSequence)("... key=" + String.valueOf(entry.getKey()) + " = " + String.valueOf(entry.getValue())));
            }
        }
        ArrayList<String> listCommands = new ArrayList<String>();
        this.add(listCommands, "upgrade");
        this.add(listCommands, this.instance.getAbsolutePath());
        if (this.args != null) {
            for (String a : this.args) {
                this.add(listCommands, a);
            }
        }
        this.getLog().debug((CharSequence)("***** Server upgrading at " + String.valueOf(this.instance) + " with home=" + String.valueOf(this.home) + " *****"));
        try {
            Artemis.execute((File)this.home, null, null, (boolean)this.useSystemOutput, (boolean)false, listCommands);
        }
        catch (Throwable throwable) {
            this.getLog().error(throwable);
            throw new MojoFailureException(throwable.getMessage());
        }
    }
}

