/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.maven;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.maven.ArtemisAbstractPlugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="dependency-scan", defaultPhase=LifecyclePhase.VERIFY)
public class ArtemisDependencyScanPlugin
extends ArtemisAbstractPlugin {
    @Parameter
    String name;
    private PluginDescriptor descriptor;
    @Parameter
    private String[] libListWithDeps;
    @Parameter
    private String[] libList;
    @Parameter
    private String variableName;
    @Parameter
    private String pathSeparator = File.pathSeparator;
    @Parameter
    private File targetFolder;

    @Override
    protected boolean isIgnore() {
        return false;
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Local " + this.localRepository));
        MavenProject project = (MavenProject)this.getPluginContext().get("project");
        Map properties = this.getPluginContext();
        Set entries = properties.entrySet();
        this.getLog().info((CharSequence)("Entries.size " + entries.size()));
        for (Map.Entry entry : entries) {
            this.getLog().info((CharSequence)("... key=" + entry.getKey() + " = " + entry.getValue()));
        }
        try {
            StringBuffer buffer = new StringBuffer();
            Set<File> filesSet = this.resolveDependencies(this.libListWithDeps, this.libList);
            if (this.variableName != null) {
                String separatorUsed = "";
                for (File f : filesSet) {
                    buffer.append(separatorUsed);
                    buffer.append(f.getAbsolutePath());
                    separatorUsed = this.pathSeparator;
                }
                String classPathGenerated = buffer.toString();
                project.getProperties().setProperty(this.variableName, classPathGenerated);
                this.getLog().info((CharSequence)("dependency-scan setting: " + this.variableName + "=" + classPathGenerated));
            }
            if (this.targetFolder != null) {
                this.targetFolder.mkdirs();
                for (File file : filesSet) {
                    Files.copy(file.toPath(), this.targetFolder.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
        catch (Throwable e) {
            this.getLog().error(e);
            throw new MojoFailureException(e.getMessage());
        }
    }
}

