/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.lockmanager.file;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.lockmanager.DistributedLock;
import org.apache.activemq.artemis.lockmanager.DistributedLockManager;
import org.apache.activemq.artemis.lockmanager.MutableLong;
import org.apache.activemq.artemis.lockmanager.UnavailableStateException;
import org.apache.activemq.artemis.lockmanager.file.FileDistributedLock;

public class FileBasedLockManager
implements DistributedLockManager {
    private final File locksFolder;
    private final Map<String, FileDistributedLock> locks;
    private boolean started;

    public FileBasedLockManager(Map<String, String> args) {
        this(new File(args.get("locks-folder")));
    }

    public FileBasedLockManager(File locksFolder) {
        Objects.requireNonNull(locksFolder);
        if (!locksFolder.exists()) {
            throw new IllegalStateException(String.valueOf(locksFolder) + " is supposed to already exists");
        }
        if (!locksFolder.isDirectory()) {
            throw new IllegalStateException(String.valueOf(locksFolder) + " is supposed to be a directory");
        }
        this.locksFolder = locksFolder;
        this.locks = new HashMap<String, FileDistributedLock>();
    }

    public boolean isStarted() {
        return this.started;
    }

    public void addUnavailableManagerListener(DistributedLockManager.UnavailableManagerListener listener) {
    }

    public void removeUnavailableManagerListener(DistributedLockManager.UnavailableManagerListener listener) {
    }

    public boolean start(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
        if (timeout >= 0L) {
            Objects.requireNonNull(unit);
        }
        if (this.started) {
            return true;
        }
        this.started = true;
        return true;
    }

    public void start() throws InterruptedException, ExecutionException {
        this.start(-1L, null);
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        try {
            this.locks.forEach((lockId, lock) -> {
                try {
                    lock.close(false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            this.locks.clear();
        }
        finally {
            this.started = false;
        }
    }

    public DistributedLock getDistributedLock(String lockId) throws ExecutionException {
        Objects.requireNonNull(lockId);
        if (!this.started) {
            throw new IllegalStateException("manager should be started first");
        }
        FileDistributedLock lock = this.locks.get(lockId);
        if (lock != null && !lock.isClosed()) {
            return lock;
        }
        try {
            FileDistributedLock newLock = new FileDistributedLock(this.locks::remove, this.locksFolder, lockId);
            this.locks.put(lockId, newLock);
            return newLock;
        }
        catch (IOException ioEx) {
            throw new ExecutionException(ioEx);
        }
    }

    public MutableLong getMutableLong(final String mutableLongId) throws ExecutionException {
        final FileDistributedLock fileDistributedLock = (FileDistributedLock)this.getDistributedLock("ML:" + mutableLongId);
        return new MutableLong(){
            final /* synthetic */ FileBasedLockManager this$0;
            {
                this.this$0 = this$0;
            }

            public String getMutableLongId() {
                return mutableLongId;
            }

            public long get() throws UnavailableStateException {
                try {
                    return this.this$0.readLong(fileDistributedLock);
                }
                catch (IOException e) {
                    throw new UnavailableStateException((Throwable)e);
                }
            }

            public void set(long value) throws UnavailableStateException {
                try {
                    this.this$0.writeLong(fileDistributedLock, value);
                }
                catch (IOException e) {
                    throw new UnavailableStateException((Throwable)e);
                }
            }

            public void close() {
                fileDistributedLock.close();
            }
        };
    }

    private void writeLong(FileDistributedLock fileDistributedLock, long value) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
        buffer.putLong(value);
        buffer.flip();
        if (fileDistributedLock.getChannel().position(0L).write(buffer) == 8) {
            fileDistributedLock.getChannel().force(false);
        }
    }

    private long readLong(FileDistributedLock fileDistributedLock) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
        if (fileDistributedLock.getChannel().position(0L).read(buffer, 0L) != 8) {
            return 0L;
        }
        buffer.flip();
        return buffer.getLong();
    }
}

