/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.junit;

import java.util.concurrent.TimeUnit;

public class Wait {
    public static final long MAX_WAIT_MILLIS = 30000L;
    public static final int SLEEP_MILLIS = 1000;

    public static boolean waitFor(Condition condition) throws Exception {
        return Wait.waitFor(condition, 30000L);
    }

    public static boolean waitFor(Condition condition, long duration) throws Exception {
        return Wait.waitFor(condition, duration, 1000L);
    }

    public static boolean waitFor(Condition condition, long duration, long sleepMillis) throws Exception {
        long expiry = System.currentTimeMillis() + duration;
        boolean conditionSatisified = condition.isSatisfied();
        while (!conditionSatisified && System.currentTimeMillis() < expiry) {
            TimeUnit.MILLISECONDS.sleep(sleepMillis);
            conditionSatisified = condition.isSatisfied();
        }
        return conditionSatisified;
    }

    public static interface Condition {
        public boolean isSatisfied() throws Exception;
    }
}

