/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQUnsupportedPacketException;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.journal.impl.JournalBase;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalAddRecord;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalAddRecordTX;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalCompleteRecordTX;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalDeleteRecord;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalDeleteRecordTX;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalInternalRecord;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalRollbackRecordTX;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.utils.collections.ConcurrentLongHashMap;

public final class FileWrapperJournal
extends JournalBase {
    private final ReentrantLock lockAppend = new ReentrantLock();
    private final ConcurrentLongHashMap<AtomicInteger> transactions = new ConcurrentLongHashMap();
    private final JournalImpl journal;
    protected volatile JournalFile currentFile;

    public FileWrapperJournal(Journal journal) throws Exception {
        super(journal.getFileFactory().isSupportsCallbacks(), journal.getFileSize());
        this.journal = (JournalImpl)journal;
        this.currentFile = this.journal.setUpCurrentFile(16);
    }

    public void start() throws Exception {
        throw new UnsupportedOperationException();
    }

    public void stop() throws Exception {
        if (this.currentFile.getFile().isOpen()) {
            this.currentFile.getFile().close();
        }
    }

    public boolean isStarted() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendAddRecord(long id, byte recordType, Persister persister, Object record, boolean sync, IOCompletion callback) throws Exception {
        JournalAddRecord addRecord = new JournalAddRecord(true, id, recordType, persister, record);
        this.writeRecord(addRecord, false, -1L, false, callback);
    }

    @Override
    public void flush() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRecord(JournalInternalRecord encoder, boolean tx, long txID, boolean removeTX, IOCompletion callback) throws Exception {
        this.lockAppend.lock();
        try {
            if (callback != null) {
                callback.storeLineUp();
            }
            this.testSwitchFiles(encoder);
            if (txID >= 0L) {
                if (tx) {
                    AtomicInteger value = removeTX ? (AtomicInteger)this.transactions.remove(txID) : (AtomicInteger)this.transactions.get(txID);
                    if (value != null) {
                        encoder.setNumberOfRecords(value.get());
                    }
                } else {
                    this.count(txID);
                }
            }
            encoder.setFileID(this.currentFile.getRecordID());
            if (callback != null) {
                this.currentFile.getFile().write(encoder, false, (IOCallback)callback);
            } else {
                this.currentFile.getFile().write(encoder, false);
            }
        }
        finally {
            this.lockAppend.unlock();
        }
    }

    private void testSwitchFiles(JournalInternalRecord encoder) throws Exception {
        JournalFile oldFile = this.currentFile;
        this.currentFile = this.journal.switchFileIfNecessary(encoder.getEncodeSize());
        if (oldFile != this.currentFile) {
            for (AtomicInteger value : this.transactions.values()) {
                value.set(0);
            }
        }
    }

    @Override
    public void appendDeleteRecord(long id, boolean sync, IOCompletion callback) throws Exception {
        JournalDeleteRecord deleteRecord = new JournalDeleteRecord(id);
        this.writeRecord(deleteRecord, false, -1L, false, callback);
    }

    @Override
    public void appendDeleteRecordTransactional(long txID, long id, EncodingSupport record) throws Exception {
        JournalDeleteRecordTX deleteRecordTX = new JournalDeleteRecordTX(txID, id, record);
        this.writeRecord(deleteRecordTX, false, txID, false, null);
    }

    @Override
    public void appendAddRecordTransactional(long txID, long id, byte recordType, Persister persister, Object record) throws Exception {
        JournalAddRecordTX addRecord = new JournalAddRecordTX(true, txID, id, recordType, persister, record);
        this.writeRecord(addRecord, false, txID, false, null);
    }

    @Override
    public void appendUpdateRecord(long id, byte recordType, Persister persister, Object record, boolean sync, IOCompletion callback) throws Exception {
        JournalAddRecord updateRecord = new JournalAddRecord(false, id, recordType, persister, record);
        this.writeRecord(updateRecord, false, -1L, false, callback);
    }

    @Override
    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, Persister persister, Object record) throws Exception {
        JournalAddRecordTX updateRecordTX = new JournalAddRecordTX(false, txID, id, recordType, persister, record);
        this.writeRecord(updateRecordTX, false, txID, false, null);
    }

    @Override
    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback, boolean lineUpContext) throws Exception {
        JournalCompleteRecordTX commitRecord = new JournalCompleteRecordTX(JournalCompleteRecordTX.TX_RECORD_TYPE.COMMIT, txID, null);
        this.writeRecord(commitRecord, true, txID, true, callback);
    }

    @Override
    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync, IOCompletion callback) throws Exception {
        JournalCompleteRecordTX prepareRecord = new JournalCompleteRecordTX(JournalCompleteRecordTX.TX_RECORD_TYPE.PREPARE, txID, transactionData);
        this.writeRecord(prepareRecord, true, txID, false, callback);
    }

    private int count(long txID) throws ActiveMQException {
        AtomicInteger defaultValue = new AtomicInteger(1);
        AtomicInteger count = (AtomicInteger)this.transactions.putIfAbsent(txID, (Object)defaultValue);
        if (count != null) {
            count.incrementAndGet();
        } else {
            count = defaultValue;
        }
        return count.intValue();
    }

    public String toString() {
        return FileWrapperJournal.class.getName() + "(currentFile=[" + this.currentFile + "], hash=" + super.toString() + ")";
    }

    @Override
    public void appendRollbackRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        JournalRollbackRecordTX rollbackRecord = new JournalRollbackRecordTX(txID);
        this.writeRecord(rollbackRecord, true, txID, true, callback);
    }

    @Override
    public JournalLoadInformation load(LoaderCallback reloadManager) throws Exception {
        throw new ActiveMQUnsupportedPacketException();
    }

    @Override
    public JournalLoadInformation loadInternalOnly() throws Exception {
        throw new ActiveMQUnsupportedPacketException();
    }

    @Override
    public void lineUpContext(IOCompletion callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JournalLoadInformation load(List<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback transactionFailure) throws Exception {
        throw new ActiveMQUnsupportedPacketException();
    }

    @Override
    public int getAlignment() throws Exception {
        throw new ActiveMQUnsupportedPacketException();
    }

    @Override
    public int getNumberOfRecords() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getUserVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void runDirectJournalBlast() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public JournalLoadInformation loadSyncOnly(Journal.JournalState state) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<Long, JournalFile> createFilesForBackupSync(long[] fileIds) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void synchronizationLock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void synchronizationUnlock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forceMoveNextFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JournalFile[] getDataFiles() {
        throw new UnsupportedOperationException();
    }

    @Override
    void scheduleReclaim() {
    }

    @Override
    public SequentialFileFactory getFileFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void scheduleCompactAndBlock(int timeout) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replicationSyncPreserveOldFiles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replicationSyncFinished() {
        throw new UnsupportedOperationException();
    }
}

